/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.NBTTagCompound;
import toast.specialAI.ai.special.ISpecialAI;

public class EntityAIThrow
extends EntityAIBase
implements ISpecialAI {
    private int WEIGHT;
    protected EntityLiving theEntity;
    private EntityLiving throwTarget;
    private byte attackTime;
    private int giveUpDelay;

    public EntityAIThrow() {
    }

    private EntityAIThrow(EntityLiving entity) {
        this.theEntity = entity;
        this.func_75248_a(3);
    }

    @Override
    public String getName() {
        return "throw";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIThrow(entity));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74774_a(this.getName(), (byte)1);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74771_c(this.getName()) > 0;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Thrower knockback resistance", 1.0, 0));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Thrower health boost", 10.0, 0));
        entity.func_70606_j(entity.func_110143_aJ() + 10.0f);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target == null || this.theEntity.field_70154_o != null) {
            return false;
        }
        if (this.theEntity.field_70153_n != null) {
            return true;
        }
        if (this.theEntity.func_70681_au().nextInt(20) == 0) {
            return this.findThrowTarget();
        }
        return false;
    }

    public void func_75249_e() {
        if (this.throwTarget != null) {
            this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, 1.5);
        } else {
            this.theEntity.func_70661_as().func_75497_a((Entity)this.theEntity.func_70638_az(), 1.2);
        }
    }

    public boolean func_75253_b() {
        return this.theEntity.func_70638_az() != null && this.theEntity.field_70154_o == null && (this.throwTarget != null && this.throwTarget.func_70089_S() || this.theEntity.field_70153_n != null);
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75246_d() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (this.throwTarget != null) {
            this.theEntity.func_70671_ap().func_75651_a((Entity)this.throwTarget, 30.0f, 30.0f);
            double range = this.theEntity.field_70130_N * 2.0f * this.theEntity.field_70130_N * 2.0f + this.throwTarget.field_70130_N;
            if (this.theEntity.func_70092_e(this.throwTarget.field_70165_t, this.throwTarget.field_70121_D.field_72338_b, this.throwTarget.field_70161_v) <= range) {
                this.throwTarget.func_70078_a((Entity)this.theEntity);
                this.throwTarget = null;
                this.theEntity.func_70661_as().func_75497_a((Entity)target, 1.2);
                this.theEntity.func_71038_i();
                this.attackTime = (byte)10;
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)this.throwTarget, 1.5);
            }
        }
        if (this.theEntity.field_70153_n != null) {
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            this.attackTime = (byte)(this.attackTime - 1);
            if (this.attackTime <= 0 && this.theEntity.func_70681_au().nextInt(10) == 0 && this.theEntity.func_70068_e((Entity)target) <= 100.0) {
                double dX = target.field_70165_t - this.theEntity.field_70165_t;
                double dZ = target.field_70161_v - this.theEntity.field_70161_v;
                double dH = Math.sqrt(dX * dX + dZ * dZ);
                Entity entity = this.theEntity.field_70153_n;
                entity.func_70078_a((Entity)null);
                entity.field_70159_w = dX / dH + this.theEntity.field_70159_w * 0.2;
                entity.field_70179_y = dZ / dH + this.theEntity.field_70179_y * 0.2;
                entity.field_70181_x = 0.4;
                entity.field_70122_E = false;
                entity.field_70143_R = 0.0f;
                this.theEntity.func_70661_as().func_75499_g();
                this.theEntity.func_71038_i();
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)target, 1.2);
            }
        }
        if (++this.giveUpDelay > 400) {
            this.theEntity.func_70661_as().func_75499_g();
            this.throwTarget = null;
        }
    }

    public void func_75251_c() {
        if (this.theEntity.field_70153_n != null) {
            this.theEntity.field_70153_n.func_70078_a((Entity)null);
        }
        this.theEntity.func_70661_as().func_75499_g();
        this.giveUpDelay = 0;
        this.throwTarget = null;
    }

    private boolean findThrowTarget() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        double distance = this.theEntity.func_70068_e((Entity)target);
        if (distance < 9.0) {
            return false;
        }
        List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.field_70121_D.func_72314_b(16.0, 8.0, 16.0));
        for (Object obj : list) {
            double dist;
            if (!(obj instanceof EntityLiving)) continue;
            EntityLiving entity = (EntityLiving)obj;
            if (!entity.field_70122_E || entity.field_70154_o != null || target != entity.func_70638_az() || entity.func_70068_e((Entity)target) <= 36.0 || !((dist = this.theEntity.func_70068_e((Entity)entity)) < distance)) continue;
            distance = dist;
            this.throwTarget = entity;
        }
        return this.throwTarget != null;
    }
}

