/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.util.DamageSource;
import toast.specialAI.ai.special.ISpecialAI;

public class EntityAICharge
extends EntityAIBase
implements ISpecialAI {
    private static final byte STATE_END = 0;
    private static final byte STATE_START = 1;
    private static final byte STATE_CHARGE = 2;
    private static final byte STATE_STUN = -1;
    private int WEIGHT;
    protected EntityLiving theEntity;
    private float knockbackMult;
    private byte state;
    private byte attackTime;
    private double x;
    private double z;
    private float stepHeight;

    public EntityAICharge() {
    }

    private EntityAICharge(EntityLiving entity, float knockbackMult) {
        this.theEntity = entity;
        this.knockbackMult = knockbackMult;
        this.stepHeight = entity.field_70138_W;
        this.func_75248_a(7);
    }

    @Override
    public String getName() {
        return "charge";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAICharge(entity, aiTag.func_74760_g(this.getName())));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74776_a(this.getName(), 0.5f);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74760_g(this.getName()) > 0.0f;
    }

    @Override
    public void initialize(EntityLiving entity) {
        ItemStack helmet = new ItemStack((Item)Items.field_151024_Q);
        EnchantmentHelper.func_77504_a((Random)entity.func_70681_au(), (ItemStack)helmet, (int)30);
        helmet.func_151001_c("Charger's Helmet");
        Items.field_151024_Q.func_82813_b(helmet, 0xFFFF00);
        entity.func_70062_b(4, helmet);
        entity.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Charger knockback resistance", 1.0, 0));
        entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Charger health boost", 20.0, 0));
        entity.func_70606_j(entity.func_110143_aJ() + 20.0f);
    }

    public boolean func_75250_a() {
        block5: {
            block4: {
                if (!this.theEntity.field_70122_E || this.theEntity.field_70154_o != null) break block4;
                byte by = this.attackTime;
                this.attackTime = (byte)(by - 1);
                if (by <= 0 && this.theEntity.func_70681_au().nextInt(10) == 0) break block5;
            }
            return false;
        }
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target != null) {
            double distance = this.theEntity.func_70068_e((Entity)target);
            return distance <= 256.0 && distance >= 25.0 && this.theEntity.func_70635_at().func_75522_a((Entity)target);
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.state != 0;
    }

    public boolean func_75252_g() {
        return false;
    }

    public void func_75249_e() {
        this.theEntity.func_70661_as().func_75499_g();
        this.attackTime = (byte)30;
        this.state = 1;
        this.theEntity.field_70181_x = 0.3;
        this.theEntity.func_71038_i();
    }

    public void func_75246_d() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        this.attackTime = (byte)(this.attackTime - 1);
        if (this.state == 1) {
            if (target == null || !target.func_70089_S()) {
                this.state = 0;
                return;
            }
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 100.0f, 100.0f);
            if (this.attackTime <= 0) {
                double dX = target.field_70165_t - this.theEntity.field_70165_t;
                double dZ = target.field_70161_v - this.theEntity.field_70161_v;
                double v = Math.sqrt(dX * dX + dZ * dZ);
                this.x = dX / v + this.theEntity.field_70159_w * 0.2;
                this.z = dZ / v + this.theEntity.field_70179_y * 0.2;
                if (this.theEntity.field_70138_W < 1.0f) {
                    this.theEntity.field_70138_W = 1.0f;
                }
                this.theEntity.func_70031_b(true);
                this.attackTime = (byte)20;
                this.state = (byte)2;
            }
        } else if (this.state == 2) {
            this.theEntity.func_70671_ap().func_75650_a(this.theEntity.field_70165_t + this.x, this.theEntity.field_70163_u + (double)this.theEntity.func_70047_e(), this.theEntity.field_70161_v + this.z, 100.0f, 100.0f);
            this.theEntity.field_70159_w = this.x;
            this.theEntity.field_70179_y = this.z;
            boolean hit = false;
            if (target != null) {
                List list = this.theEntity.field_70170_p.func_72839_b((Entity)this.theEntity, this.theEntity.field_70121_D.func_72314_b(0.2, 0.2, 0.2));
                for (int i = 0; i < list.size(); ++i) {
                    if (!target.equals(list.get(i))) continue;
                    hit = true;
                    break;
                }
            }
            if (hit && target != null) {
                this.theEntity.func_70652_k((Entity)target);
                this.theEntity.func_71038_i();
                this.theEntity.field_70159_w *= -0.8;
                this.theEntity.field_70181_x = 0.4;
                this.theEntity.field_70179_y *= -0.8;
                target.field_70159_w += this.x * (double)this.knockbackMult;
                target.field_70181_x = 0.4;
                target.field_70179_y += this.z * (double)this.knockbackMult;
                if (target instanceof EntityPlayerMP) {
                    try {
                        ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity((Entity)target));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.state = 0;
            } else if (this.theEntity.field_70123_F) {
                this.theEntity.func_70097_a(DamageSource.field_82729_p, 5.0f);
                this.theEntity.field_70159_w *= -0.5;
                this.theEntity.field_70181_x = 0.4;
                this.theEntity.field_70179_y *= -0.5;
                this.theEntity.field_70138_W = this.stepHeight;
                this.theEntity.func_70031_b(false);
                this.attackTime = (byte)80;
                this.state = (byte)-1;
            } else if (this.attackTime <= 0 || this.theEntity.func_70072_I() || this.theEntity.func_70058_J()) {
                this.attackTime = (byte)40;
                this.state = 0;
            }
        } else if (this.state == -1) {
            this.theEntity.func_71038_i();
            if (this.attackTime <= 0) {
                this.state = 0;
            }
        }
    }

    public void func_75251_c() {
        this.theEntity.field_70138_W = this.stepHeight;
        this.theEntity.func_70031_b(false);
    }
}

