/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import toast.specialAI.Properties;
import toast.specialAI._SpecialAI;
import toast.specialAI.ai.EntityAIAttackOnCollidePassive;
import toast.specialAI.ai.EntityAIAvoidExplosions;
import toast.specialAI.ai.EntityAIRider;
import toast.specialAI.ai.EntityAIRiderTarget;
import toast.specialAI.ai.grief.EntityAIDig;
import toast.specialAI.ai.grief.EntityAIEatBreedingItem;
import toast.specialAI.ai.grief.EntityAIGriefBlocks;
import toast.specialAI.ai.special.SpecialAIHandler;
import toast.specialAI.util.EntitySet;
import toast.specialAI.village.EntityAIVillagerDefendVillage;

public class AIHandler {
    private static final boolean AVOID_EXPLOSIONS = Properties.getBoolean("_general", "avoid_explosions");
    private static final boolean CALL_FOR_HELP = Properties.getBoolean("_general", "call_for_help");
    private static final double CALL_FOR_HELP_DEATH = Properties.getDouble("_general", "call_for_help_on_death");
    private static final boolean EAT_BREEDING_ITEMS = Properties.getBoolean("_general", "eat_breeding_items");
    private static final EntitySet DEPACIFY_SET = new EntitySet(Properties.getString("_general", "depacify_list"));
    private static final double AGGRESSIVE_CHANCE = Properties.getDouble("_general", "depacify_aggressive_chance");
    private static final boolean GRIEFING = Properties.getBoolean("passive_griefing", "_enabled");
    private static final boolean FIDDLING = Properties.getBoolean("passive_griefing", "_fiddling_enabled");
    private static final EntitySet GRIEF_SET = new EntitySet(Properties.getString("passive_griefing", "mob_list"));
    private static final EntitySet FIDDLE_SET = new EntitySet(Properties.getString("passive_griefing", "mob_list_fiddling"));
    private static final int SCAN_COUNT_GLOBAL = Properties.getInt("passive_griefing", "scan_count_global");
    private static final double RIDER_CHANCE = Properties.getDouble("jockeys", "_rider_chance");
    public static final EntitySet MOUNT_SET = new EntitySet(Properties.getString("jockeys", "mount_list"));
    public static final EntitySet MOUNT_SET_SMALL = new EntitySet(Properties.getString("jockeys", "mount_list_small"));
    private static final EntitySet RIDER_SET = new EntitySet(Properties.getString("jockeys", "rider_list"));
    private static final EntitySet RIDER_SET_SMALL = new EntitySet(Properties.getString("jockeys", "rider_list_small"));
    private static final double SPECIAL_CHANCE_1 = Properties.getDouble("special_ai", "_chance_1");
    private static final EntitySet SPECIAL_SET_1 = new EntitySet(Properties.getString("special_ai", "_mob_list_1"));
    private static final double SPECIAL_CHANCE_2 = Properties.getDouble("special_ai", "_chance_2");
    private static final EntitySet SPECIAL_SET_2 = new EntitySet(Properties.getString("special_ai", "_mob_list_2"));
    private static final double SPECIAL_CHANCE_3 = Properties.getDouble("special_ai", "_chance_3");
    private static final EntitySet SPECIAL_SET_3 = new EntitySet(Properties.getString("special_ai", "_mob_list_3"));
    private static final boolean VILLAGERS_DEFEND = Properties.getBoolean("villages", "villagers_defend");
    private static final String AVOID_EXPLOSIONS_TAG = "AvoidExplosions";
    private static final String DEFEND_VILLAGE_TAG = "DefendVillage";
    private static final String DEPACIFY_TAG = "Depacify";
    public static final String GRIEF_TAG = "Griefing";
    public static final String GRIEF_RANGE_TAG = "GriefScanRange";
    public static final String GRIEF_RANGE_VERTICAL_TAG = "GriefScanRangeVertical";
    public static final String GRIEF_TOOL_TAG = "GriefNeedsTool";
    public static final String GRIEF_LIGHT_TAG = "GriefLights";
    public static final String GRIEF_BLOCK_TAG = "GriefBlocks";
    public static final String GRIEF_EXCEPTION_TAG = "GriefBlacklist";
    public static final String FIDDLE_TAG = "Fiddling";
    public static final String FIDDLE_BLOCK_TAG = "FiddleBlocks";
    public static final String FIDDLE_EXCEPTION_TAG = "FiddleBlacklist";
    private static final String RIDER_TAG = "Rider";
    private static final String UAI_TAG = "uAI";
    private static final String FORCE_INIT_TAG = "ForceInit";
    @Deprecated
    private static final String SPECIAL_TAG = "Special";
    public static final byte BIT_NONE = 0;
    public static final byte BIT_MOVEMENT = 1;
    public static final byte BIT_FACING = 2;
    public static final byte BIT_SWIMMING = 4;
    public static final byte TARGET_BIT = 1;
    private static int scansLeft = SCAN_COUNT_GLOBAL;

    public static boolean canScan() {
        return SCAN_COUNT_GLOBAL <= 0 || scansLeft-- > 0;
    }

    private static void clearAI(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            entity.field_70714_bg.func_85156_a(entry.field_75733_a);
        }
    }

    private static void clearTargetAI(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70715_bh.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            entity.field_70715_bh.func_85156_a(entry.field_75733_a);
        }
    }

    private static void addAvoidExplosionsAI(EntityCreature entity) {
        entity.field_70714_bg.func_75776_a(-1, (EntityAIBase)new EntityAIAvoidExplosions(entity));
    }

    private static void addDefendVillageAI(EntityCreature entity, boolean addedAttackAI) {
        if (!addedAttackAI) {
            entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollidePassive(entity, 0.7, false));
        }
        entity.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIVillagerDefendVillage(entity));
    }

    private static void addHurtByTargetAI(EntityCreature entity, byte depacify, boolean addedAttackAI) {
        if (!addedAttackAI) {
            entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollidePassive(entity, entity instanceof EntityChicken ? 1.8 : 1.4, false));
        }
        entity.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget(entity, CALL_FOR_HELP));
        if (depacify > 1) {
            entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget(entity, EntityPlayer.class, 0, true));
        }
    }

    private static void setHelpAI(EntityCreature entity) {
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70715_bh.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (entry.field_75733_a.getClass() != EntityAIHurtByTarget.class) continue;
            int priority = entry.field_75731_b;
            entity.field_70715_bh.func_85156_a(entry.field_75733_a);
            entity.field_70715_bh.func_75776_a(priority, (EntityAIBase)new EntityAIHurtByTarget(entity, true));
            return;
        }
    }

    private static void addMountAI(EntityCreature entity, boolean addedAttackAI) {
        if (!addedAttackAI) {
            for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
                if (!(entry.field_75733_a instanceof EntityAIAttackOnCollide) && !(entry.field_75733_a instanceof EntityAIArrowAttack)) continue;
                addedAttackAI = true;
                break;
            }
        }
        entity.field_70715_bh.func_75776_a(-1, (EntityAIBase)new EntityAIRiderTarget(entity, addedAttackAI));
    }

    private static void addRiderAI(EntityLiving entity, boolean small) {
        entity.field_70714_bg.func_75776_a(AIHandler.getPassivePriority(entity), (EntityAIBase)new EntityAIRider(entity, small));
    }

    private static void addEatingAI(EntityAnimal entity) {
        entity.field_70714_bg.func_75776_a(AIHandler.getPassivePriority((EntityLiving)entity), (EntityAIBase)new EntityAIEatBreedingItem(entity));
    }

    private static void addGriefAI(EntityLiving entity, boolean griefing, boolean fiddling, NBTTagCompound tag) {
        entity.field_70714_bg.func_75776_a(AIHandler.getPassivePriority(entity), (EntityAIBase)new EntityAIGriefBlocks(entity, griefing, fiddling, tag));
    }

    private static int getPassivePriority(EntityLiving entity) {
        int highest = Integer.MIN_VALUE;
        for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a.toArray(new EntityAITasks.EntityAITaskEntry[0])) {
            if (entry.field_75733_a instanceof EntityAIWander || entry.field_75733_a instanceof EntityAIWatchClosest || entry.field_75733_a instanceof EntityAILookIdle) {
                return entry.field_75731_b;
            }
            if (highest >= entry.field_75731_b) continue;
            highest = entry.field_75731_b;
        }
        return highest + 1;
    }

    private static void addDigAI(EntityLiving entity) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIDig(entity));
    }

    public AIHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            scansLeft = SCAN_COUNT_GLOBAL;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world != null && event.phase == TickEvent.Phase.END) {
            for (int i = 0; i < event.world.field_72996_f.size(); ++i) {
                Object entity = event.world.field_72996_f.get(i);
                if (!(entity instanceof EntityItem)) continue;
                this.equipToThief((EntityItem)entity);
            }
        }
    }

    private void equipToThief(EntityItem item) {
        if (item.getEntityData().func_74764_b("ThiefUUIDMost")) {
            UUID thiefId = new UUID(item.getEntityData().func_74763_f("ThiefUUIDMost"), item.getEntityData().func_74763_f("ThiefUUIDLeast"));
            for (int i = 0; i < item.field_70170_p.field_72996_f.size(); ++i) {
                Object entity = item.field_70170_p.field_72996_f.get(i);
                if (!(entity instanceof EntityLiving) || !thiefId.equals(((EntityLiving)entity).func_110124_au())) continue;
                ((EntityLiving)entity).func_70062_b(0, item.func_92059_d());
                ((EntityLiving)entity).func_96120_a(0, 2.0f);
                ((EntityLiving)entity).func_110163_bv();
                item.func_70106_y();
                return;
            }
            item.getEntityData().func_82580_o("ThiefUUIDMost");
            item.getEntityData().func_82580_o("ThiefUUIDLeast");
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        NBTTagCompound aiTag;
        boolean fiddling;
        if (event.world.field_72995_K || !(event.entity instanceof EntityLiving)) {
            return;
        }
        EntityLiving theEntity = (EntityLiving)event.entity;
        NBTTagCompound tag = _SpecialAI.getTag((Entity)theEntity);
        if (theEntity instanceof EntityCreature) {
            boolean addedAttackAI = false;
            if (!tag.func_74764_b(AVOID_EXPLOSIONS_TAG)) {
                tag.func_74757_a(AVOID_EXPLOSIONS_TAG, AVOID_EXPLOSIONS);
            }
            if (tag.func_74767_n(AVOID_EXPLOSIONS_TAG)) {
                AIHandler.addAvoidExplosionsAI((EntityCreature)theEntity);
            }
            if (!tag.func_74764_b(DEFEND_VILLAGE_TAG)) {
                tag.func_74757_a(DEFEND_VILLAGE_TAG, VILLAGERS_DEFEND && theEntity instanceof EntityVillager);
            }
            if (tag.func_74767_n(DEFEND_VILLAGE_TAG)) {
                AIHandler.addDefendVillageAI((EntityCreature)theEntity, addedAttackAI);
                addedAttackAI = true;
            }
            int depacify = tag.func_74764_b(DEPACIFY_TAG) ? tag.func_74771_c(DEPACIFY_TAG) : (DEPACIFY_SET.contains((Entity)theEntity) ? (theEntity.func_70681_au().nextDouble() < AGGRESSIVE_CHANCE ? 2 : 1) : 0);
            if (depacify > 0) {
                AIHandler.addHurtByTargetAI((EntityCreature)theEntity, (byte)depacify, addedAttackAI);
                addedAttackAI = true;
            } else if (CALL_FOR_HELP) {
                AIHandler.setHelpAI((EntityCreature)theEntity);
            }
            if (MOUNT_SET.contains((Entity)theEntity) || MOUNT_SET_SMALL.contains((Entity)theEntity)) {
                AIHandler.addMountAI((EntityCreature)theEntity, addedAttackAI);
            }
        }
        if (!tag.func_74764_b(RIDER_TAG) && RIDER_CHANCE > 0.0) {
            boolean small = RIDER_SET_SMALL.contains((Entity)theEntity);
            if ((small || RIDER_SET.contains((Entity)theEntity)) && theEntity.func_70681_au().nextDouble() < RIDER_CHANCE) {
                tag.func_74757_a(RIDER_TAG, true);
            } else {
                tag.func_74757_a(RIDER_TAG, false);
            }
        }
        if (tag.func_74767_n(RIDER_TAG)) {
            AIHandler.addRiderAI(theEntity, RIDER_SET_SMALL.contains((Entity)theEntity));
        }
        if (EAT_BREEDING_ITEMS && theEntity instanceof EntityAnimal) {
            AIHandler.addEatingAI((EntityAnimal)theEntity);
        }
        if (!tag.func_74764_b(GRIEF_TAG)) {
            tag.func_74757_a(GRIEF_TAG, GRIEF_SET.contains((Entity)theEntity));
        }
        if (!tag.func_74764_b(FIDDLE_TAG)) {
            tag.func_74757_a(FIDDLE_TAG, FIDDLE_SET.contains((Entity)theEntity));
        }
        boolean griefing = GRIEFING && tag.func_74767_n(GRIEF_TAG);
        boolean bl = fiddling = FIDDLING && tag.func_74767_n(FIDDLE_TAG);
        if (griefing || fiddling) {
            AIHandler.addGriefAI(theEntity, griefing, fiddling, tag);
        }
        if (!tag.func_74764_b(UAI_TAG)) {
            byte aiCode;
            aiTag = new NBTTagCompound();
            tag.func_74782_a(UAI_TAG, (NBTBase)aiTag);
            if (tag.func_74764_b(SPECIAL_TAG) && (aiCode = tag.func_74771_c(SPECIAL_TAG)) > 0) {
                SpecialAIHandler.SPECIAL_AI_LIST[aiCode - 1].save(aiTag);
            }
            if (SPECIAL_CHANCE_1 > 0.0 && SPECIAL_SET_1.contains((Entity)theEntity) && theEntity.func_70681_au().nextDouble() < SPECIAL_CHANCE_1) {
                SpecialAIHandler.saveSpecialAI(theEntity, aiTag);
            }
            if (SPECIAL_CHANCE_2 > 0.0 && SPECIAL_SET_2.contains((Entity)theEntity) && theEntity.func_70681_au().nextDouble() < SPECIAL_CHANCE_2) {
                SpecialAIHandler.saveSpecialAI(theEntity, aiTag);
            }
            if (SPECIAL_CHANCE_3 > 0.0 && SPECIAL_SET_3.contains((Entity)theEntity) && theEntity.func_70681_au().nextDouble() < SPECIAL_CHANCE_3) {
                SpecialAIHandler.saveSpecialAI(theEntity, aiTag);
            }
            if (!tag.func_74764_b(FORCE_INIT_TAG)) {
                tag.func_74757_a(FORCE_INIT_TAG, true);
            }
        } else {
            aiTag = tag.func_74775_l(UAI_TAG);
        }
        SpecialAIHandler.addSpecialAI(theEntity, aiTag, tag.func_74767_n(FORCE_INIT_TAG));
        tag.func_82580_o(FORCE_INIT_TAG);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeath(LivingDeathEvent event) {
        if (CALL_FOR_HELP_DEATH > 0.0 && event.entityLiving instanceof EntityLiving && event.entityLiving.func_70681_au().nextDouble() < CALL_FOR_HELP_DEATH) {
            EntityLiving theEntity = (EntityLiving)event.entityLiving;
            Entity target = event.source.func_76346_g();
            if (target instanceof EntityLivingBase) {
                IAttributeInstance attribute = theEntity.func_110148_a(SharedMonsterAttributes.field_111265_b);
                double range = attribute == null ? 16.0 : attribute.func_111126_e();
                List entities = theEntity.field_70170_p.func_72839_b((Entity)theEntity, AxisAlignedBB.func_72330_a((double)theEntity.field_70165_t, (double)theEntity.field_70163_u, (double)theEntity.field_70161_v, (double)(theEntity.field_70165_t + 1.0), (double)(theEntity.field_70163_u + 1.0), (double)(theEntity.field_70161_v + 1.0)).func_72314_b(range, 10.0, range));
                for (Object entity : entities) {
                    EntityLiving alliedEntity;
                    if (!(entity instanceof EntityLiving) || !entity.getClass().isAssignableFrom(theEntity.getClass()) && !theEntity.getClass().isAssignableFrom(entity.getClass()) || (alliedEntity = (EntityLiving)entity).func_70638_az() != null || alliedEntity.func_142014_c((EntityLivingBase)target)) continue;
                    alliedEntity.func_70624_b((EntityLivingBase)target);
                }
            }
        }
    }
}

