/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI;

import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import toast.specialAI._SpecialAI;
import toast.specialAI.ai.special.ISpecialAI;
import toast.specialAI.ai.special.SpecialAIHandler;

public abstract class Properties {
    private static final HashMap<String, Object> map = new HashMap();
    public static final String GENERAL = "_general";
    public static final String JOCKEYS = "jockeys";
    public static final String FIDDLING = "passive_fiddling";
    public static final String GRIEFING = "passive_griefing";
    public static final String SPECIAL_AI = "special_ai";
    public static final String VILLAGES = "villages";

    public static void init(Configuration config) {
        config.load();
        Properties.add(config, GENERAL, "avoid_explosions", true, "(True/false) If true, all mobs will try to avoid TNT and creepers about to explode. Default is true.");
        Properties.add(config, GENERAL, "break_speed", 0.5, "(0.0-INFINITY) The block breaking speed multiplier for mobs, relative to the player's block breaking speed. Default is 50% speed.");
        Properties.add(config, GENERAL, "call_for_help", true, "(True/false) If true, all mobs will call for help from nearby mobs of the same type when struck. Default is true.");
        Properties.add(config, GENERAL, "call_for_help_on_death", 0.2, "(0.0-1.0) Chance for mobs to call for help from a killing blow. Default is 20% chance.");
        Properties.add(config, GENERAL, "depacify_aggressive_chance", 0.005, "(0.0-1.0) Chance for a depacify list to be aggressive, instead of just neutral. Default is 0.5% chance.");
        Properties.add(config, GENERAL, "depacify_list", "Chicken,Cow,Pig,Sheep", "(Entity list) Comma-separated list of passive mobs (by entity id) that are made \"neutral\".\nYou may put a tilde (~) in front of any entity id to make it specific. Specific entity ids will not count any entities extending (i.e., based on) the specified entity.\nMay or may not work on mod mobs. Defaults to any kind of chicken, cow, pig, and sheep.");
        Properties.add(config, GENERAL, "eat_breeding_items", true, "(True/false) If true, passive mobs will seek out and eat the items used to breed them laying on the floor. Default is true.");
        Properties.add(config, GENERAL, "eating_heals", true, "(True/false) If true, when mobs eat breeding items off the floor, they will regain health like wolves. Default is true.");
        Properties.add(config, JOCKEYS, "_rider_chance", 0.1, "(0.0-1.0) Chance for a valid rider mob to actually get the rider AI. Default is 10% chance.");
        Properties.add(config, JOCKEYS, "mount_list", "Spider,Pig,Sheep,Cow", "(Entity list) List of mobs that can be ridden on by normal-sized riders (normally non-aggressive mobs must have pathfinding AI enabled). Defaults to any kind of spider, pig, sheep, or cow.");
        Properties.add(config, JOCKEYS, "mount_list_small", "Chicken", "(Entity list) List of mobs that can be ridden on by small riders or normal-sized riders that are babies (normally non-aggressive mobs must have pathfinding AI enabled). Defaults to any kind of chicken.");
        Properties.add(config, JOCKEYS, "rider_list", "Zombie,Skeleton,Creeper", "(Entity list) List of mobs that can ride normal-sized mounts (note that the entity must have pathfinding AI enabled). Defaults to any kind of zombie, skeleton, or creeper.");
        Properties.add(config, JOCKEYS, "rider_list_small", "", "(Entity list) List of mobs that can only ride small mounts (note that the entity must have pathfinding AI enabled). Defaults to none.");
        Properties.add(config, GRIEFING, "_enabled", true, "(True/false) If true, mobs will passively grief you while not doing anything else. Default is true.");
        Properties.add(config, GRIEFING, "_fiddling_enabled", true, "(True/false) If true, mobs will passively flip switches, press buttons, etc. while not doing anything else (uses the same range, reach, etc. as griefing, but has separate entity and block lists). Default is true.");
        Properties.add(config, GRIEFING, "break_lights", true, "(True/false) If true, block breaking AI will automatically target all light sources. Default is true.");
        Properties.add(config, GRIEFING, "break_sound", false, "(True/false) If true, a lound snapping sound will be played when greifing, which is audible regardless of distance. Default is false.");
        Properties.add(config, GRIEFING, "grief_range", 3.5, "(0.0-INFINITY) Mobs' reach (from eye height) when griefing blocks. Player reach is about 4.5. Default is 3.5.");
        Properties.add(config, GRIEFING, "grief_scan_range", 12, "(Integer >= 0) The range at which mobs will search for blocks to grief horizontally. Default is 12 blocks.");
        Properties.add(config, GRIEFING, "grief_scan_range_vertical", 6, "(Integer >= 0) The range at which mobs will search for blocks to grief vertically. Default is 6 blocks.");
        Properties.add(config, GRIEFING, "leave_drops", true, "(True/false) If true, griefed blocks will leave item drops. Default is true.");
        Properties.add(config, GRIEFING, "mad_creepers", true, "(True/false) If true, creepers will be very mad about not having arms to break things with, and resort to what they know best... Default is true.");
        Properties.add(config, GRIEFING, "mob_list", "Zombie,Creeper", "(Entity list) List of mobs that gain passive griefing AI (note that the entity must have pathfinding AI enabled). Defaults to any kind of zombie or creeper.");
        Properties.add(config, GRIEFING, "mob_list_fiddling", "Zombie,Skeleton", "(Entity list) List of mobs that gain passive fiddling AI (note that the entity must have pathfinding AI enabled). Defaults to any kind of zombie or skeleton.");
        Properties.add(config, GRIEFING, "requires_tools", false, "(True/false) If true, mobs will only target blocks they have the tools to harvest. Default is false.");
        Properties.add(config, GRIEFING, "scan_count", 24, "(Integer >= 1) The number of blocks mobs randomly search to grief/fiddle with each 3 ticks. Default is 24 blocks.");
        Properties.add(config, GRIEFING, "scan_count_global", 0, "(Integer >= 0) The maximum number of blocks that can be searched in any given tick by all mobs. Default is 0 blocks (no limit).");
        Properties.add(config, GRIEFING, "target_blacklist", "", "(Block list) Specific blocks that will NOT be griefed by mobs. Defaults to none.\nOnly really useful if \"break_lights\" is enabled or when you whitelist an entire namespace (*) to create safe light sources, prevent mobs from breaking normal world gen that produces light, or for removing a few blocks from a namespace that you don't want mobs to break.");
        Properties.add(config, GRIEFING, "target_blocks", Properties.string(Blocks.field_150458_ak) + "," + Properties.string(Blocks.field_150324_C) + "," + Properties.string(Blocks.field_150462_ai) + "," + Properties.string(Blocks.field_150466_ao) + "," + Properties.string(Blocks.field_150415_aT) + "," + Properties.string(Blocks.field_150396_be) + "," + Properties.string(Blocks.field_150468_ap), "(Block list) Specific blocks that will be griefed by mobs. Defaults to farmland, beds, crafting tables, wooden doors, wooden trapdoors, fence gates, and ladders.\nThis is a comma-separated list. You may specify metadata (0-15) with a space after the id, followed by the metadata. For example, \"cake\" will cause mobs to target all cakes, while \"cake 0\" will cause mobs to only target cakes that have not been partially eaten.\nYou may whitelist an entire namespace (mod) by using the namespace followed by a *. For example, \"minecraft:*\" will whitelist every vanilla block. This does not work if you try to also specify metadata.");
        Properties.add(config, GRIEFING, "target_fiddling_blacklist", "", "(Block list) Specific blocks that will NOT be fiddled with by mobs. Defaults to none.\nOnly really useful if you whitelist an entire namespace (*) to prevent mobs from fiddling with a few blocks from that namespace.");
        Properties.add(config, GRIEFING, "target_fiddling_blocks", Properties.string(Blocks.field_150442_at) + "," + Properties.string(Blocks.field_150471_bO) + "," + Properties.string(Blocks.field_150430_aB) + "," + Properties.string((Block)Blocks.field_150441_bU) + "," + Properties.string((Block)Blocks.field_150455_bV) + "," + Properties.string((Block)Blocks.field_150413_aR) + "," + Properties.string((Block)Blocks.field_150416_aS) + "," + Properties.string(Blocks.field_150414_aQ), "(Block list) Specific blocks that will be fiddled with by mobs. Defaults to levers, wooden buttons, stone buttons, comparators (on/off), repeaters (on/off), and cakes.");
        Properties.add(config, SPECIAL_AI, "_chance_1", 0.05, "(0.0-1.0) Chance for a valid mob in mob_list_1 to get a special AI pattern. Default is 5% chance.");
        Properties.add(config, SPECIAL_AI, "_chance_2", 0.05, "(0.0-1.0) Same as _chance_1, but for for mob_list_2. Multiple AIs can be stacked. Default is 5% chance.");
        Properties.add(config, SPECIAL_AI, "_chance_3", 0.2, "(0.0-1.0) Same as _chance_1, but for for mob_list_3. Multiple AIs can be stacked. Default is 20% chance.");
        Properties.add(config, SPECIAL_AI, "_mob_list_1", "Zombie,Skeleton", "(Entity list) List of mobs that can gain special AI patterns (note that the entity must have pathfinding AI enabled). Defaults to any kind of zombie or skeleton.");
        Properties.add(config, SPECIAL_AI, "_mob_list_2", "Zombie", "(Entity list) Same as mob_list_1, but uses _chance_2. Defaults to any kind of zombie.");
        Properties.add(config, SPECIAL_AI, "_mob_list_3", "Skeleton", "(Entity list) Same as mob_list_1, but uses _chance_3. Defaults to any kind of skeleton.");
        for (ISpecialAI ai : SpecialAIHandler.SPECIAL_AI_LIST) {
            ai.setWeight(Math.max(0, config.get(SPECIAL_AI, "ai_" + ai.getName(), 1).getInt(1)));
            SpecialAIHandler.AI_WEIGHT += ai.getWeight();
        }
        Properties.add(config, VILLAGES, "block_aggression_chance", 0.1, "(0.0-1.0) Chance for you to be marked as an aggressor (to be attacked) when you break a block in a village that is not on the \"block_blacklist\". Default is 10% chance.");
        Properties.add(config, VILLAGES, "block_aggression_limit", -5, "(-30-+10) The \"block_aggression_chance\" only triggers if your reputation in the village is equal to or less than this limit. Default is -5.");
        Properties.add(config, VILLAGES, "block_blacklist", "wooden_door,spruce_door,birch_door,jungle_door,acacia_door,dark_oak_door,stone,grass,dirt,sand,leaves,leaves2,wheat,potatoes,carrots,pumpkin_stem,melon_stem,reeds,nether_wart,pumpkin,melon_block,cocoa,cactus,tallgrass,brown_mushroom,red_mushroom,yellow_flower,double_plant,deadbush,snow_layer,ice", "(Block list) Specific blocks that will NOT aggro villagers when broken. Defaults to wooden doors, stone, grass, dirt, sand, leaves, plants (except poppies and trees), snow cover, and ice.");
        Properties.add(config, VILLAGES, "block_rep_loss_chance", 0.1, "(0.0-1.0) Chance for you to lose 1 reputation when you break a block in a village that is not on the \"block_blacklist\". Default is 10% chance.");
        Properties.add(config, VILLAGES, "block_rep_loss_limit", 8, "(-30-+10) The \"block_rep_loss_chance\" only triggers if your reputation in the village is equal to or less than this limit. Default is 8.");
        Properties.add(config, VILLAGES, "block_special_aggression_chance", 1.0, "(0.0-1.0) Chance for you to be marked as an aggressor (to be attacked) when you break a block in a village that is on the \"block_special_list\". Only triggers if your reputation in the village is -5 or less. Default is 100% chance.");
        Properties.add(config, VILLAGES, "block_special_list", "emerald_block", "(Block list) Specific blocks that use a separate chance for aggression and rep loss from other blocks. Defaults to emerald blocks.");
        Properties.add(config, VILLAGES, "block_special_rep_loss_chance", 1.0, "(0.0-1.0) Chance for you to lose 1 reputation when you break a block in a village that is on the \"block_special_list\". Default is 100% chance.");
        Properties.add(config, VILLAGES, "block_whitelist", "", "(Block list) Specific blocks that WILL aggro villagers when broken. If any blocks are specified here, they will then be the only blocks that aggro villagers. Default is none.");
        Properties.add(config, VILLAGES, "help_rep_chance", 0.2, "(0.0-1.0) Chance for you to earn 1 reputation for each monster killed near a village. The only reasonable way to restore rep from below -14 with \"villagers_defend\" enabled. Default is 20% chance.");
        Properties.add(config, VILLAGES, "house_rep", true, "(True/false) If true, all players known to a village will gain 1 rep when a new house is added to a village and lose 1 rep when a house is lost. Highly recommended to keep \"refresh_houses\" enabled when this is. Default is true.");
        Properties.add(config, VILLAGES, "refresh_houses", true, "(True/false) If true, houses will stay a part of a village permanently once added (until their doors are destroyed or all villagers in the village are killed), instead of being constantly added/removed as villagers move around.\nAlso potentially fixes a bug causing village reputation to reset when wandering too far from a village. Default is true.");
        Properties.add(config, VILLAGES, "villagers_defend", true, "(True/false) If true, villagers will defend their village by attacking its aggressors and players with bad reputation (<= -15), just like iron golems do. Default is true.");
        config.addCustomCategoryComment(GENERAL, "General and miscellaneous options.");
        config.addCustomCategoryComment(JOCKEYS, "Options relating to which mobs should act as riders or mounts.");
        config.addCustomCategoryComment(GRIEFING, "Options to customize monsters' passive block griefing.");
        config.addCustomCategoryComment(SPECIAL_AI, "Options to control the types of special AI and their weighted chances of occurring.");
        config.addCustomCategoryComment(VILLAGES, "Options to control village aggression and reputation.");
        config.save();
    }

    private static String string(Block block) {
        return Block.field_149771_c.func_148750_c((Object)block);
    }

    public static Random random() {
        return _SpecialAI.random;
    }

    public static void debugException(String message) {
        _SpecialAI.debugException(message);
    }

    public static void add(Configuration config, String category, String field, String defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getString());
    }

    public static void add(Configuration config, String category, String field, int defaultValue) {
        map.put(category + "@" + field, config.get(category, field, defaultValue).getInt(defaultValue));
    }

    public static void add(Configuration config, String category, String field, int defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getInt(defaultValue));
    }

    public static void add(Configuration config, String category, String field, int defaultValue, int minValue, int maxValue) {
        map.put(category + "@" + field, Math.max(minValue, Math.min(maxValue, config.get(category, field, defaultValue).getInt(defaultValue))));
    }

    public static void add(Configuration config, String category, String field, int defaultValue, int minValue, int maxValue, String comment) {
        map.put(category + "@" + field, Math.max(minValue, Math.min(maxValue, config.get(category, field, defaultValue, comment).getInt(defaultValue))));
    }

    public static void add(Configuration config, String category, String field, boolean defaultValue) {
        map.put(category + "@" + field, config.get(category, field, defaultValue).getBoolean(defaultValue));
    }

    public static void add(Configuration config, String category, String field, boolean defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getBoolean(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue) {
        map.put(category + "@" + field, config.get(category, field, defaultValue).getDouble(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue, String comment) {
        map.put(category + "@" + field, config.get(category, field, defaultValue, comment).getDouble(defaultValue));
    }

    public static void add(Configuration config, String category, String field, double defaultValue, double minValue, double maxValue, String comment) {
        map.put(category + "@" + field, Math.max(minValue, Math.min(maxValue, config.get(category, field, defaultValue, comment).getDouble(defaultValue))));
    }

    public static Object getProperty(String category, String field) {
        return map.get(category + "@" + field);
    }

    public static String getString(String category, String field) {
        return Properties.getProperty(category, field).toString();
    }

    public static boolean getBoolean(String category, String field) {
        return Properties.getBoolean(category, field, Properties.random());
    }

    public static boolean getBoolean(String category, String field, Random random) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof Integer) {
            return random.nextInt(((Number)property).intValue()) == 0;
        }
        if (property instanceof Double) {
            return random.nextDouble() < ((Number)property).doubleValue();
        }
        Properties.debugException("Tried to get boolean for invalid property! @" + property.getClass().getName());
        return false;
    }

    public static int getInt(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1 : 0;
        }
        Properties.debugException("Tried to get int for invalid property! @" + property.getClass().getName());
        return 0;
    }

    public static double getDouble(String category, String field) {
        Object property = Properties.getProperty(category, field);
        if (property instanceof Number) {
            return ((Number)property).doubleValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1.0 : 0.0;
        }
        Properties.debugException("Tried to get double for invalid property! @" + property.getClass().getName());
        return 0.0;
    }
}

