/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.MeaningfulAEStackIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;

public final class IAEStackList
implements IItemList<IAEStack<?>> {
    private final IItemList<IAEItemStack> itemList = AEApi.instance().storage().createItemList();
    private final IItemList<IAEFluidStack> fluidList = AEApi.instance().storage().createFluidList();

    @Override
    public void add(IAEStack<?> option) {
        if (option != null) {
            if (option.isItem()) {
                this.itemList.add((IAEItemStack)option);
            } else {
                this.fluidList.add((IAEFluidStack)option);
            }
        }
    }

    @Override
    public IAEStack<?> findPrecise(IAEStack<?> stack) {
        if (stack != null) {
            if (stack.isItem()) {
                return this.itemList.findPrecise((IAEItemStack)stack);
            }
            return this.fluidList.findPrecise((IAEFluidStack)stack);
        }
        return null;
    }

    @Override
    public Collection<IAEStack<?>> findFuzzy(IAEStack<?> filter, FuzzyMode fuzzy) {
        if (filter != null) {
            if (filter.isItem()) {
                return Collections.singleton((IAEStack)((Object)this.itemList.findFuzzy((IAEItemStack)filter, fuzzy)));
            }
            return Collections.singleton((IAEStack)((Object)this.fluidList.findFuzzy((IAEFluidStack)filter, fuzzy)));
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public void addStorage(IAEStack<?> option) {
        if (option != null) {
            if (option.isItem()) {
                this.itemList.addStorage((IAEItemStack)option);
            } else {
                this.fluidList.addStorage((IAEFluidStack)option);
            }
        }
    }

    @Override
    public void addCrafting(IAEStack<?> option) {
        if (option != null) {
            if (option.isItem()) {
                this.itemList.addCrafting((IAEItemStack)option);
            } else {
                this.fluidList.addCrafting((IAEFluidStack)option);
            }
        }
    }

    @Override
    public void addRequestable(IAEStack<?> option) {
        if (option != null) {
            if (option.isItem()) {
                this.itemList.addRequestable((IAEItemStack)option);
            } else {
                this.fluidList.addRequestable((IAEFluidStack)option);
            }
        }
    }

    @Override
    public IAEStack<?> getFirstItem() {
        Iterator<IAEStack<?>> iterator = this.iterator();
        if (iterator.hasNext()) {
            IAEStack<?> stackType = iterator.next();
            return stackType;
        }
        return null;
    }

    @Override
    public int size() {
        return this.itemList.size() + this.fluidList.size();
    }

    @Override
    @Nonnull
    public Iterator<IAEStack<?>> iterator() {
        return new MeaningfulAEStackIterator(new Iterator<IAEStack<?>>(){
            private final Iterator<IAEItemStack> itemIterator;
            private final Iterator<IAEFluidStack> fluidIterator;
            private Iterator<?> currentIterator;
            {
                this.itemIterator = IAEStackList.this.itemList.iterator();
                this.fluidIterator = IAEStackList.this.fluidList.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.itemIterator.hasNext()) {
                    this.currentIterator = this.itemIterator;
                    return true;
                }
                if (this.fluidIterator.hasNext()) {
                    this.currentIterator = this.fluidIterator;
                    return true;
                }
                return false;
            }

            @Override
            public IAEStack<?> next() {
                return (IAEStack)this.currentIterator.next();
            }

            @Override
            public void remove() {
                this.currentIterator.remove();
            }
        });
    }

    @Override
    public void resetStatus() {
        for (IAEStack<?> i : this) {
            i.reset();
        }
    }

    @Override
    public byte getStackType() {
        return 3;
    }
}

