/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.InventoryAdaptor;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class AdaptorConduitBandle
extends InventoryAdaptor {
    IItemConduit itemConduit;
    ILiquidConduit fluidConduit;
    ForgeDirection toAdaptor;

    public AdaptorConduitBandle(TileConduitBundle tileEntity, ForgeDirection direction) {
        this.toAdaptor = direction;
        IItemConduit ic = (IItemConduit)tileEntity.getConduit(IItemConduit.class);
        this.itemConduit = ic != null && ic.isConnectedTo(direction) ? ic : null;
        ILiquidConduit ilc = (ILiquidConduit)tileEntity.getConduit(ILiquidConduit.class);
        this.fluidConduit = ilc != null && ilc.isConnectedTo(direction) ? ilc : null;
    }

    @Override
    public ItemStack removeItems(int amount, ItemStack filter, IInventoryDestination destination) {
        return null;
    }

    @Override
    public ItemStack simulateRemove(int amount, ItemStack filter, IInventoryDestination destination) {
        return null;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        return null;
    }

    @Override
    public ItemStack addItems(ItemStack toBeAdded) {
        return this.itemConduit != null ? this.itemConduit.insertItem(this.toAdaptor, toBeAdded) : toBeAdded;
    }

    @Override
    public IAEStack<?> addStack(IAEStack<?> toBeAdded, InsertionMode insertionMode) {
        if (toBeAdded.getStackSize() < Integer.MAX_VALUE) {
            if (toBeAdded instanceof IAEFluidStack) {
                IAEFluidStack ifs = (IAEFluidStack)toBeAdded;
                return this.fill(ifs, true);
            }
            return super.addStack(toBeAdded, insertionMode);
        }
        return toBeAdded;
    }

    @Override
    public IAEStack<?> simulateAddStack(IAEStack<?> toBeSimulated, InsertionMode insertionMode) {
        if (toBeSimulated.getStackSize() < Integer.MAX_VALUE) {
            if (toBeSimulated instanceof IAEFluidStack) {
                IAEFluidStack ifs = (IAEFluidStack)toBeSimulated;
                return this.fill(ifs, false);
            }
            return super.simulateAddStack(toBeSimulated, insertionMode);
        }
        return toBeSimulated;
    }

    @Override
    public ItemStack simulateAdd(ItemStack toBeSimulated) {
        return null;
    }

    private IAEStack<?> fill(IAEFluidStack ifs, boolean doFill) {
        if (this.fluidConduit != null) {
            FluidStack fs = ifs.getFluidStack();
            int originalSize = fs.amount;
            int inserted = this.fluidConduit.fill(this.toAdaptor, fs, doFill);
            if (inserted == 0) {
                return ifs;
            }
            if (inserted < originalSize) {
                ifs.setStackSize(originalSize - inserted);
            } else {
                return null;
            }
        }
        return ifs;
    }

    @Override
    public boolean containsItems() {
        if (this.fluidConduit != null) {
            for (FluidTankInfo tank : this.fluidConduit.getTankInfo(this.toAdaptor)) {
                FluidStack fluid = tank.fluid;
                if (fluid == null || fluid.amount <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return null;
    }
}

