/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.FuzzyMode;
import appeng.api.config.InsertionMode;
import appeng.api.parts.IPart;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.helpers.IInterfaceHost;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IBetterStorage;
import appeng.integration.abstraction.IThaumicTinkerer;
import appeng.parts.p2p.PartP2PItems;
import appeng.parts.p2p.PartP2PLiquids;
import appeng.tile.misc.TileInterface;
import appeng.tile.networking.TileCableBus;
import appeng.tile.storage.TileChest;
import appeng.util.Platform;
import appeng.util.inv.AdaptorConduitBandle;
import appeng.util.inv.AdaptorDualityInterface;
import appeng.util.inv.AdaptorFluidHandler;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorItemIO;
import appeng.util.inv.AdaptorList;
import appeng.util.inv.AdaptorMEChest;
import appeng.util.inv.AdaptorP2PFluid;
import appeng.util.inv.AdaptorP2PItem;
import appeng.util.inv.AdaptorPlayerInventory;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.inv.WrapperMCISidedInventory;
import appeng.util.item.AEItemStack;
import com.gtnewhorizon.gtnhlib.capability.CapabilityProvider;
import com.gtnewhorizon.gtnhlib.capability.item.ItemIO;
import com.gtnewhorizon.gtnhlib.util.ItemUtil;
import crazypants.enderio.conduit.TileConduitBundle;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class InventoryAdaptor
implements Iterable<ItemSlot> {
    private static int counter = 0;
    public static final int ALLOW_ITEMS = 1 << counter++;
    public static final int ALLOW_FLUIDS = 1 << counter++;
    public static final int FOR_INSERTS = 1 << counter++;
    public static final int FOR_EXTRACTS = 1 << counter++;
    public static final int DEFAULT = ALLOW_ITEMS | ALLOW_FLUIDS | FOR_INSERTS | FOR_EXTRACTS;

    public static InventoryAdaptor getAdaptor(Object te, ForgeDirection d) {
        return InventoryAdaptor.getAdaptor(te, d, DEFAULT);
    }

    public static InventoryAdaptor getAdaptor(Object te, ForgeDirection d, int flags) {
        IInventory i;
        IFluidHandler tank;
        CapabilityProvider provider;
        InventoryAdaptor adaptor;
        if (te == null) {
            return null;
        }
        boolean invs = (flags & ALLOW_ITEMS) != 0;
        boolean tanks = (flags & ALLOW_FLUIDS) != 0;
        IBetterStorage bs = (IBetterStorage)IntegrationRegistry.INSTANCE.getInstanceIfEnabled(IntegrationType.BetterStorage);
        IThaumicTinkerer tt = (IThaumicTinkerer)IntegrationRegistry.INSTANCE.getInstanceIfEnabled(IntegrationType.ThaumicTinkerer);
        if (tt != null && tt.isTransvectorInterface(te)) {
            te = tt.getTile(te);
        }
        if (te instanceof CapabilityProvider && (adaptor = (InventoryAdaptor)(provider = (CapabilityProvider)te).getCapability(InventoryAdaptor.class, d)) != null) {
            return adaptor;
        }
        if (invs && Platform.isEIOLoaded && te instanceof TileConduitBundle) {
            TileConduitBundle tcb = (TileConduitBundle)te;
            return new AdaptorConduitBandle(tcb, d);
        }
        if (invs && te instanceof EntityPlayer) {
            return new AdaptorIInventory(new AdaptorPlayerInventory((IInventory)((EntityPlayer)te).field_71071_by, false));
        }
        if (invs && te instanceof ArrayList) {
            ArrayList list = (ArrayList)te;
            return new AdaptorList(list);
        }
        if (invs && bs != null && bs.isStorageCrate(te)) {
            return bs.getAdaptor(te, d);
        }
        if (invs && te instanceof TileEntityChest) {
            return new AdaptorIInventory(Platform.GetChestInv(te));
        }
        if (te instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)te;
            if (invs && te instanceof TileInterface) {
                return new AdaptorDualityInterface((IInventory)new WrapperMCISidedInventory(sided, d), (IInterfaceHost)te);
            }
            if (te instanceof TileCableBus) {
                TileCableBus cableBus = (TileCableBus)te;
                IPart part = cableBus.getPart(d);
                if (invs && part instanceof IInterfaceHost) {
                    IInterfaceHost host = (IInterfaceHost)((Object)part);
                    return new AdaptorDualityInterface((IInventory)new WrapperMCISidedInventory(sided, d), host);
                }
                if (invs && part instanceof PartP2PItems) {
                    PartP2PItems p2p = (PartP2PItems)part;
                    return new AdaptorP2PItem(p2p);
                }
                if (tanks && part instanceof PartP2PLiquids) {
                    PartP2PLiquids p2p = (PartP2PLiquids)part;
                    return new AdaptorP2PFluid(p2p, d);
                }
            }
            if (invs && te instanceof TileChest) {
                return new AdaptorMEChest(new WrapperMCISidedInventory(sided, d), (TileChest)te);
            }
        }
        if (tanks && te instanceof IFluidHandler && (tank = (IFluidHandler)te).getTankInfo(d) != null && tank.getTankInfo(d).length > 0) {
            return new AdaptorFluidHandler(tank, d);
        }
        if (invs) {
            ItemIO itemIO;
            int ioFlags = 0;
            if ((flags & FOR_INSERTS) != 0) {
                ioFlags |= ItemUtil.FOR_INSERTS;
            }
            if ((flags & FOR_EXTRACTS) != 0) {
                ioFlags |= ItemUtil.FOR_EXTRACTS;
            }
            if ((itemIO = ItemUtil.getItemIO((Object)te, (ForgeDirection)d, (int)ioFlags)) != null) {
                return new AdaptorItemIO(itemIO);
            }
        }
        if (te instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)te;
            int[] slots = sided.func_94128_d(d.ordinal());
            if (invs && sided.func_70302_i_() > 0 && slots != null && slots.length > 0) {
                return new AdaptorIInventory(new WrapperMCISidedInventory(sided, d));
            }
        }
        if (tanks && te instanceof IFluidHandler && (tank = (IFluidHandler)te).getTankInfo(d) != null && tank.getTankInfo(d).length > 0) {
            return new AdaptorFluidHandler(tank, d);
        }
        if (invs && te instanceof IInventory && (i = (IInventory)te).func_70302_i_() > 0) {
            return new AdaptorIInventory(i);
        }
        return null;
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out, int iteration) {
        return out;
    }

    public abstract ItemStack removeItems(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack simulateRemove(int var1, ItemStack var2, IInventoryDestination var3);

    public abstract ItemStack removeSimilarItems(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack simulateSimilarRemove(int var1, ItemStack var2, FuzzyMode var3, IInventoryDestination var4);

    public abstract ItemStack addItems(ItemStack var1);

    public ItemStack addItems(ItemStack toBeAdded, InsertionMode insertionMode) {
        return this.addItems(toBeAdded);
    }

    public abstract ItemStack simulateAdd(ItemStack var1);

    public ItemStack simulateAdd(ItemStack toBeSimulated, InsertionMode insertionMode) {
        return this.simulateAdd(toBeSimulated);
    }

    public IAEStack<?> addStack(IAEStack<?> toBeAdded, InsertionMode insertionMode) {
        if (toBeAdded.getStackSize() < Integer.MAX_VALUE && toBeAdded instanceof IAEItemStack) {
            IAEItemStack ais = (IAEItemStack)toBeAdded;
            return AEItemStack.create(this.addItems(ais.getItemStack(), insertionMode));
        }
        return toBeAdded;
    }

    public IAEStack<?> simulateAddStack(IAEStack<?> toBeSimulated, InsertionMode insertionMode) {
        if (toBeSimulated.getStackSize() < Integer.MAX_VALUE && toBeSimulated instanceof IAEItemStack) {
            IAEItemStack ais = (IAEItemStack)toBeSimulated;
            return AEItemStack.create(this.simulateAdd(ais.getItemStack(), insertionMode));
        }
        return toBeSimulated;
    }

    public abstract boolean containsItems();
}

