/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridHost;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.ISimplifiedBundle;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.WorldCoord;
import appeng.block.crafting.BlockAdvancedCraftingUnit;
import appeng.core.AEConfig;
import appeng.crafting.MECraftingInventory;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.AENetworkProxyMultiblock;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import appeng.util.Platform;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCraftingTile
extends AENetworkTile
implements IAEMultiBlock,
IPowerChannelState {
    private final CraftingCPUCalculator calc = new CraftingCPUCalculator(this);
    private ISimplifiedBundle lightCache;
    private NBTTagCompound previousState = null;
    private boolean isCoreBlock = false;
    private CraftingCPUCluster cluster;
    private static final int ACCELERATOR_SCALE_FACTOR = 4;

    public TileCraftingTile() {
        this.getProxy().setFlags(GridFlags.MULTIBLOCK, GridFlags.REQUIRE_CHANNEL);
        this.getProxy().setValidSides(EnumSet.noneOf(ForgeDirection.class));
    }

    @Override
    protected AENetworkProxy createProxy() {
        return new AENetworkProxyMultiblock(this, "proxy", this.getItemFromTile(this), true);
    }

    @Override
    protected ItemStack getItemFromTile(Object obj) {
        if (((TileCraftingTile)obj).isAccelerator()) {
            if (((TileCraftingTile)obj).func_145838_q() instanceof BlockAdvancedCraftingUnit) {
                Iterator iterator = AEApi.instance().definitions().blocks().craftingAccelerator64x().maybeStack(1).asSet().iterator();
                if (iterator.hasNext()) {
                    ItemStack accelerator = (ItemStack)iterator.next();
                    return accelerator;
                }
            } else {
                Iterator iterator = AEApi.instance().definitions().blocks().craftingAccelerator().maybeStack(1).asSet().iterator();
                if (iterator.hasNext()) {
                    ItemStack accelerator = (ItemStack)iterator.next();
                    return accelerator;
                }
            }
        }
        return super.getItemFromTile(obj);
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.cluster != null) {
            this.cluster.updateName();
        }
    }

    public boolean isAccelerator() {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockAdvancedCraftingUnit) {
            return true;
        }
        return Arrays.asList(1, 2, 3).contains(this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3);
    }

    public int acceleratorValue() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 3;
        Block blockType = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (blockType instanceof BlockAdvancedCraftingUnit) {
            meta += 4;
        }
        return (int)Math.pow(4.0, meta - 1);
    }

    @Override
    public void onReady() {
        super.onReady();
        this.getProxy().setVisualRepresentation(this.getItemFromTile(this));
        this.updateMultiBlock();
    }

    public void updateMultiBlock() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    public void updateStatus(CraftingCPUCluster c) {
        if (this.cluster != null && this.cluster != c) {
            this.cluster.breakCluster();
        }
        this.cluster = c;
        this.updateMeta(true);
    }

    public void updateMeta(boolean updateFormed) {
        int newMeta;
        int current;
        if (this.field_145850_b == null || this.notLoaded()) {
            return;
        }
        boolean formed = this.isFormed();
        boolean power = false;
        if (this.getProxy().isReady()) {
            power = this.getProxy().isActive();
        }
        if ((current = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e)) != (newMeta = current & 3 | (formed ? 8 : 0) | (power ? 4 : 0))) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, newMeta, 2);
        }
        if (updateFormed) {
            if (formed) {
                this.getProxy().setValidSides(EnumSet.allOf(ForgeDirection.class));
            } else {
                this.getProxy().setValidSides(EnumSet.noneOf(ForgeDirection.class));
            }
        }
    }

    public boolean isFormed() {
        if (Platform.isClient()) {
            return (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 8) == 8;
        }
        return this.cluster != null;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileCraftingTile(NBTTagCompound data) {
        data.func_74757_a("core", this.isCoreBlock());
        if (this.isCoreBlock() && this.cluster != null) {
            this.cluster.writeToNBT(data);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileCraftingTile(NBTTagCompound data) {
        this.setCoreBlock(data.func_74767_n("core"));
        if (this.isCoreBlock()) {
            if (this.cluster != null) {
                this.cluster.readFromNBT(data);
            } else {
                this.setPreviousState((NBTTagCompound)data.func_74737_b());
            }
        }
    }

    @Override
    public void disconnect(boolean update) {
        if (this.cluster != null) {
            this.cluster.destroy();
            if (update) {
                this.updateMeta(true);
            }
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkChannelsChanged ev) {
        this.updateMeta(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStateChange(MENetworkPowerStatusChange ev) {
        this.updateMeta(false);
    }

    public boolean isStatus() {
        return false;
    }

    public boolean isStorage() {
        return false;
    }

    public long getStorageBytes() {
        return 0L;
    }

    public void breakCluster() {
        if (this.cluster != null) {
            IAEItemStack g;
            this.cluster.cancel();
            MECraftingInventory inv = this.cluster.getInventory();
            LinkedList<WorldCoord> places = new LinkedList<WorldCoord>();
            Iterator<IGridHost> i = this.cluster.getTiles();
            while (i.hasNext()) {
                IGridHost h = i.next();
                if (h == this) {
                    places.add(new WorldCoord(this));
                    continue;
                }
                TileEntity te = (TileEntity)h;
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    WorldCoord wc = new WorldCoord(te);
                    wc.add(d, 1);
                    if (!this.field_145850_b.func_147437_c(wc.x, wc.y, wc.z)) continue;
                    places.add(wc);
                }
            }
            Collections.shuffle(places);
            if (places.isEmpty()) {
                throw new IllegalStateException(this.cluster + " does not contain any kind of blocks, which were destroyed.");
            }
            for (IAEItemStack ais : inv.getAvailableItems((IItemList)AEApi.instance().storage().createItemList())) {
                ais = ais.copy();
                ais.setStackSize(ais.getItemStack().func_77976_d());
                while (!places.isEmpty() && (g = inv.extractItems(ais.copy(), Actionable.MODULATE)) != null) {
                    WorldCoord wc = (WorldCoord)places.removeFirst();
                    if (!AEConfig.instance.limitCraftingCPUSpill) {
                        places.add(wc);
                    }
                    Platform.spawnDrops(this.field_145850_b, wc.x, wc.y, wc.z, Collections.singletonList(g.getItemStack()));
                }
                if (!places.isEmpty()) continue;
                break;
            }
            for (IAEFluidStack ifs : inv.getAvailableItems((IItemList)AEApi.instance().storage().createFluidList())) {
                while (!places.isEmpty() && (g = Platform.stackConvertPacket(inv.extractItems(ifs, Actionable.MODULATE))) != null) {
                    WorldCoord wc = (WorldCoord)places.removeFirst();
                    if (!AEConfig.instance.limitCraftingCPUSpill) {
                        places.add(wc);
                    }
                    Platform.spawnDrops(this.field_145850_b, wc.x, wc.y, wc.z, Collections.singletonList(g.getItemStack()));
                }
                if (!places.isEmpty()) continue;
                break;
            }
            this.cluster.destroy();
        }
    }

    @Override
    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) & 4) == 4;
        }
        return this.getProxy().isActive();
    }

    @Override
    public boolean isActive() {
        if (Platform.isServer()) {
            return this.getProxy().isActive();
        }
        return this.isPowered() && this.isFormed();
    }

    public boolean isCoreBlock() {
        return this.isCoreBlock;
    }

    public void setCoreBlock(boolean isCoreBlock) {
        this.isCoreBlock = isCoreBlock;
    }

    public ISimplifiedBundle getLightCache() {
        return this.lightCache;
    }

    public void setLightCache(ISimplifiedBundle lightCache) {
        this.lightCache = lightCache;
    }

    public NBTTagCompound getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(NBTTagCompound previousState) {
        this.previousState = previousState;
    }
}

