/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.IOreFilterable;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.util.function.Predicate;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class PartSharedItemBus
extends PartUpgradeable
implements IGridTickable,
IOreFilterable {
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 9);
    private int adaptorHash = 0;
    private InventoryAdaptor adaptor;
    private boolean lastRedstone = false;
    protected String oreFilterString = "";
    protected Predicate<IAEItemStack> filterPredicate = null;

    public PartSharedItemBus(ItemStack is) {
        super(is);
    }

    @Override
    public void upgradesChanged() {
        if (this.getInstalledUpgrades(Upgrades.ORE_FILTER) == 0) {
            this.oreFilterString = "";
            this.filterPredicate = null;
        }
        this.updateState();
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.getConfig().readFromNBT(extra, "config");
        this.oreFilterString = extra.func_74779_i("filter");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.getConfig().writeToNBT(extra, "config");
        extra.func_74778_a("filter", this.oreFilterString);
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.getConfig();
        }
        return super.getInventoryByName(name);
    }

    @Override
    public void onNeighborChanged() {
        this.updateState();
        if (this.lastRedstone != this.getHost().hasRedstone(this.getSide())) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    protected int getAdaptorFlags() {
        return InventoryAdaptor.DEFAULT & ~InventoryAdaptor.ALLOW_FLUIDS;
    }

    protected InventoryAdaptor getHandler() {
        TileEntity self = this.getHost().getTile();
        TileEntity target = this.getTileEntity(self, self.field_145851_c + this.getSide().offsetX, self.field_145848_d + this.getSide().offsetY, self.field_145849_e + this.getSide().offsetZ);
        int newAdaptorHash = Platform.generateTileHash(target);
        if (this.adaptorHash == newAdaptorHash && newAdaptorHash != 0) {
            return this.adaptor;
        }
        this.adaptorHash = newAdaptorHash;
        this.adaptor = InventoryAdaptor.getAdaptor(target, this.getSide().getOpposite(), this.getAdaptorFlags());
        return this.adaptor;
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 4, this.getConfig().func_70302_i_());
    }

    protected int calculateItemsToSend() {
        int n;
        switch (this.getInstalledUpgrades(Upgrades.SPEED)) {
            default: {
                n = 1;
                break;
            }
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 32;
                break;
            }
            case 3: {
                n = 64;
                break;
            }
            case 4: {
                n = 96;
            }
        }
        int toSend = n;
        switch (this.getInstalledUpgrades(Upgrades.SUPERSPEED)) {
            case 1: {
                toSend += 16;
                break;
            }
            case 2: {
                toSend += 128;
                break;
            }
            case 3: {
                toSend += 1024;
                break;
            }
            case 4: {
                toSend += 8192;
            }
        }
        switch (this.getInstalledUpgrades(Upgrades.SUPERLUMINALSPEED)) {
            case 1: {
                toSend += 131072;
                break;
            }
            case 2: {
                toSend += 0x100000;
                break;
            }
            case 3: {
                toSend += 0x800000;
                break;
            }
            case 4: {
                toSend += 0x4000000;
            }
        }
        return toSend;
    }

    protected boolean canDoBusWork() {
        TileEntity self = this.getHost().getTile();
        World world = self.func_145831_w();
        int xCoordinate = self.field_145851_c + this.getSide().offsetX;
        int zCoordinate = self.field_145849_e + this.getSide().offsetZ;
        return world != null && world.func_72863_F().func_73149_a(xCoordinate >> 4, zCoordinate >> 4);
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private TileEntity getTileEntity(TileEntity self, int x, int y, int z) {
        World w = self.func_145831_w();
        if (w.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            return w.func_147438_o(x, y, z);
        }
        return null;
    }

    protected abstract TickRateModulation doBusWork();

    AppEngInternalAEInventory getConfig() {
        return this.config;
    }

    @Override
    public String getFilter() {
        return this.oreFilterString;
    }

    @Override
    public void setFilter(String filter) {
        this.oreFilterString = filter;
        this.filterPredicate = null;
    }
}

