/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.util.DimensionalCoord;
import appeng.core.localization.WailaText;
import appeng.integration.modules.waila.BaseWailaDataProvider;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.qnb.TileQuantumBridge;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public final class QuantumBridgeWailaDataProvider
extends BaseWailaDataProvider {
    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentToolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te = accessor.getTileEntity();
        if (te instanceof TileQuantumBridge) {
            MovingObjectPosition pos = accessor.getPosition();
            NBTTagCompound nbt = accessor.getNBTData();
            int x = pos.field_72311_b;
            int y = pos.field_72312_c;
            int z = pos.field_72309_d;
            boolean hasConnection = nbt.func_74767_n("hasConnection");
            if (hasConnection) {
                int sideAX = nbt.func_74762_e("sideAX");
                int sideAY = nbt.func_74762_e("sideAY");
                int sideAZ = nbt.func_74762_e("sideAZ");
                int sideADim = nbt.func_74762_e("sideADim");
                String sideAName = nbt.func_74779_i("sideAName");
                int sideBX = nbt.func_74762_e("sideBX");
                int sideBY = nbt.func_74762_e("sideBY");
                int sideBZ = nbt.func_74762_e("sideBZ");
                int sideBDim = nbt.func_74762_e("sideBDim");
                String sideBName = nbt.func_74779_i("sideBName");
                if (x == sideAX && y == sideAY && z == sideAZ) {
                    this.getInfo(sideBX, sideBY, sideBZ, sideBDim, sideAName, currentToolTip);
                } else if (x == sideBX && y == sideBY && z == sideBZ) {
                    this.getInfo(sideAX, sideAY, sideAZ, sideADim, sideBName, currentToolTip);
                }
            } else {
                currentToolTip.add(EnumChatFormatting.RED + WailaText.Disconnected.getLocal());
            }
        }
        return currentToolTip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        if (te instanceof TileQuantumBridge) {
            TileQuantumBridge quantumBridge = (TileQuantumBridge)te;
            QuantumCluster cluster = (QuantumCluster)quantumBridge.getCluster();
            if (cluster != null && cluster.getConnection() != null) {
                ILocatable myOtherSide;
                tag.func_74757_a("hasConnection", true);
                ILocatable iLocatable = myOtherSide = cluster.getOtherSide() == 0L ? null : AEApi.instance().registries().locatable().getLocatableBy(cluster.getOtherSide());
                if (myOtherSide instanceof QuantumCluster) {
                    QuantumCluster otherCluster = (QuantumCluster)myOtherSide;
                    DimensionalCoord sideA = new DimensionalCoord(cluster.getCenter());
                    DimensionalCoord sideB = new DimensionalCoord(otherCluster.getCenter());
                    TileQuantumBridge sideABridge = cluster.getCenter();
                    TileQuantumBridge sideBBridge = otherCluster.getCenter();
                    String nameSideA = sideABridge.getInternalInventory().func_70301_a(0).func_82833_r();
                    String nameSideB = sideBBridge.getInternalInventory().func_70301_a(0).func_82833_r();
                    tag.func_74768_a("sideAX", sideA.x);
                    tag.func_74768_a("sideAY", sideA.y);
                    tag.func_74768_a("sideAZ", sideA.z);
                    tag.func_74768_a("sideADim", sideA.getDimension());
                    if (!nameSideA.equals("Quantum Entangled Singularity")) {
                        tag.func_74778_a("sideAName", nameSideA);
                    }
                    tag.func_74768_a("sideBX", sideB.x);
                    tag.func_74768_a("sideBY", sideB.y);
                    tag.func_74768_a("sideBZ", sideB.z);
                    tag.func_74768_a("sideBDim", sideB.getDimension());
                    if (!nameSideB.equals("Quantum Entangled Singularity")) {
                        tag.func_74778_a("sideBName", nameSideB);
                    }
                    return tag;
                }
            }
            tag.func_74757_a("hasConnection", false);
        }
        return tag;
    }

    public void getInfo(int x, int y, int z, int dimId, String nameItemStack, List<String> currentToolTip) {
        EnumChatFormatting green = EnumChatFormatting.GREEN;
        EnumChatFormatting yellow = EnumChatFormatting.YELLOW;
        currentToolTip.add(EnumChatFormatting.BLUE + WailaText.ConnectedTo.getLocal() + ":");
        if (!nameItemStack.isEmpty()) {
            currentToolTip.add(green + WailaText.Singularity.getLocal() + ": " + yellow + nameItemStack);
        }
        currentToolTip.add(green + WailaText.Dimension.getLocal() + ": " + yellow + WorldProvider.func_76570_a((int)dimId).func_80007_l() + " [" + EnumChatFormatting.WHITE + WailaText.Id.getLocal() + ": " + dimId + yellow + "]");
        currentToolTip.add(green + WailaText.CoordinateX.getLocal() + ": " + yellow + x);
        currentToolTip.add(green + WailaText.CoordinateY.getLocal() + ": " + yellow + y);
        currentToolTip.add(green + WailaText.CoordinateZ.getLocal() + ": " + yellow + z);
    }
}

