/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.helpers.PatternHelper;
import appeng.util.ItemSorters;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class UltimatePatternHelper
implements ICraftingPatternDetails,
Comparable<UltimatePatternHelper> {
    private final ItemStack patternItem;
    private final IAEItemStack pattern;
    private final boolean canSubstitute;
    private final boolean canBeSubstitute;
    private int priority = 0;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final IAEStack<?>[] condensedAEInputs;
    private final IAEStack<?>[] condensedAEOutputs;
    private final IAEStack<?>[] aeInputs;
    private final IAEStack<?>[] aeOutputs;

    public UltimatePatternHelper(ItemStack is) {
        if (is.func_77942_o()) {
            IAEStack<?> aeStack;
            NBTTagCompound tag;
            int x;
            NBTTagCompound encodedValue = is.func_77978_p();
            this.canSubstitute = encodedValue.func_74767_n("substitute");
            this.canBeSubstitute = encodedValue.func_74767_n("beSubstitute");
            this.patternItem = is;
            if (encodedValue.func_74764_b("author")) {
                ItemStack forComparison = this.patternItem.func_77946_l();
                forComparison.field_77990_d.func_82580_o("author");
                this.pattern = AEItemStack.create(forComparison);
            } else {
                this.pattern = AEItemStack.create(is);
            }
            NBTTagList inTag = encodedValue.func_150295_c("in", 10);
            NBTTagList outTag = encodedValue.func_150295_c("out", 10);
            ArrayList<IAEItemStack> inLegacy = new ArrayList<IAEItemStack>();
            ArrayList<IAEItemStack> outLegacy = new ArrayList<IAEItemStack>();
            ArrayList in = new ArrayList();
            ArrayList out = new ArrayList();
            for (x = 0; x < inTag.func_74745_c(); ++x) {
                tag = inTag.func_150305_b(x);
                aeStack = Platform.readStackNBT(tag, true);
                if (aeStack == null && !tag.func_82582_d()) {
                    throw new IllegalStateException("No pattern here!");
                }
                inLegacy.add(Platform.stackConvert(aeStack));
                in.add(aeStack);
            }
            for (x = 0; x < outTag.func_74745_c(); ++x) {
                tag = outTag.func_150305_b(x);
                aeStack = Platform.readStackNBT(tag, true);
                if (aeStack == null && !tag.func_82582_d()) {
                    throw new IllegalStateException("No pattern here!");
                }
                outLegacy.add(Platform.stackConvert(aeStack));
                out.add(aeStack);
            }
            this.inputs = inLegacy.toArray(new IAEItemStack[0]);
            this.outputs = outLegacy.toArray(new IAEItemStack[0]);
            this.condensedInputs = PatternHelper.convertToCondensedList(this.inputs);
            this.condensedOutputs = PatternHelper.convertToCondensedList(this.outputs);
            this.aeInputs = in.toArray(new IAEStack[0]);
            this.aeOutputs = out.toArray(new IAEStack[0]);
            this.condensedAEInputs = PatternHelper.convertToCondensedAEList(this.aeInputs);
            this.condensedAEOutputs = PatternHelper.convertToCondensedAEList(this.aeOutputs);
            if (this.condensedAEInputs.length == 0 || this.condensedAEOutputs.length == 0) {
                throw new IllegalStateException("No pattern here!");
            }
        } else {
            throw new IllegalArgumentException("No pattern here!");
        }
    }

    @Override
    public ItemStack getPattern() {
        return this.patternItem;
    }

    @Override
    public boolean isCraftable() {
        return false;
    }

    @Override
    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    @Override
    public IAEStack<?>[] getAEInputs() {
        return this.aeInputs;
    }

    @Override
    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    @Override
    public IAEStack<?>[] getCondensedAEInputs() {
        return this.condensedAEInputs;
    }

    @Override
    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    @Override
    public IAEStack<?>[] getCondensedAEOutputs() {
        return this.condensedAEOutputs;
    }

    @Override
    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    @Override
    public IAEStack<?>[] getAEOutputs() {
        return this.aeOutputs;
    }

    @Override
    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public boolean canBeSubstitute() {
        return this.canBeSubstitute;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(UltimatePatternHelper o) {
        return ItemSorters.compareInt(o.priority, this.priority);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UltimatePatternHelper other = (UltimatePatternHelper)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    @Override
    public ItemStack getOutput(InventoryCrafting craftingInv, World w) {
        throw new IllegalStateException("Not a crafting recipe!");
    }

    @Override
    public synchronized boolean isValidItemForSlot(int slotIndex, IAEStack<?> i, World w) {
        throw new IllegalStateException("Only crafting recipes supported.");
    }

    @Override
    public synchronized boolean isValidItemForSlot(int slotIndex, ItemStack i, World w) {
        throw new IllegalStateException("Only crafting recipes supported.");
    }

    public static IAEStack<?>[] loadIAEStackFromNBT(NBTTagList tags, boolean saveOrder, ItemStack unknownItem) {
        ArrayList<IAEItemStack> items = new ArrayList<IAEItemStack>();
        for (int x = 0; x < tags.func_74745_c(); ++x) {
            NBTTagCompound tag = tags.func_150305_b(x);
            if (tag.func_82582_d()) continue;
            IAEItemStack gs = Platform.readStackNBT(tag, true);
            if (gs == null && unknownItem != null) {
                gs = AEApi.instance().storage().createItemStack(unknownItem);
            }
            if (gs == null && !saveOrder) continue;
            items.add(gs);
        }
        return items.toArray(new IAEStack[0]);
    }
}

