/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.util.Platform;
import com.glodblock.github.common.item.ItemFluidDrop;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class MECraftingInventory
implements IMEInventory<IAEStack> {
    private final MECraftingInventory par;
    private final IStorageMonitorable target;
    private final IItemList<IAEItemStack> localItemCache;
    private final IItemList<IAEFluidStack> localFluidCache;
    private final boolean logExtracted;
    private final IItemList<IAEStack<?>> extractedCache;
    private final boolean logInjections;
    private final IItemList<IAEStack<?>> injectedCache;
    private final boolean logMissing;
    private final IItemList<IAEStack<?>> missingCache;
    private final IItemList<IAEStack<?>> failedToExtract = AEApi.instance().storage().createAEStackList();
    private MECraftingInventory cpuinv;
    private boolean isMissingMode;

    public MECraftingInventory() {
        this.localItemCache = AEApi.instance().storage().createItemList();
        this.localFluidCache = AEApi.instance().storage().createFluidList();
        this.extractedCache = null;
        this.injectedCache = null;
        this.missingCache = null;
        this.logExtracted = false;
        this.logInjections = false;
        this.logMissing = false;
        this.target = null;
        this.par = null;
    }

    public MECraftingInventory(MECraftingInventory parent) {
        this.target = parent.target;
        this.logExtracted = parent.logExtracted;
        this.logInjections = parent.logInjections;
        this.logMissing = parent.logMissing;
        this.missingCache = this.logMissing ? AEApi.instance().storage().createAEStackList() : null;
        this.extractedCache = this.logExtracted ? AEApi.instance().storage().createAEStackList() : null;
        this.injectedCache = this.logInjections ? AEApi.instance().storage().createAEStackList() : null;
        this.localItemCache = parent.getAvailableItems((IItemList)AEApi.instance().storage().createItemList());
        this.localFluidCache = parent.getAvailableItems((IItemList)AEApi.instance().storage().createFluidList());
        this.par = parent;
    }

    public MECraftingInventory(MECraftingInventory target, boolean logExtracted, boolean logInjections, boolean logMissing) {
        this(target.target, logExtracted, logInjections, logMissing);
    }

    public MECraftingInventory(IStorageMonitorable target, boolean logExtracted, boolean logInjections, boolean logMissing) {
        this.target = target;
        this.logExtracted = logExtracted;
        this.logInjections = logInjections;
        this.logMissing = logMissing;
        this.missingCache = logMissing ? AEApi.instance().storage().createAEStackList() : null;
        this.extractedCache = logExtracted ? AEApi.instance().storage().createAEStackList() : null;
        this.injectedCache = logInjections ? AEApi.instance().storage().createAEStackList() : null;
        this.localItemCache = AEApi.instance().storage().createItemList();
        this.localFluidCache = AEApi.instance().storage().createFluidList();
        for (IAEItemStack iAEItemStack : target.getItemInventory().getStorageList()) {
            this.localItemCache.add(iAEItemStack.copy());
        }
        for (IAEFluidStack iAEFluidStack : target.getFluidInventory().getStorageList()) {
            this.localFluidCache.add(iAEFluidStack.copy());
        }
        this.par = null;
    }

    public void injectItems(IAEStack<?> input, Actionable mode) {
        if (input != null && mode == Actionable.MODULATE) {
            boolean convert = false;
            if (input instanceof IAEItemStack) {
                IAEItemStack ais = (IAEItemStack)input;
                if (Platform.isAE2FCLoaded && ais.getItem() instanceof ItemFluidDrop) {
                    this.localFluidCache.add((IAEFluidStack)Platform.convertStack(ais));
                    convert = true;
                } else {
                    this.localItemCache.add(ais);
                }
            } else {
                this.localFluidCache.add((IAEFluidStack)input);
            }
            if (this.logInjections) {
                this.injectedCache.add(convert ? Platform.convertStack((IAEItemStack)input) : input);
            }
        }
    }

    public <StackType extends IAEStack<StackType>> StackType extractItems(StackType request, Actionable mode) {
        IAEStack<IAEFluidStack> list;
        if (request == null) {
            return null;
        }
        boolean convert = false;
        if (request instanceof IAEItemStack) {
            IAEItemStack ais = (IAEItemStack)request;
            if (Platform.isAE2FCLoaded && ais.getItem() instanceof ItemFluidDrop) {
                list = this.localFluidCache.findPrecise((IAEFluidStack)Platform.convertStack(ais));
                convert = true;
            } else {
                list = this.localItemCache.findPrecise(ais);
            }
        } else {
            list = this.localFluidCache.findPrecise((IAEFluidStack)request);
        }
        if (list == null || list.getStackSize() == 0L) {
            return null;
        }
        if (list.getStackSize() >= request.getStackSize()) {
            if (mode == Actionable.MODULATE) {
                list.decStackSize(request.getStackSize());
                if (this.logExtracted) {
                    this.extractedCache.add(convert ? Platform.convertStack((IAEItemStack)request) : request);
                }
            }
            return request;
        }
        StackType ret = request.copy();
        ret.setStackSize(list.getStackSize());
        if (mode == Actionable.MODULATE) {
            list.reset();
            if (this.logExtracted) {
                this.extractedCache.add(convert ? Platform.convertStack((IAEItemStack)ret) : ret);
            }
        }
        return ret;
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        byte listType = out.getStackType();
        if (listType == 1 || listType == 3) {
            for (IAEItemStack iAEItemStack : this.localItemCache) {
                out.add(iAEItemStack);
            }
        }
        if (listType == 2 || listType == 3) {
            for (IAEFluidStack iAEFluidStack : this.localFluidCache) {
                out.add(iAEFluidStack);
            }
        }
        return out;
    }

    @Override
    public IAEStack getAvailableItem(@Nonnull IAEStack request) {
        IItemList<IAEStack<IAEFluidStack>> list;
        long count = 0L;
        boolean convert = false;
        if (request instanceof IAEItemStack) {
            IAEItemStack ais = (IAEItemStack)request;
            if (Platform.isAE2FCLoaded && ais.getItem() instanceof ItemFluidDrop) {
                list = this.localFluidCache;
                convert = true;
            } else {
                list = this.localItemCache;
            }
        } else {
            list = this.localFluidCache;
        }
        for (IAEStack iAEStack : list) {
            if (iAEStack == null || iAEStack.getStackSize() <= 0L || !(convert ? iAEStack.isSameType(Platform.convertStack((IAEItemStack)request)) : iAEStack.isSameType(request)) || (count += iAEStack.getStackSize()) >= 0L) continue;
            count = Long.MAX_VALUE;
            break;
        }
        return count == 0L ? null : (IAEStack)request.copy().setStackSize(count);
    }

    public <StackType extends IAEStack<StackType>> Collection<StackType> findFuzzy(StackType filter, FuzzyMode fuzzy) {
        if (filter == null) {
            return null;
        }
        if (filter instanceof IAEItemStack) {
            IAEItemStack ais = (IAEItemStack)filter;
            if (Platform.isAE2FCLoaded && ais.getItem() instanceof ItemFluidDrop) {
                return Collections.singletonList(this.findPrecise(ais));
            }
            return this.localItemCache.findFuzzy(ais, fuzzy);
        }
        return this.localFluidCache.findFuzzy((IAEFluidStack)filter, fuzzy);
    }

    public <StackType extends IAEStack<StackType>> StackType findPrecise(StackType is) {
        if (is == null) {
            return null;
        }
        if (is instanceof IAEItemStack) {
            IAEItemStack ais = (IAEItemStack)is;
            if (Platform.isAE2FCLoaded && ais.getItem() instanceof ItemFluidDrop) {
                return (StackType)Platform.stackConvert(this.localFluidCache.findPrecise((IAEFluidStack)Platform.convertStack(ais)));
            }
            return (StackType)this.localItemCache.findPrecise((IAEItemStack)is);
        }
        return (StackType)this.localFluidCache.findPrecise((IAEFluidStack)is);
    }

    public IItemList<IAEStack<?>> getExtractFailedList() {
        return this.failedToExtract;
    }

    public void setMissingMode(boolean b) {
        this.isMissingMode = b;
    }

    public void setCpuInventory(MECraftingInventory cp) {
        this.cpuinv = cp;
    }

    public IItemList<IAEItemStack> getItemList() {
        return this.localItemCache;
    }

    public IItemList<IAEFluidStack> getFluidList() {
        return this.localFluidCache;
    }

    public boolean isEmpty() {
        return this.localItemCache.isEmpty() && this.localFluidCache.isEmpty();
    }

    public void resetStatus() {
        this.localItemCache.resetStatus();
        this.localFluidCache.resetStatus();
    }

    public NBTTagList writeInventory() {
        return Platform.writeAEStackListNBT(this.localFluidCache, Platform.writeAEStackListNBT(this.localItemCache));
    }

    public void readInventory(NBTTagList tag) {
        IItemList<IAEStack<?>> list = Platform.readAEStackListNBT(tag, true);
        for (IAEStack<?> i : list) {
            this.injectItems(i, Actionable.MODULATE);
        }
    }

    public boolean commit(BaseActionSource src) {
        IAEStack<IAEItemStack> result;
        IItemList<IAEStack<?>> added = AEApi.instance().storage().createAEStackList();
        IItemList<IAEStack<?>> pulled = AEApi.instance().storage().createAEStackList();
        this.failedToExtract.resetStatus();
        boolean failed = false;
        if (this.logInjections) {
            for (IAEStack<?> inject : this.injectedCache) {
                result = inject.isItem() ? this.target.getItemInventory().injectItems((IAEItemStack)inject, Actionable.MODULATE, src) : this.target.getFluidInventory().injectItems((IAEFluidStack)inject, Actionable.MODULATE, src);
                added.add(result);
                if (result == null) continue;
                failed = true;
                break;
            }
        }
        if (failed) {
            for (IAEStack<?> is : added) {
                if (is.isItem()) {
                    this.target.getItemInventory().extractItems((IAEItemStack)is, Actionable.MODULATE, src);
                    continue;
                }
                this.target.getFluidInventory().extractItems((IAEFluidStack)is, Actionable.MODULATE, src);
            }
            return false;
        }
        if (this.logExtracted) {
            for (IAEStack<?> extra : this.extractedCache) {
                result = extra.isItem() ? this.target.getItemInventory().extractItems((IAEItemStack)extra, Actionable.MODULATE, src) : this.target.getFluidInventory().extractItems((IAEFluidStack)extra, Actionable.MODULATE, src);
                pulled.add(result);
                if (result != null && result.getStackSize() == extra.getStackSize()) continue;
                if (this.isMissingMode) {
                    if (result == null) {
                        this.failedToExtract.add((IAEStack<?>)extra.copy());
                        if (extra.isItem()) {
                            this.cpuinv.localItemCache.findPrecise((IAEItemStack)extra).setStackSize(0L);
                        } else {
                            this.cpuinv.localFluidCache.findPrecise((IAEFluidStack)extra).setStackSize(0L);
                        }
                        extra.setStackSize(0L);
                        continue;
                    }
                    if (result.getStackSize() == extra.getStackSize()) continue;
                    this.failedToExtract.add((IAEStack<?>)extra.copy().setStackSize(extra.getStackSize() - result.getStackSize()));
                    if (extra.isItem()) {
                        this.cpuinv.localItemCache.findPrecise((IAEItemStack)extra).setStackSize(result.getStackSize());
                    } else {
                        this.cpuinv.localFluidCache.findPrecise((IAEFluidStack)extra).setStackSize(result.getStackSize());
                    }
                    extra.setStackSize(result.getStackSize());
                    continue;
                }
                failed = true;
                this.handleCraftExtractFailure(extra, result, src);
                break;
            }
        }
        if (failed) {
            for (IAEStack<?> is : added) {
                if (is.isItem()) {
                    this.target.getItemInventory().extractItems((IAEItemStack)is, Actionable.MODULATE, src);
                    continue;
                }
                this.target.getFluidInventory().extractItems((IAEFluidStack)is, Actionable.MODULATE, src);
            }
            for (IAEStack<?> is : pulled) {
                if (is.isItem()) {
                    this.target.getItemInventory().injectItems((IAEItemStack)is, Actionable.MODULATE, src);
                    continue;
                }
                this.target.getFluidInventory().injectItems((IAEFluidStack)is, Actionable.MODULATE, src);
            }
            return false;
        }
        if (this.logMissing && this.par != null) {
            for (IAEStack<?> extra : this.missingCache) {
                this.par.addMissing(extra);
            }
        }
        return true;
    }

    private void addMissing(IAEStack<?> extra) {
        this.missingCache.add(extra);
    }

    public void ignore(IAEStack<?> what) {
        if (what.isItem()) {
            IAEItemStack list = this.localItemCache.findPrecise((IAEItemStack)what);
            if (list != null) {
                list.setStackSize(0L);
            }
        } else {
            IAEFluidStack list = this.localFluidCache.findPrecise((IAEFluidStack)what);
            if (list != null) {
                list.setStackSize(0L);
            }
        }
    }

    private void handleCraftExtractFailure(IAEStack<?> expected, IAEStack<?> extracted, BaseActionSource src) {
        if (!(src instanceof PlayerSource)) {
            return;
        }
        try {
            Object missingItem;
            EntityPlayer player = ((PlayerSource)src).player;
            if (player == null || expected == null) {
                return;
            }
            if (expected instanceof IAEItemStack) {
                IAEItemStack ais = (IAEItemStack)expected;
                missingItem = ais.getItemStack().func_151000_E();
            } else {
                String missingName = expected.getUnlocalizedName();
                missingItem = StatCollector.func_94522_b((String)(missingName + ".name")) && StatCollector.func_74838_a((String)(missingName + ".name")).equals(expected.getDisplayName()) ? new ChatComponentTranslation(missingName + ".name", new Object[0]) : new ChatComponentText(expected.getDisplayName());
            }
            missingItem.func_150256_b().func_150238_a(EnumChatFormatting.GOLD);
            String expectedCount = EnumChatFormatting.RED + NumberFormat.getNumberInstance(Locale.getDefault()).format(expected.getStackSize()) + EnumChatFormatting.RESET;
            String extractedCount = EnumChatFormatting.RED + NumberFormat.getNumberInstance(Locale.getDefault()).format(extracted.getStackSize()) + EnumChatFormatting.RESET;
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(PlayerMessages.CraftingCantExtract.getUnlocalized(), new Object[]{extractedCount, expectedCount, missingItem}));
        }
        catch (Exception ex) {
            AELog.error(ex, "Could not notify player of crafting failure");
        }
    }

    @Override
    public IAEStack injectItems(IAEStack input, Actionable type, BaseActionSource src) {
        this.injectItems(input, type);
        return null;
    }

    @Override
    public IAEStack extractItems(IAEStack request, Actionable mode, BaseActionSource src) {
        return this.extractItems(request, mode);
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }
}

