/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.AEApi;
import appeng.api.networking.IGridHost;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.NamedDimensionalCoord;
import appeng.client.gui.implementations.GuiCraftingCPU;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftingCPU;
import appeng.container.implementations.ContainerCraftingStatus;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PacketCraftingItemInterface
extends AppEngPacket {
    private IAEItemStack is;

    public PacketCraftingItemInterface(ByteBuf stream) throws IOException {
        this.is = AEApi.instance().storage().readItemFromPacket(stream);
    }

    public PacketCraftingItemInterface(IAEItemStack is) throws IOException {
        this.is = is;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        is.writeToPacket(data);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ContainerOpenContext context;
        ContainerCraftingCPU ccpu;
        Object target;
        Container container = player.field_71070_bA;
        if (container instanceof ContainerCraftingCPU && (target = (ccpu = (ContainerCraftingCPU)container).getTarget()) instanceof IGridHost && (context = ccpu.getOpenContext()) != null) {
            ICraftingCPU cpu;
            Container container2 = player.field_71070_bA;
            if (container2 instanceof ContainerCraftingStatus) {
                ContainerCraftingStatus ccs = (ContainerCraftingStatus)container2;
                cpu = ccs.getCPUTable().getSelectedCPU().getServerCluster();
            } else {
                cpu = ccpu.getMonitor();
            }
            if (cpu instanceof CraftingCPUCluster) {
                CraftingCPUCluster cpuc = cpu;
                ItemStack itemStack = this.is.getItemStack();
                NBTTagCompound data = Platform.openNbtData(itemStack);
                NamedDimensionalCoord.writeListToNBTNamed(data, cpuc.getProviders(this.is));
                data.func_74768_a("ScheduledReason", cpuc.getScheduledReason(this.is).ordinal());
                try {
                    NetworkHandler.instance.sendTo(new PacketCraftingItemInterface(AEApi.instance().storage().createItemStack(itemStack)), (EntityPlayerMP)player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
        if (gs instanceof GuiCraftingCPU) {
            ((GuiCraftingCPU)gs).postUpdate(this.is);
        }
    }
}

