/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.implementations.HasServerSideToolLogic;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.powered.ToolColorApplicator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PacketClick
extends AppEngPacket {
    private final int x;
    private final int y;
    private final int z;
    private final int side;
    private final float hitX;
    private final float hitY;
    private final float hitZ;

    public PacketClick(ByteBuf stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        this.side = stream.readInt();
        this.hitX = stream.readFloat();
        this.hitY = stream.readFloat();
        this.hitZ = stream.readFloat();
    }

    public PacketClick(int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.x = x;
        data.writeInt(this.x);
        this.y = y;
        data.writeInt(this.y);
        this.z = z;
        data.writeInt(this.z);
        this.side = side;
        data.writeInt(this.side);
        this.hitX = hitX;
        data.writeFloat(this.hitX);
        this.hitY = hitY;
        data.writeFloat(this.hitY);
        this.hitZ = hitZ;
        data.writeFloat(this.hitZ);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (is == null) {
            return;
        }
        Item item = is.func_77973_b();
        if (item instanceof HasServerSideToolLogic) {
            HasServerSideToolLogic hsstl = (HasServerSideToolLogic)item;
            hsstl.serverSideToolLogic(is, player, player.field_70170_p, this.x, this.y, this.z, this.side, this.hitX, this.hitY, this.hitZ);
        } else if (item instanceof IMemoryCard) {
            IMemoryCard mem = (IMemoryCard)item;
            mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
            is.func_77982_d(null);
        } else if (item instanceof ToolColorApplicator) {
            ToolColorApplicator mem = (ToolColorApplicator)item;
            mem.cycleColors(is, mem.getColor(is), 1);
        }
    }
}

