/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.storage.data.IAEItemStack;
import appeng.block.crafting.BlockCraftingMonitor;
import appeng.client.ClientHelper;
import appeng.client.render.blocks.RenderBlockCraftingCPU;
import appeng.core.AELog;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.util.IWideReadableNumberConverter;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderBlockCraftingCPUMonitor
extends RenderBlockCraftingCPU<BlockCraftingMonitor, TileCraftingMonitorTile> {
    private static final IWideReadableNumberConverter NUMBER_CONVERTER = ReadableNumberConverter.INSTANCE;

    public RenderBlockCraftingCPUMonitor() {
        super(true, 20);
    }

    @Override
    public void renderTile(BlockCraftingMonitor block, TileCraftingMonitorTile tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        if (tile != null) {
            IAEItemStack ais = tile.getJobProgress();
            if (tile.getDisplayList() == null) {
                tile.setUpdateList(true);
                tile.setDisplayList(GLAllocation.func_74526_a((int)1));
            } else {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                if (tile.isUpdateList()) {
                    tile.setUpdateList(false);
                    GL11.glNewList((int)tile.getDisplayList(), (int)4865);
                    this.tesrRenderScreen(tess, tile, ais);
                    GL11.glEndList();
                } else {
                    GL11.glCallList((int)tile.getDisplayList());
                }
                GL11.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tesrRenderScreen(Tessellator tess, TileCraftingMonitorTile cmt, IAEItemStack ais) {
        ForgeDirection side = cmt.getForward();
        ForgeDirection walrus = side.offsetY != 0 ? ForgeDirection.SOUTH : ForgeDirection.UP;
        int spin = 0;
        int max = 5;
        while (walrus != cmt.getUp() && max > 0) {
            --max;
            ++spin;
            walrus = Platform.rotateAround(walrus, side);
        }
        --max;
        GL11.glTranslated((double)((double)side.offsetX * 0.69), (double)((double)side.offsetY * 0.69), (double)((double)side.offsetZ * 0.69));
        float scale = 0.7f;
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        switch (side) {
            case UP: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((float)spin * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case DOWN: {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)((float)spin * -90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case SOUTH: {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        try {
            ItemStack sis = ais.getItemStack();
            sis.field_77994_a = 1;
            int br = 0x1000100;
            int var11 = 256;
            int var12 = 256;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)204.8f, (float)204.8f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)32826);
            tess.func_78386_a(1.0f, 1.0f, 1.0f);
            ClientHelper.proxy.doRenderItem(sis, cmt.func_145831_w());
        }
        catch (Exception e) {
            AELog.debug(e);
        }
        finally {
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2896);
        }
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
        GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        long stackSize = ais.getStackSize();
        String renderedStackSize = NUMBER_CONVERTER.toWideReadableForm(stackSize);
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(renderedStackSize);
        GL11.glTranslatef((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(renderedStackSize, 0, 0, 0);
    }
}

