/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.AEBaseGui;
import appeng.core.AELog;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.util.ColorPickHelper;
import appeng.util.ReadableNumberConverter;
import appeng.util.RoundHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileAlreadyExistsException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.event.ClickEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GuiCraftingList {
    private static final int FIELD_WIDTH = 276;
    private static final int FIELD_HEIGHT = 96;
    private static final int FIELD_SECTIONLENGTH = 268;
    private static final ResourceLocation FIELD_TEXTURE = new ResourceLocation("appliedenergistics2", "textures/guis/onefiled.png");
    private static final DateTimeFormatter SCREENSHOT_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    protected static RenderItem itemRender = new RenderItem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveScreenShot(AEBaseGui parent, List<IAEItemStack> visual, IItemList<IAEItemStack> storage, IItemList<IAEItemStack> pending, IItemList<IAEItemStack> missing) {
        int visualSize = visual.size();
        int width = (int)Math.ceil(Math.max(Math.sqrt((double)visualSize * 96.0 / 276.0), 3.0));
        int height = (int)Math.ceil((float)visualSize / (float)width);
        Minecraft mc = Minecraft.func_71410_x();
        if (!OpenGlHelper.func_148822_b()) {
            AELog.error("Could not save crafting tree screenshot: FBOs disabled/unsupported", new Object[0]);
            mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentTranslation("chat.appliedenergistics2.FBOUnsupported", new Object[0]));
            return;
        }
        try {
            File screenshotsDir = new File(mc.field_71412_D, "screenshots");
            FileUtils.forceMkdir((File)screenshotsDir);
            int imgWidth = width * 275 + 1;
            int imgHeight = height * 95 + 1;
            BufferedImage outputImg = new BufferedImage(imgWidth, imgHeight, 2);
            IntBuffer downloadBuffer = BufferUtils.createIntBuffer((int)26496);
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            Framebuffer fb = new Framebuffer(276, 96, true);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)276.0, (double)96.0, (double)0.0, (double)-3000.0, (double)3000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glDisable((int)2929);
            try {
                fb.func_147610_a(true);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        boolean need_red = false;
                        if (width * y + x < visualSize) {
                            IAEItemStack refStack = visual.get(width * y + x);
                            IAEItemStack stored = storage.findPrecise(refStack);
                            IAEItemStack pendingStack = pending.findPrecise(refStack);
                            IAEItemStack missingStack = missing.findPrecise(refStack);
                            if (missingStack != null && missingStack.getStackSize() > 0L) {
                                need_red = true;
                            }
                            GL11.glPushMatrix();
                            GL11.glClear((int)16640);
                            GL11.glScaled((double)4.0, (double)4.0, (double)1.0);
                            parent.bindTexture(FIELD_TEXTURE);
                            parent.func_73729_b(0, 0, 0, need_red ? 24 : 0, 276, 96);
                            GL11.glPopMatrix();
                            GuiCraftingList.drawStringAndItem(parent, refStack, stored, pendingStack, missingStack);
                        } else {
                            GL11.glPushMatrix();
                            GL11.glClear((int)16640);
                            GL11.glScaled((double)4.0, (double)4.0, (double)1.0);
                            parent.bindTexture(FIELD_TEXTURE);
                            parent.func_73729_b(0, 0, 0, 0, 276, 96);
                            GL11.glPopMatrix();
                        }
                        GL11.glBindTexture((int)3553, (int)fb.field_147617_g);
                        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)downloadBuffer);
                        int backgroundColor = downloadBuffer.get(1939);
                        for (int i = 0; i < 26496; ++i) {
                            int x_ = i % 276;
                            int y_ = i / 276;
                            int rgba = downloadBuffer.get(i);
                            int a = rgba >>> 24 & 0xFF;
                            int r = rgba >>> 16 & 0xFF;
                            int g = rgba >>> 8 & 0xFF;
                            int b = rgba & 0xFF;
                            int br = backgroundColor >>> 16 & 0xFF;
                            int bg = backgroundColor >>> 8 & 0xFF;
                            int bb = backgroundColor & 0xFF;
                            float alpha = (float)a / 255.0f;
                            int outR = (int)((float)r * alpha + (float)br * (1.0f - alpha));
                            int outG = (int)((float)g * alpha + (float)bg * (1.0f - alpha));
                            int outB = (int)((float)b * alpha + (float)bb * (1.0f - alpha));
                            int finalRGB = 0xFF000000 | outR << 16 | outG << 8 | outB;
                            outputImg.setRGB(x * 275 + x_, (y + 1) * 95 - y_, finalRGB);
                        }
                    }
                }
            }
            finally {
                fb.func_147608_a();
                GL11.glViewport((int)0, (int)0, (int)mc.field_71443_c, (int)mc.field_71440_d);
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            String date = SCREENSHOT_DATE_FORMAT.format(LocalDateTime.now());
            String filename = String.format("%s-ae2.png", date);
            File outFile = new File(screenshotsDir, filename);
            for (int i = 1; outFile.exists() && i < 99; ++i) {
                filename = String.format("%s-ae2-%d.png", date, i);
                outFile = new File(screenshotsDir, filename);
            }
            if (outFile.exists()) {
                throw new FileAlreadyExistsException(filename);
            }
            ImageIO.write((RenderedImage)outputImg, "png", outFile);
            AELog.info("Saved crafting list screenshot to %s", filename);
            ChatComponentText chatLink = new ChatComponentText(filename);
            chatLink.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, outFile.getAbsolutePath()));
            chatLink.func_150256_b().func_150228_d(Boolean.valueOf(true));
            mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentTranslation("screenshot.success", new Object[]{chatLink}));
        }
        catch (Exception e) {
            AELog.warn(e, "Could not save crafting list screenshot");
            mc.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentTranslation("screenshot.failure", new Object[]{e.getMessage()}));
        }
    }

    private static void drawStringAndItem(AEBaseGui parent, IAEItemStack refStack, IAEItemStack stored, IAEItemStack pendingStack, IAEItemStack missingStack) {
        int xo = 9;
        int yo = 22;
        if (refStack != null) {
            int w;
            String str;
            GL11.glPushMatrix();
            GL11.glScaled((double)4.0, (double)4.0, (double)1.0);
            ItemStack is = refStack.copy().getItemStack();
            GuiCraftingList.drawItem(49, 4, is, true);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)1048575);
            GL11.glScaled((double)2.0, (double)2.0, (double)0.5);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
                if (missingStack == null && pendingStack == null) {
                    ++lines;
                }
            }
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                ++lines;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                lines += 2;
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                str = GuiText.FromStorage.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(stored.getStackSize());
                w = 4 + parent.getFontRenderer().func_78256_a(str);
                parent.getFontRenderer().func_78276_b(str, (257 - w * 2) / 4, (28 - negY + downY) / 2, GuiColors.CraftConfirmFromStorage.getColor());
                downY += 20;
            }
            if (missingStack != null && missingStack.getStackSize() > 0L) {
                str = GuiText.Missing.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(missingStack.getStackSize());
                w = 4 + parent.getFontRenderer().func_78256_a(str);
                parent.getFontRenderer().func_78276_b(str, (257 - w * 2) / 4, (28 - negY + downY) / 2, GuiColors.CraftConfirmMissing.getColor());
                downY += 20;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                str = GuiText.ToCraft.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(pendingStack.getStackSize());
                w = 4 + parent.getFontRenderer().func_78256_a(str);
                parent.getFontRenderer().func_78276_b(str, (257 - w * 2) / 4, (28 - negY + downY) / 2, GuiColors.CraftConfirmToCraft.getColor());
                str = GuiText.ToCraftRequests.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(pendingStack.getCountRequestableCrafts());
                w = 4 + parent.getFontRenderer().func_78256_a(str);
                parent.getFontRenderer().func_78276_b(str, (257 - w * 2) / 4, (28 - negY + (downY += 20)) / 2, GuiColors.CraftConfirmToCraft.getColor());
            }
            if (stored != null && stored.getStackSize() > 0L && missingStack == null && pendingStack == null) {
                str = GuiText.FromStoragePercent.getLocal() + ": " + RoundHelper.toRoundedFormattedForm(stored.getUsedPercent(), 2) + "%";
                w = 4 + parent.getFontRenderer().func_78256_a(str);
                parent.getFontRenderer().func_78276_b(str, (257 - w * 2) / 4, (28 - negY + downY) / 2, ColorPickHelper.selectColorFromThreshold(stored.getUsedPercent()).getColor());
            }
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        }
    }

    public static void drawItem(int x, int y, ItemStack is, boolean enhanceLight) {
        GuiCraftingList.itemRender.field_77023_b = 100.0f;
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)101.0f);
        RenderHelper.func_74520_c();
        if (enhanceLight) {
            GL11.glLight((int)16384, (int)4609, (FloatBuffer)GuiCraftingList.createColorBuffer(1.0f, 1.0f, 1.0f, 1.0f));
            GL11.glLight((int)16385, (int)4609, (FloatBuffer)GuiCraftingList.createColorBuffer(1.0f, 1.0f, 1.0f, 1.0f));
            GL11.glLightModel((int)2899, (FloatBuffer)GuiCraftingList.createColorBuffer(0.6f, 0.6f, 0.6f, 1.0f));
        }
        Minecraft mc = Minecraft.func_71410_x();
        itemRender.func_82406_b(mc.field_71466_p, mc.field_71446_o, is, x, y);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-101.0f);
        GL11.glPopAttrib();
        GuiCraftingList.itemRender.field_77023_b = 0.0f;
    }

    private static FloatBuffer createColorBuffer(float r, float g, float b, float a) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)4);
        buffer.put(r).put(g).put(b).put(a);
        buffer.flip();
        return buffer;
    }
}

