/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.movillages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.world.biome.BiomeGenBase;
import weatherpony.movillages.IBlockChanger;
import weatherpony.movillages.StandardChangerSetup;

public class MoVillagesBiomeManager {
    public static final MoVillagesBiomeManager INSTANCE = new MoVillagesBiomeManager();
    private List<Callable> redirectRegistrationRequests = new ArrayList<Callable>();
    private List<Callable> changerRegistrationRequests = new ArrayList<Callable>();
    private HashMap<String, String> biomeRedirects = new HashMap();
    private HashMap<String, IBlockChanger> changers = new HashMap();
    private boolean postInitializedAlready = false;

    public static void init() {
        StandardChangerSetup.register();
    }

    public void registerRedirectRegistrationRequest(Callable request) {
        if (request == null) {
            throw new NullPointerException();
        }
        this.redirectRegistrationRequests.add(request);
    }

    public void registerChangerRegistrationRequest(Callable request) {
        if (request == null) {
            throw new NullPointerException();
        }
        this.changerRegistrationRequests.add(request);
    }

    public void afterModInit() {
        if (this.postInitializedAlready) {
            return;
        }
        this.postInitializedAlready = true;
        for (BiomeGenBase eachBiome : BiomeGenBase.func_150565_n()) {
            if (eachBiome == null) continue;
            String eachBiomeName = eachBiome.field_76791_y;
            this.biomeRedirects.put(eachBiomeName, eachBiomeName);
        }
        this.processRegistrationRequests(this.redirectRegistrationRequests);
        this.factorRedirects();
        this.processRegistrationRequests(this.changerRegistrationRequests);
    }

    private void processRegistrationRequests(List<Callable> requests) {
        for (Callable each : requests) {
            try {
                each.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void factorRedirects() {
        HashMap<String, String> temp = new HashMap<String, String>(this.biomeRedirects);
        this.biomeRedirects.clear();
        for (Map.Entry eachRedirect : temp.entrySet()) {
            String eachFrom;
            String from = (String)eachRedirect.getKey();
            if (this.biomeRedirects.containsKey(from)) continue;
            ArrayList<String> passing = new ArrayList<String>();
            String redirectedTo = this.determineRedirect(from, temp, passing);
            Iterator i$ = passing.iterator();
            while (i$.hasNext() && !this.biomeRedirects.containsKey(eachFrom = (String)i$.next())) {
                this.biomeRedirects.put(eachFrom, redirectedTo);
            }
        }
    }

    private String determineRedirect(String from, Map<String, String> redirects, List<String> passingThrough) {
        passingThrough.add(from);
        String redirectedTo = redirects.get(from);
        if (redirectedTo == null || redirectedTo.equals(from)) {
            return from;
        }
        return this.determineRedirect(redirectedTo, redirects, passingThrough);
    }

    public void addRedirect(String biomeFrom, String biomeTo) {
        this.biomeRedirects.put(biomeFrom, biomeTo);
    }

    public void addChanger(String forBiome, IBlockChanger changer) {
        if (!forBiome.equals(this.getRedirect(forBiome))) {
            throw new IllegalStateException();
        }
        this.changers.put(forBiome, changer);
    }

    public String getRedirect(BiomeGenBase biome) {
        return this.getRedirect(biome.field_76791_y);
    }

    public String getRedirect(String from) {
        return this.biomeRedirects.get(from);
    }

    public IBlockChanger getChanger(String from) {
        return this.changers.get(this.getRedirect(from));
    }

    public IBlockChanger getChanger(BiomeGenBase biome) {
        return this.changers.get(this.getRedirect(biome));
    }
}

