/*
 * Decompiled with CFR 0.152.
 */
package weatherpony.movillages;

import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import weatherpony.movillages.MoVillagesBiomeManager;

public interface IBlockChanger {
    public Block getBlockChange(BiomeGenBase var1, Block var2);

    public Integer getMetaChange(BiomeGenBase var1, Block var2);

    public static class RedirectBlockChanger2
    implements IBlockChanger {
        private final String startFrom;

        public RedirectBlockChanger2(String startFrom) {
            this.startFrom = startFrom;
        }

        @Override
        public Block getBlockChange(BiomeGenBase startBiome, Block normalBlock) {
            return MoVillagesBiomeManager.INSTANCE.getChanger(this.startFrom).getBlockChange(startBiome, normalBlock);
        }

        @Override
        public Integer getMetaChange(BiomeGenBase startBiome, Block normalBlock) {
            return MoVillagesBiomeManager.INSTANCE.getChanger(this.startFrom).getMetaChange(startBiome, normalBlock);
        }
    }

    public static class RedirectBlockChanger
    implements IBlockChanger {
        private final IBlockChanger redirect;

        public RedirectBlockChanger(IBlockChanger redirect) {
            this.redirect = redirect;
        }

        @Override
        public Block getBlockChange(BiomeGenBase startBiome, Block normalBlock) {
            return this.redirect.getBlockChange(startBiome, normalBlock);
        }

        @Override
        public Integer getMetaChange(BiomeGenBase startBiome, Block normalBlock) {
            return this.redirect.getMetaChange(startBiome, normalBlock);
        }
    }
}

