/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.server.component;

import codechicken.lib.vec.Vector3;
import cpw.mods.fml.common.Optional;
import li.cil.oc.Settings$;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.Node;
import li.cil.oc.common.EventHandler$;
import li.cil.oc.common.tileentity.traits.RedstoneChangedEventArgs;
import li.cil.oc.common.tileentity.traits.RedstoneChangedEventArgs$;
import li.cil.oc.integration.util.WirelessRedstone$;
import li.cil.oc.server.component.RedstoneWireless;
import li.cil.oc.server.component.package$;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.convert.WrapAsJava$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public abstract class RedstoneWireless$class {
    public static final Map li$cil$oc$server$component$RedstoneWireless$$deviceInfo(RedstoneWireless $this) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)"communication"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"description"), (Object)"Wireless redstone controller"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"vendor"), (Object)"MightyPirates GmbH & Co. KG"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"product"), (Object)"Rw400-M"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"capacity"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"width"), (Object)"1")}));
    }

    public static java.util.Map getDeviceInfo(RedstoneWireless $this) {
        return WrapAsJava$.MODULE$.mapAsJavaMap($this.li$cil$oc$server$component$RedstoneWireless$$deviceInfo());
    }

    @Callback(doc="function():number -- Get the wireless redstone input.")
    public static Object[] getWirelessInput(RedstoneWireless $this, Context context, Arguments args) {
        $this.wirelessInput_$eq(WirelessRedstone$.MODULE$.getInput($this));
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)$this.wirelessInput())}));
    }

    @Callback(direct=true, doc="function():boolean -- Get the wireless redstone output.")
    public static Object[] getWirelessOutput(RedstoneWireless $this, Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)$this.wirelessOutput())}));
    }

    @Callback(doc="function(value:boolean):boolean -- Set the wireless redstone output.")
    public static Object[] setWirelessOutput(RedstoneWireless $this, Context context, Arguments args) {
        Object object;
        boolean newValue;
        boolean oldValue = $this.wirelessOutput();
        if (oldValue != (newValue = args.checkBoolean(0))) {
            $this.wirelessOutput_$eq(newValue);
            WirelessRedstone$.MODULE$.updateOutput($this);
            object = Settings$.MODULE$.get().redstoneDelay() > 0.0 ? BoxesRunTime.boxToBoolean((boolean)context.pause(Settings$.MODULE$.get().redstoneDelay())) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)oldValue)}));
    }

    @Callback(direct=true, doc="function():number -- Get the currently set wireless redstone frequency.")
    public static Object[] getWirelessFrequency(RedstoneWireless $this, Context context, Arguments args) {
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.wirelessFrequency())}));
    }

    @Callback(doc="function(frequency:number):number -- Set the wireless redstone frequency to use.")
    public static Object[] setWirelessFrequency(RedstoneWireless $this, Context context, Arguments args) {
        Object object;
        int newValue;
        int oldValue = $this.wirelessFrequency();
        if (oldValue != (newValue = args.checkInteger(0))) {
            WirelessRedstone$.MODULE$.removeReceiver($this);
            WirelessRedstone$.MODULE$.removeTransmitter($this);
            $this.wirelessFrequency_$eq(newValue);
            $this.wirelessInput_$eq(false);
            $this.wirelessOutput_$eq(false);
            WirelessRedstone$.MODULE$.addReceiver($this);
            object = BoxesRunTime.boxToBoolean((boolean)context.pause(0.5));
        } else {
            object = BoxedUnit.UNIT;
        }
        return package$.MODULE$.result((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldValue)}));
    }

    @Optional.Method(modid="WR-CBE|Core")
    public static void updateDevice(RedstoneWireless $this, int frequency, boolean on) {
        if (frequency == $this.wirelessFrequency() && on != $this.wirelessInput()) {
            $this.wirelessInput_$eq(on);
            $this.onRedstoneChanged(new RedstoneChangedEventArgs(ForgeDirection.UNKNOWN, on ? 0 : 1, on ? 1 : 0, RedstoneChangedEventArgs$.MODULE$.apply$default$4()));
        }
    }

    @Optional.Method(modid="WR-CBE|Core")
    public static Vector3 getPosition(RedstoneWireless $this) {
        return new Vector3($this.redstone().xPosition(), $this.redstone().yPosition(), $this.redstone().zPosition());
    }

    @Optional.Method(modid="WR-CBE|Core")
    public static int getDimension(RedstoneWireless $this) {
        return $this.redstone().world().field_73011_w.field_76574_g;
    }

    @Optional.Method(modid="WR-CBE|Core")
    public static int getFreq(RedstoneWireless $this) {
        return $this.wirelessFrequency();
    }

    @Optional.Method(modid="WR-CBE|Core")
    public static Null$ getAttachedEntity(RedstoneWireless $this) {
        return null;
    }

    public static void onConnect(RedstoneWireless $this, Node node2) {
        $this.li$cil$oc$server$component$RedstoneWireless$$super$onConnect(node2);
        Node node3 = node2;
        Component component = $this.node();
        if (!(node3 != null ? !node3.equals(component) : component != null)) {
            EventHandler$.MODULE$.scheduleWirelessRedstone($this);
        }
    }

    public static void onDisconnect(RedstoneWireless $this, Node node2) {
        $this.li$cil$oc$server$component$RedstoneWireless$$super$onDisconnect(node2);
        Node node3 = node2;
        Component component = $this.node();
        if (!(node3 != null ? !node3.equals(component) : component != null)) {
            WirelessRedstone$.MODULE$.removeReceiver($this);
            WirelessRedstone$.MODULE$.removeTransmitter($this);
            $this.wirelessOutput_$eq(false);
            $this.wirelessFrequency_$eq(0);
        }
    }

    public static void load(RedstoneWireless $this, NBTTagCompound nbt) {
        $this.li$cil$oc$server$component$RedstoneWireless$$super$load(nbt);
        $this.wirelessFrequency_$eq(nbt.func_74762_e("wirelessFrequency"));
        $this.wirelessInput_$eq(nbt.func_74767_n("wirelessInput"));
        $this.wirelessOutput_$eq(nbt.func_74767_n("wirelessOutput"));
    }

    public static void save(RedstoneWireless $this, NBTTagCompound nbt) {
        $this.li$cil$oc$server$component$RedstoneWireless$$super$save(nbt);
        nbt.func_74768_a("wirelessFrequency", $this.wirelessFrequency());
        nbt.func_74757_a("wirelessInput", $this.wirelessInput());
        nbt.func_74757_a("wirelessOutput", $this.wirelessOutput());
    }

    public static void $init$(RedstoneWireless $this) {
        $this.wirelessFrequency_$eq(0);
        $this.wirelessInput_$eq(false);
        $this.wirelessOutput_$eq(false);
    }
}

