/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.util;

import covers1624.powerconverters.slot.ChargerOutputSlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class InventoryUtils {
    public static void bindPlayerInventory(Container container, InventoryPlayer inventoryPlayer, int xStart, int yStart) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slot = j + i * 9 + 9;
                int x = xStart + j * 18;
                int y = yStart + i * 18;
                InventoryUtils.addSlotToContainer(container, new Slot((IInventory)inventoryPlayer, slot, x, y));
            }
        }
        for (i = 0; i < 9; ++i) {
            InventoryUtils.addSlotToContainer(container, new Slot((IInventory)inventoryPlayer, i, xStart + i * 18, yStart + 58));
        }
    }

    public static Slot addSlotToContainer(Container container, Slot slot) {
        slot.field_75222_d = container.field_75151_b.size();
        container.field_75151_b.add(slot);
        container.field_75153_a.add(null);
        return slot;
    }

    public static ItemStack transferStackInSlot(Container container, EntityPlayer player, int slotIndex) {
        ItemStack originalStack = null;
        Slot slot = (Slot)container.field_75151_b.get(slotIndex);
        int numSlots = container.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !InventoryUtils.tryShiftItem(container, stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !InventoryUtils.shiftItemStack(container, stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !InventoryUtils.shiftItemStack(container, stackInSlot, numSlots - 36, numSlots - 9) : !InventoryUtils.shiftItemStack(container, stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return originalStack;
    }

    public static boolean tryShiftItem(Container container, ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)container.field_75151_b.get(machineIndex);
            if (slot instanceof ChargerOutputSlot || !slot.func_75214_a(stackToShift) || !InventoryUtils.shiftItemStack(container, stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    public static boolean shiftItemStack(Container container, ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)container.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !InventoryUtils.canStacksMerge(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)container.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    public static boolean canStacksMerge(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (!stack1.func_77969_a(stack2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }
}

