/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPosition {
    public int x;
    public int y;
    public int z;
    public ForgeDirection orientation;
    public static final int[][] SIDE_COORD_MOD = new int[][]{{0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}, {-1, 0, 0}, {1, 0, 0}};

    public BlockPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(int x, int y, int z, ForgeDirection corientation) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.orientation = corientation;
    }

    public BlockPosition(BlockPosition p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public BlockPosition(NBTTagCompound nbttagcompound) {
        this.x = nbttagcompound.func_74762_e("i");
        this.y = nbttagcompound.func_74762_e("j");
        this.z = nbttagcompound.func_74762_e("k");
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition(TileEntity tile) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public BlockPosition copy() {
        return new BlockPosition(this.x, this.y, this.z, this.orientation);
    }

    public BlockPosition step(int dir, int dist) {
        int[] d = SIDE_COORD_MOD[dir];
        this.x += d[0] * dist;
        this.y += d[1] * dist;
        this.z += d[2] * dist;
        return this;
    }

    public BlockPosition step(ForgeDirection dir) {
        this.x += dir.offsetX;
        this.y += dir.offsetY;
        this.z += dir.offsetZ;
        return this;
    }

    public BlockPosition step(ForgeDirection dir, int dist) {
        this.x += dir.offsetX * dist;
        this.y += dir.offsetY * dist;
        this.z += dir.offsetZ * dist;
        return this;
    }

    public void moveRight(int step) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= step;
                break;
            }
            case NORTH: {
                this.x += step;
                break;
            }
            case EAST: {
                this.z += step;
                break;
            }
            case WEST: {
                this.z -= step;
                break;
            }
        }
    }

    public void moveLeft(int step) {
        this.moveRight(-step);
    }

    public void moveForwards(int step) {
        switch (this.orientation) {
            case UP: {
                this.y += step;
                break;
            }
            case DOWN: {
                this.y -= step;
                break;
            }
            case SOUTH: {
                this.z += step;
                break;
            }
            case NORTH: {
                this.z -= step;
                break;
            }
            case EAST: {
                this.x += step;
                break;
            }
            case WEST: {
                this.x -= step;
                break;
            }
        }
    }

    public void moveBackwards(int step) {
        this.moveForwards(-step);
    }

    public void moveUp(int step) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += step;
                break;
            }
        }
    }

    public void moveDown(int step) {
        this.moveUp(-step);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74780_a("i", (double)this.x);
        nbttagcompound.func_74780_a("j", (double)this.y);
        nbttagcompound.func_74780_a("k", (double)this.z);
    }

    public String toString() {
        if (this.orientation == null) {
            return "{" + this.x + ", " + this.y + ", " + this.z + "}";
        }
        return "{" + this.x + ", " + this.y + ", " + this.z + ";" + this.orientation.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockPosition)) {
            return false;
        }
        BlockPosition bp = (BlockPosition)obj;
        return bp.x == this.x && bp.y == this.y && bp.z == this.z && bp.orientation == this.orientation;
    }

    public int hashCode() {
        return this.x & 0xFFF | this.y & 0xFF00 | this.z & 0xFFF000;
    }

    public BlockPosition min(BlockPosition p) {
        return new BlockPosition(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public BlockPosition max(BlockPosition p) {
        return new BlockPosition(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }

    public List<BlockPosition> getAdjacent(boolean includeVertical) {
        ArrayList<BlockPosition> a = new ArrayList<BlockPosition>();
        a.add(new BlockPosition(this.x + 1, this.y, this.z, ForgeDirection.EAST));
        a.add(new BlockPosition(this.x - 1, this.y, this.z, ForgeDirection.WEST));
        a.add(new BlockPosition(this.x, this.y, this.z + 1, ForgeDirection.SOUTH));
        a.add(new BlockPosition(this.x, this.y, this.z - 1, ForgeDirection.NORTH));
        if (includeVertical) {
            a.add(new BlockPosition(this.x, this.y + 1, this.z, ForgeDirection.UP));
            a.add(new BlockPosition(this.x, this.y - 1, this.z, ForgeDirection.DOWN));
        }
        return a;
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public <T> T getTileEntity(World world, Class<T> targetClass) {
        TileEntity te = world.func_147438_o(this.x, this.y, this.z);
        if (targetClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public static TileEntity getTileEntityRaw(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        return world.func_72938_d(x, z).getTileEntityUnsafe(x & 0xF, y, z & 0xF);
    }

    public static <T> T getTileEntityRaw(World world, int x, int y, int z, Class<T> targetClass) {
        TileEntity te = BlockPosition.getTileEntityRaw(world, x, y, z);
        if (targetClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public static boolean blockExists(TileEntity start, ForgeDirection dir) {
        int x = start.field_145851_c + dir.offsetX;
        int y = start.field_145848_d + dir.offsetY;
        int z = start.field_145849_e + dir.offsetZ;
        return start.func_145831_w().func_72899_e(x, y, z);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity start, ForgeDirection direction) {
        BlockPosition p = new BlockPosition(start);
        p.orientation = direction;
        p.moveForwards(1);
        return start.func_145831_w().func_147438_o(p.x, p.y, p.z);
    }

    public static <T> T getAdjacentTileEntity(TileEntity start, ForgeDirection direction, Class<T> targetClass) {
        TileEntity te = BlockPosition.getAdjacentTileEntity(start, direction);
        if (targetClass.isInstance(te)) {
            return (T)te;
        }
        return null;
    }
}

