/*
 * Decompiled with CFR 0.152.
 */
package covers1624.powerconverters.tile.main;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import covers1624.powerconverters.grid.GridTickHandler;
import covers1624.powerconverters.grid.IGridController;
import covers1624.powerconverters.grid.INode;
import covers1624.powerconverters.tile.main.EnergyNetwork;
import covers1624.powerconverters.util.BlockPosition;
import covers1624.powerconverters.util.IAdvancedLogTile;
import covers1624.powerconverters.util.IUpdateTileWithCords;
import covers1624.powerconverters.util.LogHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyConduit
extends TileEntity
implements INode,
IEnergyHandler,
IUpdateTileWithCords,
IAdvancedLogTile {
    private IEnergyReceiver[] receiverCache = null;
    private IEnergyProvider[] providerCache = null;
    private boolean readFromNBT = false;
    private boolean deadCache = false;
    boolean isNode = false;
    int energyForGrid = 0;
    EnergyNetwork grid;

    public TileEnergyConduit() {
        if (this.grid == null) {
            this.func_145829_t();
        }
    }

    @Override
    public boolean isNotValid() {
        return this.field_145846_f;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.deadCache = true;
        this.receiverCache = null;
        this.providerCache = null;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        GridTickHandler.energy.addConduitForTick(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.grid != null) {
            this.grid.removeConduit(this);
            this.grid.storage.modifyEnergyStored(-this.energyForGrid);
            boolean c = false;
            this.grid.regenerate();
            this.deadCache = true;
            this.grid = null;
        }
    }

    private void addCache(TileEntity tile) {
        if (tile == null) {
            return;
        }
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145848_d;
        if (x < this.field_145851_c) {
            this.addCache(tile, 5);
        } else if (x > this.field_145851_c) {
            this.addCache(tile, 4);
        } else if (z < this.field_145849_e) {
            this.addCache(tile, 3);
        } else if (z > this.field_145849_e) {
            this.addCache(tile, 2);
        } else if (y < this.field_145848_d) {
            this.addCache(tile, 1);
        } else if (y > this.field_145848_d) {
            this.addCache(tile, 0);
        }
    }

    private void addCache(TileEntity tile, int side) {
        if (this.receiverCache != null) {
            this.receiverCache[side] = null;
        }
        if (this.providerCache != null) {
            this.providerCache[side] = null;
        }
        if (!(tile instanceof TileEnergyConduit) && tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(ForgeDirection.VALID_DIRECTIONS[side])) {
            if (tile instanceof IEnergyReceiver) {
                if (this.receiverCache == null) {
                    this.receiverCache = new IEnergyReceiver[6];
                }
                this.receiverCache[side] = (IEnergyReceiver)tile;
            }
            if (tile instanceof IEnergyProvider) {
                if (this.providerCache == null) {
                    this.providerCache = new IEnergyProvider[6];
                }
                this.providerCache[side] = (IEnergyProvider)tile;
            }
        }
    }

    private void reCache() {
        if (this.deadCache) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.addCache(BlockPosition.getAdjacentTileEntity(this, dir));
            }
            this.deadCache = false;
            this.updateInternalTypes(EnergyNetwork.HANDLER);
        }
    }

    private void incorporateTiles() {
        if (this.grid == null) {
            boolean hasGrid = false;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEnergyConduit pipe;
                if (this.readFromNBT || !BlockPosition.blockExists(this, dir) || (pipe = BlockPosition.getAdjacentTileEntity(this, dir, TileEnergyConduit.class)) == null || pipe.grid == null || !pipe.canInterface(this, dir)) continue;
                if (hasGrid) {
                    pipe.grid.mergeGrid(this.grid);
                    continue;
                }
                pipe.grid.addConduit(this);
                hasGrid = this.grid != null;
            }
        }
    }

    @Override
    public void firstTick(IGridController grid) {
        LogHelper.info("First Grid Tick");
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || grid != EnergyNetwork.HANDLER) {
            return;
        }
        if (this.grid == null) {
            this.incorporateTiles();
            this.setGrid(new EnergyNetwork(this));
        }
        this.readFromNBT = true;
        this.reCache();
        this.func_70296_d();
    }

    @Override
    public void updateInternalTypes(IGridController grid) {
        if (this.deadCache || grid != EnergyNetwork.HANDLER) {
            return;
        }
        this.isNode = true;
        if (this.grid != null) {
            this.grid.addConduit(this);
        }
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return this.grid != null;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.grid != null) {
            return this.grid.storage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.grid != null) {
            return this.grid.storage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.grid != null) {
            this.grid.storage.getMaxEnergyStored();
        }
        return 0;
    }

    public void extract(ForgeDirection forgeDirection, EnergyStorage tempStorage) {
    }

    public int transfer(ForgeDirection forgeDirection, int energy) {
        IEnergyReceiver handlerTile;
        if (this.deadCache) {
            return 0;
        }
        if (this.receiverCache != null && (handlerTile = this.receiverCache[forgeDirection.ordinal()]) != null) {
            return handlerTile.receiveEnergy(forgeDirection, energy, false);
        }
        return 0;
    }

    public void setGrid(EnergyNetwork energyNetwork) {
        this.grid = energyNetwork;
    }

    public boolean canInterface(TileEnergyConduit teConduit, ForgeDirection dir) {
        return this.receiverCache != null ? this.receiverCache[dir.ordinal()] != null : this.providerCache != null && this.providerCache[dir.ordinal()] != null;
    }

    @Override
    public void onNeighboorChanged(int x, int y, int z) {
        if (this.field_145850_b.field_72995_K | this.deadCache) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (x < this.field_145851_c) {
            this.addCache(tile, 5);
        } else if (x > this.field_145851_c) {
            this.addCache(tile, 4);
        } else if (z < this.field_145849_e) {
            this.addCache(tile, 3);
        } else if (z > this.field_145849_e) {
            this.addCache(tile, 2);
        } else if (y < this.field_145848_d) {
            this.addCache(tile, 1);
        } else if (y > this.field_145848_d) {
            this.addCache(tile, 0);
        }
    }

    @Override
    public void getTileInfo(List<IChatComponent> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        info.add(this.text("-Energy-"));
        if (this.grid != null) {
            if (debug && this.isNode) {
                info.add(this.text("Throughput All: " + this.grid.distribution));
                info.add(this.text("Throughput Side: " + this.grid.distributionSide));
            }
            if (!debug) {
                float sat = 0.0f;
                if (this.grid.getNodeCount() != 0) {
                    sat = (float)(Math.ceil((float)this.grid.storage.getEnergyStored() / (float)this.grid.storage.getMaxEnergyStored() * 1000.0f) / 10.0);
                }
                info.add(this.text("Saturation: " + sat));
            }
        } else if (!debug) {
            info.add(this.text("Null Grid"));
        }
        if (debug) {
            if (this.grid != null) {
                info.add(this.text("Grid:" + this.grid));
                info.add(this.text("Conduits: " + this.grid.getConduitCount() + ", Nodes: " + this.grid.getNodeCount()));
                info.add(this.text("Grid Max: " + this.grid.storage.getMaxEnergyStored() + ", Grid Cur: " + this.grid.storage.getEnergyStored()));
            } else {
                info.add(this.text("Null Grid"));
            }
            info.add(this.text("Node: " + this.isNode + ", Energy: " + this.energyForGrid));
            return;
        }
    }

    public IChatComponent text(String str) {
        return new ChatComponentText(str);
    }
}

