/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import li.cil.oc.api.driver.EnvironmentProvider;
import li.cil.oc.api.driver.Item;
import li.cil.oc.api.driver.item.HostAware;
import li.cil.oc.api.driver.item.UpgradeRenderer;
import li.cil.oc.api.event.RobotRenderEvent;
import li.cil.oc.api.internal.Adapter;
import li.cil.oc.api.internal.Drone;
import li.cil.oc.api.internal.Microcontroller;
import li.cil.oc.api.internal.Rack;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.api.internal.Tablet;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.ManagedEnvironment;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.oc.IntegrationOpenComputers;
import pl.asie.computronics.oc.driver.DriverBoardBoom;
import pl.asie.computronics.oc.driver.DriverBoardCapacitor;
import pl.asie.computronics.oc.driver.DriverBoardLight;
import pl.asie.computronics.oc.driver.DriverBoardSwitch;
import pl.asie.computronics.oc.driver.DriverCardBeep;
import pl.asie.computronics.oc.driver.DriverCardBoom;
import pl.asie.computronics.oc.driver.DriverCardFX;
import pl.asie.computronics.oc.driver.DriverCardNoise;
import pl.asie.computronics.oc.driver.DriverCardSound;
import pl.asie.computronics.oc.driver.DriverCardSpoof;
import pl.asie.computronics.oc.driver.RobotUpgradeCamera;
import pl.asie.computronics.oc.driver.RobotUpgradeChatBox;
import pl.asie.computronics.oc.driver.RobotUpgradeColorful;
import pl.asie.computronics.oc.driver.RobotUpgradeRadar;
import pl.asie.computronics.oc.driver.RobotUpgradeSpeech;
import pl.asie.computronics.oc.manual.IItemWithDocumentation;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;
import pl.asie.lib.item.ItemMultiple;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.driver.Item", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.driver.EnvironmentProvider", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.driver.item.HostAware", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.driver.item.UpgradeRenderer", modid="OpenComputers")})
public class ItemOpenComputers
extends ItemMultiple
implements Item,
EnvironmentProvider,
HostAware,
UpgradeRenderer,
IItemWithDocumentation {
    private IIcon colorfulUpgradeCanvasIcon;
    private IIcon colorfulUpgradeTopIcon;

    public ItemOpenComputers() {
        super("computronics", new String[]{"robot_upgrade_camera", "robot_upgrade_chatbox", "robot_upgrade_radar", "card_fx", "card_spoof", "card_beep", "card_boom", "robot_upgrade_colorful", "card_noise", "card_sound", "rack_board_light", "rack_board_boom", "rack_board_capacitor", "rack_board_switch", "robot_upgrade_speech"});
        this.func_77637_a(Computronics.tab);
    }

    @Optional.Method(modid="OpenComputers")
    public boolean worksWith(ItemStack stack) {
        return stack.func_77973_b().equals(this);
    }

    @Optional.Method(modid="OpenComputers")
    public boolean worksWith(ItemStack stack, Class<? extends EnvironmentHost> host) {
        boolean works = this.worksWith(stack);
        works = works && !Adapter.class.isAssignableFrom(host);
        switch (stack.func_77960_j()) {
            case 4: {
                works = works && !Tablet.class.isAssignableFrom(host) && !Drone.class.isAssignableFrom(host) && !Microcontroller.class.isAssignableFrom(host);
                break;
            }
            case 6: {
                works = works && !Tablet.class.isAssignableFrom(host) && !Drone.class.isAssignableFrom(host);
                break;
            }
            case 7: {
                works = works && Robot.class.isAssignableFrom(host);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                works = works && Rack.class.isAssignableFrom(host);
            }
        }
        return works;
    }

    @Optional.Method(modid="OpenComputers")
    public Class<? extends Environment> getEnvironment(ItemStack stack) {
        if (!this.worksWith(stack)) {
            return null;
        }
        switch (stack.func_77960_j()) {
            case 0: {
                return RobotUpgradeCamera.class;
            }
            case 1: {
                return RobotUpgradeChatBox.class;
            }
            case 2: {
                return RobotUpgradeRadar.class;
            }
            case 3: {
                return DriverCardFX.class;
            }
            case 4: {
                return DriverCardSpoof.class;
            }
            case 5: {
                return DriverCardBeep.class;
            }
            case 6: {
                return DriverCardBoom.class;
            }
            case 7: {
                return RobotUpgradeColorful.class;
            }
            case 8: {
                return DriverCardNoise.class;
            }
            case 9: {
                return DriverCardSound.class;
            }
            case 10: {
                return DriverBoardLight.class;
            }
            case 11: {
                return DriverBoardBoom.class;
            }
            case 12: {
                return DriverBoardCapacitor.class;
            }
            case 13: {
                return DriverBoardSwitch.class;
            }
            case 14: {
                return RobotUpgradeSpeech.class;
            }
        }
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    public ManagedEnvironment createEnvironment(ItemStack stack, EnvironmentHost container) {
        switch (stack.func_77960_j()) {
            case 0: {
                return new RobotUpgradeCamera(container);
            }
            case 1: {
                return new RobotUpgradeChatBox(container);
            }
            case 2: {
                return new RobotUpgradeRadar(container);
            }
            case 3: {
                return new DriverCardFX(container);
            }
            case 4: {
                return new DriverCardSpoof(container);
            }
            case 5: {
                return new DriverCardBeep(container);
            }
            case 6: {
                return new DriverCardBoom(container);
            }
            case 7: {
                return new RobotUpgradeColorful(container);
            }
            case 8: {
                return new DriverCardNoise(container);
            }
            case 9: {
                return new DriverCardSound(container);
            }
            case 10: {
                return container instanceof Rack ? new DriverBoardLight((Rack)container) : null;
            }
            case 11: {
                return container instanceof Rack ? new DriverBoardBoom((Rack)container) : null;
            }
            case 12: {
                return container instanceof Rack ? new DriverBoardCapacitor((Rack)container) : null;
            }
            case 13: {
                return container instanceof Rack ? new DriverBoardSwitch((Rack)container) : null;
            }
            case 14: {
                return new RobotUpgradeSpeech(container);
            }
        }
        return null;
    }

    @Optional.Method(modid="OpenComputers")
    public String slot(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "upgrade";
            }
            case 1: {
                return "upgrade";
            }
            case 2: {
                return "upgrade";
            }
            case 3: {
                return "card";
            }
            case 4: {
                return "card";
            }
            case 5: {
                return "card";
            }
            case 6: {
                return "card";
            }
            case 7: {
                return "upgrade";
            }
            case 8: {
                return "card";
            }
            case 9: {
                return "card";
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return "rack_mountable";
            }
            case 14: {
                return "upgrade";
            }
        }
        return "none";
    }

    @Optional.Method(modid="OpenComputers")
    public int tier(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return 0;
            }
            case 14: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return "camera_upgrade";
            }
            case 1: {
                return "chat_upgrade";
            }
            case 2: {
                return "radar_upgrade";
            }
            case 3: {
                return "particle_card";
            }
            case 4: {
                return "spoofing_card";
            }
            case 5: {
                return "beep_card";
            }
            case 6: {
                return "self_destructing_card";
            }
            case 7: {
                return "colorful_upgrade";
            }
            case 8: {
                return "noise_card";
            }
            case 9: {
                return "sound_card";
            }
            case 10: {
                return "light_board";
            }
            case 11: {
                return "server_self_destructor";
            }
            case 12: {
                return "rack_capacitor";
            }
            case 13: {
                return "switch_board";
            }
            case 14: {
                return "speech_upgrade";
            }
        }
        return "index";
    }

    @Optional.Method(modid="OpenComputers")
    public NBTTagCompound dataTag(ItemStack stack) {
        return OCUtils.dataTag(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(net.minecraft.item.Item item, CreativeTabs tabs, List list) {
        if (Config.OC_UPGRADE_CAMERA) {
            list.add(new ItemStack(item, 1, 0));
        }
        if (Config.OC_UPGRADE_CHATBOX) {
            list.add(new ItemStack(item, 1, 1));
        }
        if (Config.OC_UPGRADE_RADAR) {
            list.add(new ItemStack(item, 1, 2));
        }
        if (Config.OC_CARD_FX) {
            list.add(new ItemStack(item, 1, 3));
        }
        if (Config.OC_CARD_SPOOF) {
            list.add(new ItemStack(item, 1, 4));
        }
        if (Config.OC_CARD_BEEP) {
            list.add(new ItemStack(item, 1, 5));
        }
        if (Config.OC_CARD_BOOM) {
            list.add(new ItemStack(item, 1, 6));
        }
        if (Config.OC_UPGRADE_COLORFUL) {
            list.add(new ItemStack(item, 1, 7));
        }
        if (Config.OC_CARD_NOISE) {
            list.add(new ItemStack(item, 1, 8));
        }
        if (Config.OC_CARD_SOUND) {
            list.add(new ItemStack(item, 1, 9));
        }
        if (Config.OC_BOARD_LIGHT) {
            list.add(new ItemStack(item, 1, 10));
        }
        if (Config.OC_BOARD_BOOM) {
            list.add(new ItemStack(item, 1, 11));
        }
        if (Config.OC_BOARD_CAPACITOR) {
            list.add(new ItemStack(item, 1, 12));
        }
        if (Config.OC_BOARD_SWITCH) {
            list.add(new ItemStack(item, 1, 13));
        }
        if (Config.OC_UPGRADE_SPEECH) {
            list.add(new ItemStack(item, 1, 14));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister r) {
        super.func_94581_a(r);
        this.colorfulUpgradeCanvasIcon = r.func_94245_a("computronics:robot_upgrade_colorful_canvas");
        this.colorfulUpgradeTopIcon = r.func_94245_a("computronics:robot_upgrade_colorful_top");
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return meta == 7 ? 3 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int meta, int pass) {
        switch (meta) {
            case 7: {
                switch (pass) {
                    case 1: {
                        return this.colorfulUpgradeCanvasIcon;
                    }
                    case 2: {
                        return this.colorfulUpgradeTopIcon;
                    }
                }
            }
        }
        return super.func_77618_c(meta, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        switch (stack.func_77960_j()) {
            case 7: {
                int col;
                if (pass != 1) break;
                NBTTagCompound tag = this.dataTag(stack);
                if (tag.func_74764_b("computronics:color") && (col = tag.func_74762_e("computronics:color")) >= 0) {
                    return col;
                }
                return Color.HSBtoRGB((float)((System.currentTimeMillis() + (long)(stack.hashCode() % 30000)) % 30000L) / 30000.0f, 1.0f, 1.0f) & 0xFFFFFF;
            }
        }
        return super.func_82790_a(stack, pass);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return OCUtils.getRarityByTier(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        OCUtils.addTooltip(stack, tooltip, advanced);
    }

    @Optional.Method(modid="OpenComputers")
    public String computePreferredMountPoint(ItemStack stack, Robot robot, Set<String> availableMountPoints) {
        return IntegrationOpenComputers.upgradeRenderer.computePreferredMountPoint(stack, robot, availableMountPoints);
    }

    @Optional.Method(modid="OpenComputers")
    public void render(ItemStack stack, RobotRenderEvent.MountPoint mountPoint, Robot robot, float pt) {
        IntegrationOpenComputers.upgradeRenderer.render(stack, mountPoint, robot, pt);
    }
}

