/*
 * Decompiled with CFR 0.152.
 */
package radixcore.lang;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StringTranslate;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import radixcore.core.RadixCore;
import radixcore.lang.AbstractLanguageParser;
import radixcore.util.RadixExcept;
import radixcore.util.RadixMath;

public class LanguageManager {
    private String modId;
    private AbstractLanguageParser parser;
    private Map<String, String> translationsMap;

    public LanguageManager(String providedModId) {
        this.modId = providedModId.toLowerCase();
        this.translationsMap = new HashMap<String, String>();
        boolean loadedLanguage = false;
        for (StackTraceElement element : new Throwable().getStackTrace()) {
            if (!element.getClassName().equals("net.minecraft.server.dedicated.DedicatedServer")) continue;
            this.loadLanguage("en_US");
            loadedLanguage = true;
        }
        if (!loadedLanguage) {
            this.loadLanguage(this.getGameLanguageID());
        }
    }

    public LanguageManager(String modId, AbstractLanguageParser parser) {
        this(modId);
        this.parser = parser;
    }

    @SideOnly(value=Side.CLIENT)
    public String getGameLanguageID() {
        String languageID = "en_US";
        try {
            languageID = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        }
        catch (Exception e) {
            RadixCore.getLogger().error("Unable to get current language code. Defaulting to English.");
        }
        return languageID;
    }

    public String getString(String id) {
        return this.getString(id, new Object[]{null});
    }

    public String getString(String id, Object ... arguments) {
        if (this.translationsMap.containsKey(id)) {
            if (this.parser != null) {
                return this.parser.parsePhrase(this.translationsMap.get(id), arguments);
            }
            return this.translationsMap.get(id);
        }
        ArrayList<String> containingKeys = new ArrayList<String>();
        for (String key : this.translationsMap.keySet()) {
            if (!key.contains(id)) continue;
            containingKeys.add(key);
        }
        if (containingKeys.size() > 0) {
            String key = (String)containingKeys.get(RadixMath.getNumberInRange(0, containingKeys.size() - 1));
            if (this.parser != null) {
                return this.parser.parsePhrase(this.translationsMap.get(key), arguments);
            }
            return this.translationsMap.get(key);
        }
        RadixCore.getLogger().error("[" + this.modId + "] No mapping found for requested phrase ID: " + id);
        Throwable trace = new Throwable();
        RadixExcept.logErrorCatch(trace, "Stacktrace for non-fatal error.");
        return id;
    }

    public int getNumberOfPhrasesMatchingID(String id) {
        ArrayList<String> containingKeys = new ArrayList<String>();
        for (String key : this.translationsMap.keySet()) {
            if (!key.contains(id)) continue;
            containingKeys.add(key);
        }
        return containingKeys.size();
    }

    public void loadLanguage(String languageId) {
        this.translationsMap.clear();
        if (languageId.startsWith("en_") && !languageId.equals("en_US")) {
            this.loadLanguage("en_US");
        } else if (languageId.startsWith("es_") && !languageId.equals("es_ES")) {
            this.loadLanguage("es_ES");
        }
        InputStream inStream = StringTranslate.class.getResourceAsStream("/assets/" + this.modId + "/lang/" + languageId + ".lang");
        if (inStream == null) {
            if (languageId.equals("en_US")) {
                throw new RuntimeException("Unable to load English language files. Loading cannot continue.");
            }
            RadixCore.getLogger().error("Cannot load language " + languageId + " for " + this.modId + ". Defaulting to English.");
            this.loadLanguage("en_US");
        } else {
            try {
                List lines = IOUtils.readLines((InputStream)inStream, (Charset)Charsets.UTF_8);
                int lineNumber = 0;
                for (String line : lines) {
                    String value;
                    ++lineNumber;
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] split = line.split("\\=");
                    String key = split[0];
                    String string = value = split.length == 2 ? split[1].replace("\\", "") : "";
                    if (key.isEmpty()) {
                        throw new IOException("Empty phrase key on line " + lineNumber);
                    }
                    if (value.isEmpty()) {
                        RadixCore.getLogger().warn("Empty phrase value on line " + lineNumber + ". Key value: " + key);
                    }
                    this.translationsMap.put(key, value);
                }
                RadixCore.getLogger().info("Loaded language " + languageId + " for " + this.modId + ".");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

