/*
 * Decompiled with CFR 0.152.
 */
package radixcore.core;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.command.ICommandSender;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import radixcore.core.ModMetadataEx;
import radixcore.core.RadixCore;
import radixcore.data.AbstractPlayerData;
import radixcore.data.IWatchable;
import radixcore.packets.PacketDataSyncReq;
import radixcore.update.UpdateChecker;

public class RadixEvents {
    @SubscribeEvent
    public void playerLoggedInEventHandler(PlayerEvent.PlayerLoggedInEvent event) {
        for (ModMetadataEx exData : RadixCore.registeredMods) {
            if (!RadixCore.allowUpdateChecking || !event.player.field_70170_p.field_72995_K) continue;
            try {
                new Thread(new UpdateChecker(exData, (ICommandSender)event.player)).start();
            }
            catch (Exception e) {
                RadixCore.getLogger().error("Unexpected exception while starting update checker for " + exData.name + ". Error was " + e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public void entitySpawnedEvent(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K && event.entity instanceof IWatchable) {
            RadixCore.getPacketHandler().sendPacketToServer(new PacketDataSyncReq(event.entity.func_145782_y()));
        }
    }

    @SubscribeEvent
    public void worldSaveEventHandler(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            for (ModMetadataEx metadata : RadixCore.registeredMods) {
                if (metadata.playerDataMap == null) continue;
                for (AbstractPlayerData data : metadata.playerDataMap.values()) {
                    if (data != null) {
                        data.saveDataToFile();
                        continue;
                    }
                    RadixCore.getLogger().error("Skipping save of null player data for mod " + metadata.modId + ". You may notice a few oddities. Please report if so.");
                }
            }
        }
    }
}

