/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.common.rple;

import com.falsepattern.lumi.api.chunk.LumiChunkRoot;
import com.falsepattern.lumi.api.world.LumiWorld;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.common.chunk.RPLEChunkRoot;
import com.falsepattern.rple.internal.common.world.RPLEWorld;
import com.falsepattern.rple.internal.common.world.RPLEWorldContainer;
import com.falsepattern.rple.internal.common.world.RPLEWorldRoot;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={World.class}, priority=1010)
public abstract class RPLEWorldRootImplMixin
implements IBlockAccess,
LumiWorld,
RPLEWorldRoot {
    @Shadow
    protected IChunkProvider field_73020_y;
    @Final
    @Shadow
    public Profiler field_72984_F;
    private RPLEWorld rple$redChannel;
    private RPLEWorld rple$greenChannel;
    private RPLEWorld rple$blueChannel;

    @Inject(method={"lumi$onWorldInit()V"}, at={@At(value="RETURN")}, remap=false, require=1)
    @Dynamic(value="Implemented by [Lumi] with the interface [com.falsepattern.lumi.api.init.LumiWorldInitHook]")
    private void rpleWorldInit(CallbackInfo ci) {
        this.rple$redChannel = new RPLEWorldContainer(ColorChannel.RED_CHANNEL, this.thiz(), this, this.field_72984_F);
        this.rple$greenChannel = new RPLEWorldContainer(ColorChannel.GREEN_CHANNEL, this.thiz(), this, this.field_72984_F);
        this.rple$blueChannel = new RPLEWorldContainer(ColorChannel.BLUE_CHANNEL, this.thiz(), this, this.field_72984_F);
    }

    @Override
    @Nullable
    public RPLEChunkRoot rple$getChunkRootFromBlockPosIfExists(int posX, int posZ) {
        int chunkPosX = posX >> 4;
        int chunkPosZ = posZ >> 4;
        return this.rple$getChunkRootFromChunkPosIfExists(chunkPosX, chunkPosZ);
    }

    @Override
    @Nullable
    public RPLEChunkRoot rple$getChunkRootFromChunkPosIfExists(int chunkPosX, int chunkPosZ) {
        Chunk chunk;
        if (this.field_73020_y == null) {
            return null;
        }
        if (this.field_73020_y instanceof ChunkProviderServer) {
            ChunkProviderServer chunkProviderServer = (ChunkProviderServer)this.field_73020_y;
            LongHashMap loadedChunks = chunkProviderServer.field_73244_f;
            Object chunk2 = loadedChunks.func_76164_a(ChunkCoordIntPair.func_77272_a((int)chunkPosX, (int)chunkPosZ));
            if (chunk2 instanceof LumiChunkRoot) {
                return (RPLEChunkRoot)chunk2;
            }
        }
        if (this.field_73020_y.func_73149_a(chunkPosX, chunkPosZ) && (chunk = this.field_73020_y.func_73154_d(chunkPosX, chunkPosZ)) instanceof LumiChunkRoot) {
            return (RPLEChunkRoot)chunk;
        }
        return null;
    }

    @Override
    @NotNull
    public RPLEWorld rple$world(@NotNull ColorChannel channel) {
        return this.rple$blockStorage(channel);
    }

    @Override
    @NotNull
    public RPLEWorld rple$blockStorage(@NotNull ColorChannel channel) {
        switch (channel) {
            default: {
                return this.rple$redChannel;
            }
            case GREEN_CHANNEL: {
                return this.rple$greenChannel;
            }
            case BLUE_CHANNEL: 
        }
        return this.rple$blueChannel;
    }

    private World thiz() {
        return (World)this;
    }
}

