/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.common.appliedenergistics2;

import appeng.api.parts.IPart;
import appeng.api.util.AEColor;
import appeng.helpers.AEMultiTile;
import appeng.parts.CableBusContainer;
import appeng.parts.CableBusStorage;
import appeng.parts.ICableBusContainer;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.color.LightValueColor;
import com.falsepattern.rple.internal.mixin.interfaces.appliedenergistics2.ICableBusContainerMixin;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CableBusContainer.class}, remap=false)
public abstract class CableBusContainerMixin
extends CableBusStorage
implements AEMultiTile,
ICableBusContainer,
ICableBusContainerMixin {
    @Shadow
    public abstract AEColor getColor();

    @Override
    public short rple$getColoredBrightness() {
        int light = 0;
        for (ForgeDirection direction : ForgeDirection.values()) {
            IPart part = this.getPart(direction);
            if (part == null) continue;
            light = Math.max(part.getLightLevel(), light);
        }
        if (light < 1) {
            return LightValueColor.LIGHT_VALUE_0.rgb16();
        }
        int colorRGB = this.getColor().mediumVariant;
        int red = (int)((float)(colorRGB >>> 16 & 0xFF) / 255.0f * (float)light) & 0xF;
        int green = (int)((float)(colorRGB >>> 8 & 0xFF) / 255.0f * (float)light) & 0xF;
        int blue = (int)((float)(colorRGB & 0xFF) / 255.0f * (float)light) & 0xF;
        return ServerColorHelper.RGB16FromRGBChannel4Bit(red, green, blue);
    }
}

