/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.mixins.client;

import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.CookieMonster;
import com.falsepattern.rple.internal.client.lightmap.LightMap;
import com.falsepattern.rple.internal.client.render.VertexConstants;
import com.falsepattern.rple.internal.mixin.interfaces.ITessellatorMixin;
import java.nio.ShortBuffer;
import net.minecraft.client.renderer.Tessellator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Tessellator.class})
public abstract class TessellatorMixin
implements ITessellatorMixin {
    @Shadow
    private static ShortBuffer field_147567_e;
    @Shadow
    private int[] field_78405_h;
    @Shadow
    private boolean field_78414_p;
    @Shadow
    private int field_147569_p;
    @Unique
    private long rple$rgb64;

    @Redirect(method={"draw"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/Tessellator;hasBrightness:Z", opcode=180, ordinal=0), require=1)
    private boolean enable(Tessellator tess) {
        if (this.field_78414_p) {
            ShortBuffer shortBuffer = ((ITessellatorMixin)tess).rple$shortBuffer();
            LightMap.lightMap().enable();
            LightMap.lightMap().enableVertexPointers(shortBuffer);
        }
        return false;
    }

    @Redirect(method={"draw"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/Tessellator;hasBrightness:Z", opcode=180, ordinal=1), require=1)
    private boolean disable(Tessellator instance) {
        if (this.field_78414_p) {
            LightMap.lightMap().disableVertexPointers();
        }
        return false;
    }

    @Redirect(method={"addVertex"}, at=@At(value="FIELD", target="Lnet/minecraft/client/renderer/Tessellator;hasBrightness:Z", opcode=180), require=1)
    private boolean customColor(Tessellator instance) {
        if (this.field_78414_p) {
            this.field_78405_h[this.field_147569_p + VertexConstants.getRedIndexNoShader()] = ClientColorHelper.tessFromRGB64Red(this.rple$rgb64);
            this.field_78405_h[this.field_147569_p + VertexConstants.getGreenIndexNoShader()] = ClientColorHelper.tessFromRGB64Green(this.rple$rgb64);
            this.field_78405_h[this.field_147569_p + VertexConstants.getBlueIndexNoShader()] = ClientColorHelper.tessFromRGB64Blue(this.rple$rgb64);
        }
        return false;
    }

    @Overwrite
    public void func_78380_c(int brightness) {
        this.rple$setRGB64Brightness(CookieMonster.RGB64FromCookie(brightness));
    }

    @Override
    public ShortBuffer rple$shortBuffer() {
        return field_147567_e;
    }

    @Override
    public void rple$setRGB64Brightness(long rgb64) {
        this.field_78414_p = true;
        this.rple$rgb64 = rgb64;
    }

    @Override
    public long rple$getRGB64Brightness() {
        return this.rple$rgb64;
    }
}

