/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.mixin.hook;

import com.falsepattern.falsetweaks.api.dynlights.FTDynamicLights;
import com.falsepattern.rple.api.client.ClientColorHelper;
import com.falsepattern.rple.api.client.CookieMonster;
import com.falsepattern.rple.api.client.RPLETessBrightnessUtil;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.block.RPLEBlock;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.client.dynlights.ColorDynamicLights;
import com.falsepattern.rple.internal.client.render.EntityColorHandler;
import com.falsepattern.rple.internal.common.chunk.RPLESubChunkRoot;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public final class ColoredLightingHooks {
    public static int getMaxBlockLightValue(ExtendedBlockStorage subChunkBase, int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        RPLESubChunkRoot subChunkRoot = (RPLESubChunkRoot)subChunkBase;
        int redLightValue = subChunkRoot.rple$subChunk(ColorChannel.RED_CHANNEL).lumi$getBlockLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
        int greenLightValue = subChunkRoot.rple$subChunk(ColorChannel.GREEN_CHANNEL).lumi$getBlockLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
        int blueLightValue = subChunkRoot.rple$subChunk(ColorChannel.BLUE_CHANNEL).lumi$getBlockLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
        return ServerColorHelper.maxColorComponent(redLightValue, greenLightValue, blueLightValue);
    }

    public static int getMaxSkyLightValue(ExtendedBlockStorage subChunkBase, int subChunkPosX, int subChunkPosY, int subChunkPosZ) {
        RPLESubChunkRoot subChunkRoot = (RPLESubChunkRoot)subChunkBase;
        int redLightValue = subChunkRoot.rple$subChunk(ColorChannel.RED_CHANNEL).lumi$getSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
        int greenLightValue = subChunkRoot.rple$subChunk(ColorChannel.GREEN_CHANNEL).lumi$getSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
        int blueLightValue = subChunkRoot.rple$subChunk(ColorChannel.BLUE_CHANNEL).lumi$getSkyLightValue(subChunkPosX, subChunkPosY, subChunkPosZ);
        return ServerColorHelper.maxColorComponent(redLightValue, greenLightValue, blueLightValue);
    }

    public static int getLightValue(Block block) {
        RPLEBlock rpleBlock = RPLEBlock.of(block);
        short color = rpleBlock.rple$getBrightnessColor();
        return ServerColorHelper.lightValueFromRGB16(color);
    }

    public static int getLightValue(IBlockAccess world, Block block, int posX, int posY, int posZ) {
        RPLEBlock rpleBlock = RPLEBlock.of(block);
        int blockMeta = world.func_72805_g(posX, posY, posZ);
        short color = rpleBlock.rple$getBrightnessColor(world, blockMeta, posX, posY, posZ);
        return ServerColorHelper.lightValueFromRGB16(color);
    }

    public static int getLightOpacity(Block block) {
        RPLEBlock rpleBlock = RPLEBlock.of(block);
        short color = rpleBlock.rple$getTranslucencyColor();
        return ServerColorHelper.lightOpacityFromRGB16(color);
    }

    public static int getLightOpacity(IBlockAccess world, Block block, int posX, int posY, int posZ) {
        RPLEBlock rpleBlock = RPLEBlock.of(block);
        int blockMeta = world.func_72805_g(posX, posY, posZ);
        short color = rpleBlock.rple$getTranslucencyColor(world, blockMeta, posX, posY, posZ);
        return ServerColorHelper.lightOpacityFromRGB16(color);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getEntityRGBBrightnessForTessellator(Entity entity, IBlockAccess world, int posX, int posY, int posZ, int minBrightnessCookie) {
        int brightness = world.func_72802_i(posX, posY, posZ, minBrightnessCookie);
        if (FTDynamicLights.isDynamicLights()) {
            brightness = ColorDynamicLights.INSTANCE.getCombinedLight(posX, posY, posZ, brightness);
        }
        if (EntityColorHandler.isOnBlockList(entity.getClass())) {
            long rgb64 = CookieMonster.RGB64FromCookie(brightness);
            brightness = ClientColorHelper.vanillaFromRGB64Max(rgb64);
        }
        return brightness;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getBlockRGBBrightnessForTessellator(IBlockAccess world, int posX, int posY, int posZ) {
        Block block = world.func_147439_a(posX, posY, posZ);
        int blockMeta = world.func_72805_g(posX, posY, posZ);
        int brightnessCookie = RPLETessBrightnessUtil.getBlockBrightnessForTessellator(world, block, blockMeta, posX, posY, posZ);
        if ((brightnessCookie = world.func_72802_i(posX, posY, posZ, brightnessCookie)) == 0 && block instanceof BlockSlab) {
            block = world.func_147439_a(posX, --posY, posZ);
            blockMeta = world.func_72805_g(posX, posY, posZ);
            brightnessCookie = RPLETessBrightnessUtil.getBlockBrightnessForTessellator(world, block, blockMeta, posX, posY, posZ);
            brightnessCookie = world.func_72802_i(posX, posY, posZ, brightnessCookie);
        }
        return brightnessCookie;
    }

    @SideOnly(value=Side.CLIENT)
    public static int getBlockFluidRGBBrightnessForTessellator(IBlockAccess world, int posX, int posY, int posZ) {
        int brightness = world.func_72802_i(posX, posY, posZ, 0);
        int topBrightness = world.func_72802_i(posX, posY + 1, posZ, 0);
        return ClientColorHelper.cookieMax(brightness, topBrightness);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getRGBBrightnessForTessellator(IBlockAccess world, int posX, int posY, int posZ) {
        return RPLETessBrightnessUtil.getRGBBrightnessForTessellator(world, posX, posY, posZ);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public static int getRGBBrightnessForTessellator(IBlockAccess world, int posX, int posY, int posZ, int minBrightnessCookie) {
        long rgb64MinBrightness = CookieMonster.RGB64FromCookie(minBrightnessCookie);
        int minRedBrightness = ClientColorHelper.vanillaFromRGB64Red(rgb64MinBrightness);
        int minGreenBrightness = ClientColorHelper.vanillaFromRGB64Green(rgb64MinBrightness);
        int minBlueBrightness = ClientColorHelper.vanillaFromRGB64Blue(rgb64MinBrightness);
        int minRedBlockLight = ClientColorHelper.block4BitFromVanilla(minRedBrightness);
        int minGreenBlockLight = ClientColorHelper.block4BitFromVanilla(minGreenBrightness);
        int minBlueBlockLight = ClientColorHelper.block4BitFromVanilla(minBlueBrightness);
        return RPLETessBrightnessUtil.getRGBBrightnessForTessellator(world, posX, posY, posZ, minRedBlockLight, minGreenBlockLight, minBlueBlockLight);
    }

    @Generated
    private ColoredLightingHooks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

