/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public abstract class FastThreadLocal<S> {
    private static final List<WeakReference<FastThreadLocal<?>>> liveThreadLocals = new ArrayList();
    private static final int MAX_LIVE_TURBO_THREADS = 128;
    private static Thread MAIN_THREAD = null;
    protected final ThreadLocal<S> threadLocal;
    protected final Object[] turboLookup = new Object[128];
    protected S mainThreadValue;

    public static void setMainThread(Thread mainThread) {
        MAIN_THREAD = mainThread;
    }

    protected FastThreadLocal(ThreadLocal<S> threadLocal, S mainThreadValue) {
        this.threadLocal = threadLocal;
        this.mainThreadValue = mainThreadValue;
        liveThreadLocals.add(new WeakReference<FastThreadLocal>(this));
    }

    private void doCleanup(TurboThread thread) {
        this.turboLookup[((TurboThread)thread).setIndex] = null;
    }

    protected boolean isMainThread(Thread thread) {
        return thread == MAIN_THREAD;
    }

    public static class TurboThread
    extends Thread {
        private static final BitSet theSet = new BitSet(128);
        private boolean started = false;
        private int setIndex;

        public TurboThread() {
        }

        public TurboThread(Runnable target) {
            super(target);
        }

        public TurboThread(String name) {
            super(name);
        }

        public TurboThread(Runnable target, String name) {
            super(target, name);
        }

        @Override
        public void run() {
            this.onStartup();
            try {
                super.run();
            }
            finally {
                this.onShutdown();
            }
        }

        protected void onStartup() {
            BitSet bitSet = theSet;
            synchronized (bitSet) {
                for (int i = 0; i < 128; ++i) {
                    if (theSet.get(i)) continue;
                    theSet.set(i);
                    this.setIndex = i;
                    this.started = true;
                    return;
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onShutdown() {
            if (!this.started) {
                return;
            }
            BitSet bitSet = theSet;
            synchronized (bitSet) {
                Iterator iter = liveThreadLocals.iterator();
                while (iter.hasNext()) {
                    FastThreadLocal el = (FastThreadLocal)((WeakReference)iter.next()).get();
                    if (el == null) {
                        iter.remove();
                        continue;
                    }
                    el.doCleanup(this);
                }
                theSet.clear(this.setIndex);
            }
            this.started = false;
        }
    }

    public static final class DynamicValue<S>
    extends FastThreadLocal<S> {
        public DynamicValue() {
            super(new ThreadLocal(), null);
        }

        public void set(S value) {
            Thread t = Thread.currentThread();
            if (this.isMainThread(t)) {
                this.mainThreadValue = value;
            } else if (t instanceof TurboThread) {
                TurboThread tt = (TurboThread)t;
                this.turboLookup[((TurboThread)tt).setIndex] = value;
            } else {
                this.threadLocal.set(value);
            }
        }

        public S get() {
            Thread t = Thread.currentThread();
            if (this.isMainThread(t)) {
                return (S)this.mainThreadValue;
            }
            if (t instanceof TurboThread) {
                TurboThread tt = (TurboThread)t;
                return (S)this.turboLookup[tt.setIndex];
            }
            return (S)this.threadLocal.get();
        }
    }

    public static final class FixedValue<S>
    extends FastThreadLocal<S> {
        private final Supplier<S> initializer;

        public FixedValue(Supplier<S> initializer) {
            super(ThreadLocal.withInitial(initializer), null);
            this.initializer = initializer;
        }

        public S get() {
            Thread t = Thread.currentThread();
            if (this.isMainThread(t)) {
                if (this.mainThreadValue == null) {
                    this.mainThreadValue = this.initializer.get();
                }
                return (S)this.mainThreadValue;
            }
            if (t instanceof TurboThread) {
                TurboThread tt = (TurboThread)t;
                Object value = this.turboLookup[tt.setIndex];
                if (value == null) {
                    this.turboLookup[((TurboThread)tt).setIndex] = value = this.initializer.get();
                }
                return (S)value;
            }
            return (S)this.threadLocal.get();
        }
    }
}

