/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.lamp;

import com.falsepattern.lib.util.RenderUtil;
import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.block.RPLECustomBlockBrightness;
import com.falsepattern.rple.api.common.color.DefaultColor;
import com.falsepattern.rple.internal.client.lamp.LampRenderer;
import java.util.List;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class LampBlock
extends Block
implements RPLECustomBlockBrightness {
    private static final String GLOW_RESOURCE = "rple:glow";
    public static final int POWERED_BIT = 2;
    public static final int INVERTED_BIT = 1;
    private final short color;
    private IIcon glowIcon = null;
    private IIcon poweredIcon = null;

    public LampBlock(int r, int g, int b) {
        super(Material.field_151576_e);
        if (r < 0 || r > 15) {
            throw new IllegalArgumentException("Red value must be between 0 and 15");
        }
        if (g < 0 || g > 15) {
            throw new IllegalArgumentException("Green value must be between 0 and 15");
        }
        if (b < 0 || b > 15) {
            throw new IllegalArgumentException("Blue value must be between 0 and 15");
        }
        this.color = ServerColorHelper.RGB16FromRGBChannel4Bit(r, g, b);
        this.func_149711_c(0.3f);
        this.func_149672_a(field_149778_k);
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public static boolean isGlowing(int meta) {
        return ((meta ^ meta >>> 1) & 1) == 1;
    }

    protected abstract String getOffTextureName();

    protected abstract String getOnTextureName();

    public void func_149651_a(@NotNull IIconRegister register) {
        this.field_149761_L = register.func_94245_a(this.getOffTextureName());
        this.poweredIcon = register.func_94245_a(this.getOnTextureName());
        this.glowIcon = RenderUtil.wrapAsClampedIcon((IIcon)register.func_94245_a(GLOW_RESOURCE));
    }

    public IIcon func_149691_a(int side, int meta) {
        return LampBlock.isGlowing(meta) ? this.poweredIcon : this.field_149761_L;
    }

    public IIcon getGlowIcon() {
        return this.glowIcon;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.onBlockUpdate(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.onBlockUpdate(world, x, y, z);
    }

    private void onBlockUpdate(World world, int x, int y, int z) {
        boolean powered;
        if (world.field_72995_K) {
            return;
        }
        boolean indirectlyPowered = world.func_72864_z(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        boolean bl = powered = (meta & 2) != 0;
        if (powered && !indirectlyPowered) {
            world.func_72921_c(x, y, z, meta & 0xFFFFFFFD, 3);
        } else if (!powered && indirectlyPowered) {
            world.func_72921_c(x, y, z, meta | 2, 3);
        }
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 1, meta &= 0xFFFFFFFD);
    }

    public int func_149692_a(int meta) {
        return meta & 0xFFFFFFFD;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    public int func_149645_b() {
        return LampRenderer.RENDER_ID;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    @Override
    public short rple$getCustomBrightnessColor() {
        return DefaultColor.BLACK.rgb16();
    }

    protected static boolean shouldGlow(int meta) {
        boolean powered = (meta & 2) != 0;
        boolean inverted = (meta & 1) != 0;
        return powered != inverted;
    }

    @Override
    public short rple$getCustomBrightnessColor(int blockMeta) {
        return LampBlock.shouldGlow(blockMeta) ? this.color : DefaultColor.BLACK.rgb16();
    }

    @Override
    public short rple$getCustomBrightnessColor(@NotNull IBlockAccess world, int blockMeta, int posX, int posY, int posZ) {
        return LampBlock.shouldGlow(blockMeta) ? this.color : DefaultColor.BLACK.rgb16();
    }

    @Generated
    public short getColor() {
        return this.color;
    }
}

