/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.event;

import com.falsepattern.lumi.api.event.LumiWorldProviderRegistrationEvent;
import com.falsepattern.lumi.api.world.LumiWorldProvider;
import com.falsepattern.lumi.api.world.LumiWorldProviderRegistry;
import com.falsepattern.rple.internal.common.util.LogHelper;
import com.falsepattern.rple.internal.common.world.RPLEWorldProvider;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import lombok.Generated;
import org.apache.logging.log4j.Logger;

public final class LumiEventHandler {
    private static final Logger LOG = LogHelper.createLogger("Lumi Event Handler");
    private static final LumiEventHandler INSTANCE = new LumiEventHandler();
    private static final EventBus EVENT_BUS = FMLCommonHandler.instance().bus();
    private boolean isRegistered = false;

    public static LumiEventHandler lumiEventHandler() {
        return INSTANCE;
    }

    public void registerEventHandler() {
        if (this.isRegistered) {
            return;
        }
        EVENT_BUS.register((Object)this);
        this.isRegistered = true;
        LOG.info("Registered event handler");
    }

    @SubscribeEvent
    public void lumiWorldRegistration(LumiWorldProviderRegistrationEvent evt) {
        LumiWorldProviderRegistry registry = evt.registry();
        registry.hijackDefaultWorldProviders("Right Proper Lighting Engine");
        registry.registerWorldProvider((LumiWorldProvider)RPLEWorldProvider.redRPLEWorldProvider());
        registry.registerWorldProvider((LumiWorldProvider)RPLEWorldProvider.greenRPLEWorldProvider());
        registry.registerWorldProvider((LumiWorldProvider)RPLEWorldProvider.blueRPLEWorldProvider());
        LOG.info("Registered RGB world providers");
    }

    @Generated
    private LumiEventHandler() {
    }
}

