/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.container;

import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.api.common.color.DefaultColor;
import lombok.Generated;

public final class HexColor {
    public static final HexColor INVALID_HEX_COLOR = new HexColor(DefaultColor.ERROR.rgb16(), false);
    private static final String EXPECTED_REGEX = "0x[A-F0-9]{3}$";
    private final short rgb16;
    private final String asColorHex;
    private final boolean isValid;

    public HexColor(short rgb16) {
        this(rgb16, true);
    }

    public HexColor(short rgb16, boolean valid) {
        this.rgb16 = rgb16;
        this.asColorHex = HexColor.colorHexFromColor(rgb16);
        this.isValid = valid;
    }

    public HexColor(String colorHex) {
        int red = 0;
        int green = 0;
        int blue = 0;
        String asColorHex = "";
        boolean isValid = false;
        try {
            if (!HexColor.isValidColorHex(colorHex)) {
                throw new IllegalArgumentException();
            }
            red = HexColor.componentFromHex(ColorChannel.RED_CHANNEL, colorHex);
            green = HexColor.componentFromHex(ColorChannel.GREEN_CHANNEL, colorHex);
            blue = HexColor.componentFromHex(ColorChannel.BLUE_CHANNEL, colorHex);
            asColorHex = colorHex;
            isValid = true;
        }
        catch (IllegalArgumentException e) {
            short errorColor = DefaultColor.ERROR.rgb16();
            red = ServerColorHelper.red(errorColor);
            green = ServerColorHelper.green(errorColor);
            blue = ServerColorHelper.blue(errorColor);
            asColorHex = HexColor.colorHexFromColor(errorColor);
            isValid = false;
        }
        this.rgb16 = ServerColorHelper.RGB16FromRGBChannel4Bit(red, green, blue);
        this.asColorHex = asColorHex;
        this.isValid = isValid;
    }

    public int hashCode() {
        return this.rgb16;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HexColor)) {
            return false;
        }
        return this.rgb16 == ((HexColor)obj).rgb16;
    }

    public String toString() {
        return this.asColorHex;
    }

    public static boolean isValidColorHex(String colorHex) {
        if (colorHex == null) {
            return false;
        }
        return colorHex.matches(EXPECTED_REGEX);
    }

    private static int componentFromHex(ColorChannel channel, String colorHex) {
        int position = channel.ordinal() + 2;
        char hexChar = colorHex.charAt(position);
        String hexString = String.valueOf(hexChar);
        return Integer.parseUnsignedInt(hexString, 16);
    }

    private static String colorHexFromColor(short rgb16) {
        int red = ColorChannel.RED_CHANNEL.componentFromColor(rgb16);
        int green = ColorChannel.GREEN_CHANNEL.componentFromColor(rgb16);
        int blue = ColorChannel.BLUE_CHANNEL.componentFromColor(rgb16);
        char redHex = HexColor.hexCharFromNibble(red);
        char greenHex = HexColor.hexCharFromNibble(green);
        char blueHex = HexColor.hexCharFromNibble(blue);
        return String.format("0x%c%c%c", Character.valueOf(redHex), Character.valueOf(greenHex), Character.valueOf(blueHex));
    }

    private static char hexCharFromNibble(int nibble) {
        if (nibble < 0) {
            return '0';
        }
        switch (nibble) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
        }
        return 'F';
    }

    @Generated
    public short rgb16() {
        return this.rgb16;
    }

    @Generated
    public String asColorHex() {
        return this.asColorHex;
    }

    @Generated
    public boolean isValid() {
        return this.isValid;
    }
}

