/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.config.adapter;

import com.falsepattern.rple.internal.common.config.ColorConfigLoader;
import com.falsepattern.rple.internal.common.config.container.BlockReference;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import lombok.Generated;

public final class BlockReferenceJSONAdapter
extends TypeAdapter<BlockReference> {
    public void write(JsonWriter out, BlockReference value) {
        ColorConfigLoader.colorConfigGSON().toJson((Object)value.toString(), String.class, out);
    }

    public BlockReference read(JsonReader in) {
        String blockID;
        try {
            blockID = (String)ColorConfigLoader.colorConfigGSON().fromJson(in, String.class);
        }
        catch (JsonSyntaxException e) {
            ColorConfigLoader.logParsingError("Failed parsing block reference: {}", e.getMessage());
            return BlockReference.INVALID_BLOCK_REFERENCE;
        }
        BlockReference blockReference = new BlockReference(blockID);
        if (!blockReference.isValid()) {
            ColorConfigLoader.logParsingError("Invalid block reference: {}", blockID);
        }
        return blockReference;
    }

    @Generated
    public BlockReferenceJSONAdapter() {
    }
}

