/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.common.colorizer;

import com.falsepattern.rple.api.common.color.RPLENamedColor;
import com.falsepattern.rple.api.common.colorizer.RPLEBlockColorizer;
import com.falsepattern.rple.internal.common.config.container.BlockReference;
import com.falsepattern.rple.internal.common.config.container.ColorReference;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockColorizer
implements RPLEBlockColorizer {
    private final BlockReference block;
    private final Consumer<BlockColorizer> applyCallback;
    private short brightness;
    private short translucency;
    @Nullable
    private RPLENamedColor paletteBrightness;
    @Nullable
    private RPLENamedColor paletteTranslucency;
    private boolean hasApplied = false;

    public BlockColorizer(BlockReference block, Consumer<BlockColorizer> applyCallback) {
        this.block = block;
        this.applyCallback = applyCallback;
        this.brightness = (short)-1;
        this.translucency = (short)-1;
        this.paletteBrightness = null;
        this.paletteTranslucency = null;
        this.hasApplied = false;
    }

    public Optional<BlockColorReference> brightness() {
        if (this.brightness == -1) {
            return Optional.empty();
        }
        return Optional.of(BlockColorizer.wrappedBlockColor(this.block, ColorReference.paletteOrRaw(this.paletteBrightness, this.brightness)));
    }

    public Optional<BlockColorReference> translucency() {
        if (this.translucency == -1) {
            return Optional.empty();
        }
        return Optional.of(BlockColorizer.wrappedBlockColor(this.block, ColorReference.paletteOrRaw(this.paletteTranslucency, this.translucency)));
    }

    public Optional<RPLENamedColor> paletteBrightness() {
        return Optional.ofNullable(this.paletteBrightness);
    }

    public Optional<RPLENamedColor> paletteTranslucency() {
        return Optional.ofNullable(this.paletteTranslucency);
    }

    @Override
    @NotNull
    public RPLEBlockColorizer brightness(short color) {
        this.resetBrightness();
        this.brightness = color;
        return this;
    }

    @Override
    @NotNull
    public RPLEBlockColorizer brightness(@NotNull RPLENamedColor color) {
        this.resetBrightness();
        this.brightness = color.rgb16();
        this.paletteBrightness = color;
        return this;
    }

    @Override
    @NotNull
    public RPLEBlockColorizer translucency(short color) {
        this.resetTranslucency();
        this.translucency = color;
        return this;
    }

    @Override
    @NotNull
    public RPLEBlockColorizer translucency(@NotNull RPLENamedColor color) {
        this.resetTranslucency();
        this.translucency = color.rgb16();
        this.paletteTranslucency = color;
        return this;
    }

    @Override
    public void apply() {
        if (this.hasApplied) {
            return;
        }
        this.applyCallback.accept(this);
        this.hasApplied = true;
    }

    private void resetBrightness() {
        this.brightness = (short)-1;
        this.paletteBrightness = null;
    }

    private void resetTranslucency() {
        this.translucency = (short)-1;
        this.paletteTranslucency = null;
    }

    private static BlockColorReference wrappedBlockColor(BlockReference block, ColorReference color) {
        return new BlockColorReference(block, color);
    }

    public static final class BlockColorReference {
        private final BlockReference block;
        private final ColorReference color;

        public boolean isValid() {
            return this.block.isValid() && this.color.isValid();
        }

        @Generated
        public BlockReference block() {
            return this.block;
        }

        @Generated
        public ColorReference color() {
            return this.color;
        }

        @Generated
        private BlockColorReference(BlockReference block, ColorReference color) {
            this.block = block;
            this.color = color;
        }
    }
}

