/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.render;

import com.falsepattern.rple.api.common.ServerColorHelper;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.common.world.RPLEWorldRoot;
import net.minecraft.world.IBlockAccess;

public final class RPLEWorldUtil {
    private RPLEWorldUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static int getChannelBlockLightValue(IBlockAccess world, ColorChannel channel, int posX, int posY, int posZ) {
        RPLEWorldRoot worldRoot = (RPLEWorldRoot)world;
        return worldRoot.rple$world(channel).lumi$getBlockLightValue(posX, posY, posZ);
    }

    public static int getChannelSkyLightValue(IBlockAccess world, ColorChannel channel, int posX, int posY, int posZ) {
        RPLEWorldRoot worldRoot = (RPLEWorldRoot)world;
        return worldRoot.rple$world(channel).lumi$getSkyLightValue(posX, posY, posZ);
    }

    public static int getGreyscaleLightValue(IBlockAccess world, int posX, int posY, int posZ) {
        RPLEWorldRoot worldRoot = (RPLEWorldRoot)world;
        int redLightValue = worldRoot.rple$world(ColorChannel.RED_CHANNEL).lumi$getLightValue(posX, posY, posZ);
        int greenLightValue = worldRoot.rple$world(ColorChannel.GREEN_CHANNEL).lumi$getLightValue(posX, posY, posZ);
        int blueLightValue = worldRoot.rple$world(ColorChannel.BLUE_CHANNEL).lumi$getLightValue(posX, posY, posZ);
        return ServerColorHelper.maxColorComponent(redLightValue, greenLightValue, blueLightValue);
    }

    public static int getGreyscaleBlockLightValue(IBlockAccess world, int posX, int posY, int posZ) {
        RPLEWorldRoot worldRoot = (RPLEWorldRoot)world;
        int redLightValue = worldRoot.rple$world(ColorChannel.RED_CHANNEL).lumi$getBlockLightValue(posX, posY, posZ);
        int greenLightValue = worldRoot.rple$world(ColorChannel.GREEN_CHANNEL).lumi$getBlockLightValue(posX, posY, posZ);
        int blueLightValue = worldRoot.rple$world(ColorChannel.BLUE_CHANNEL).lumi$getBlockLightValue(posX, posY, posZ);
        return ServerColorHelper.maxColorComponent(redLightValue, greenLightValue, blueLightValue);
    }

    public static int getGreyscaleSkyLightValue(IBlockAccess world, int posX, int posY, int posZ) {
        RPLEWorldRoot worldRoot = (RPLEWorldRoot)world;
        int redLightValue = worldRoot.rple$world(ColorChannel.RED_CHANNEL).lumi$getSkyLightValue(posX, posY, posZ);
        int greenLightValue = worldRoot.rple$world(ColorChannel.GREEN_CHANNEL).lumi$getSkyLightValue(posX, posY, posZ);
        int blueLightValue = worldRoot.rple$world(ColorChannel.BLUE_CHANNEL).lumi$getSkyLightValue(posX, posY, posZ);
        return ServerColorHelper.maxColorComponent(redLightValue, greenLightValue, blueLightValue);
    }
}

