/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.render;

import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.lib.util.RenderUtil;
import com.falsepattern.rple.api.common.color.ColorChannel;
import com.falsepattern.rple.internal.Compat;
import com.falsepattern.rple.internal.client.render.RPLEWorldUtil;
import java.awt.Color;
import lombok.Generated;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public final class LightValueOverlayRenderer {
    private static final float EPSILON = 0.004f;
    private static final int GRID_WIDTH = 3;
    private static final int GRID_HEIGHT = 3;
    private static final float VALUE_WIDTH = 0.33333334f;
    private static final float VALUE_HEIGHT = 0.33333334f;
    private static final Color RED_BLOCK_LIGHT_COLOR = new Color(0xBD0000);
    private static final Color GREEN_BLOCK_LIGHT_COLOR = new Color(1688576);
    private static final Color BLUE_BLOCK_LIGHT_COLOR = new Color(11728);
    private static final Color RED_SKY_LIGHT_COLOR = new Color(0xFF5353);
    private static final Color GREEN_SKY_LIGHT_COLOR = new Color(8257346);
    private static final Color BLUE_SKY_LIGHT_COLOR = new Color(65497);
    private static final Color MIXED_BLOCK_LIGHT_COLOR = new Color(14730299);
    private static final Color MIXED_SKY_LIGHT_COLOR = new Color(11337720);
    private static final Color MIXED_ALL_LIGHT_COLOR = new Color(14718207);
    private static final ResourceLocation LIGHT_VALUE_ATLAS_TEXTURE = new ResourceLocation("rple", "textures/overlays/light_value_atlas.png");
    private static final int HORIZONTAL_DRAW_RANGE = 30;
    private static final int VERTICAL_DRAW_RANGE = 20;

    public static void renderLightValueOverlay() {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityClientPlayerMP player = minecraft.field_71439_g;
        WorldClient worldBase = minecraft.field_71441_e;
        Tessellator tess = Compat.tessellator();
        int basePosX = MathUtil.clamp((int)((int)player.field_70165_t), (int)-30000000, (int)30000000);
        int basePosY = MathUtil.clamp((int)((int)player.field_70163_u), (int)0, (int)255);
        int basePosZ = MathUtil.clamp((int)((int)player.field_70161_v), (int)-30000000, (int)30000000);
        int minPosX = Math.max(basePosX - 30, -30000000);
        int minPosY = Math.max(basePosY - 20, 0);
        int minPosZ = Math.max(basePosZ - 30, -30000000);
        int maxPosX = Math.min(basePosX + 30, 30000000);
        int maxPosY = Math.min(basePosY + 20, 255);
        int maxPosZ = Math.min(basePosZ + 30, 30000000);
        LightValueOverlayRenderer.startDrawing(tess);
        for (int posY = minPosY; posY < maxPosY; ++posY) {
            for (int posZ = minPosZ; posZ < maxPosZ; ++posZ) {
                for (int posX = minPosX; posX < maxPosX; ++posX) {
                    LightValueOverlayRenderer.drawLightValueGridForPos(tess, (World)worldBase, posX, posY, posZ);
                }
            }
        }
        LightValueOverlayRenderer.finishDrawing(tess);
    }

    private static void startDrawing(Tessellator tess) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LIGHT_VALUE_ATLAS_TEXTURE);
        GL11.glDepthMask((boolean)false);
        RenderUtil.setGLTranslationRelativeToPlayer();
        tess.func_78371_b(7);
    }

    private static void finishDrawing(Tessellator tess) {
        tess.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private static void drawLightValueGridForPos(Tessellator tess, World world, int posX, int posY, int posZ) {
        Material blockMaterial = world.func_147439_a(posX, posY, posZ).func_149688_o();
        if (blockMaterial.func_76230_c()) {
            return;
        }
        Material bottomBlockMaterial = world.func_147439_a(posX, posY - 1, posZ).func_149688_o();
        if (!bottomBlockMaterial.func_76230_c()) {
            return;
        }
        LightValueOverlayRenderer.drawOutline(tess, posX, posY, posZ);
        int redBlockLight = RPLEWorldUtil.getChannelBlockLightValue((IBlockAccess)world, ColorChannel.RED_CHANNEL, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 0, 0, RED_BLOCK_LIGHT_COLOR, redBlockLight);
        int greenBlockLight = RPLEWorldUtil.getChannelBlockLightValue((IBlockAccess)world, ColorChannel.GREEN_CHANNEL, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 0, 1, GREEN_BLOCK_LIGHT_COLOR, greenBlockLight);
        int blueBlockLight = RPLEWorldUtil.getChannelBlockLightValue((IBlockAccess)world, ColorChannel.BLUE_CHANNEL, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 0, 2, BLUE_BLOCK_LIGHT_COLOR, blueBlockLight);
        int redSkyLight = RPLEWorldUtil.getChannelSkyLightValue((IBlockAccess)world, ColorChannel.RED_CHANNEL, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 1, 0, RED_SKY_LIGHT_COLOR, redSkyLight);
        int greenSkyLight = RPLEWorldUtil.getChannelSkyLightValue((IBlockAccess)world, ColorChannel.GREEN_CHANNEL, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 1, 1, GREEN_SKY_LIGHT_COLOR, greenSkyLight);
        int blueSkyLight = RPLEWorldUtil.getChannelSkyLightValue((IBlockAccess)world, ColorChannel.BLUE_CHANNEL, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 1, 2, BLUE_SKY_LIGHT_COLOR, blueSkyLight);
        int greyscaleBlockLight = RPLEWorldUtil.getGreyscaleBlockLightValue((IBlockAccess)world, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 2, 0, MIXED_BLOCK_LIGHT_COLOR, greyscaleBlockLight);
        int greyscaleSkyLight = RPLEWorldUtil.getGreyscaleSkyLightValue((IBlockAccess)world, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 2, 1, MIXED_SKY_LIGHT_COLOR, greyscaleSkyLight);
        int greyscaleLightValue = RPLEWorldUtil.getGreyscaleLightValue((IBlockAccess)world, posX, posY, posZ);
        LightValueOverlayRenderer.drawNumber(tess, posX, posY, posZ, 2, 2, MIXED_ALL_LIGHT_COLOR, greyscaleLightValue);
    }

    private static void drawOutline(Tessellator tess, float posX, float posY, float posZ) {
        float minPosX = posX;
        float minPosY = posY - 0.004f;
        float minPosZ = posZ;
        float maxPosX = minPosX + 1.0f;
        float maxPosY = posY + 0.004f;
        float maxPosZ = minPosZ + 1.0f;
        float minTextureU = AtlasIcon.OUTLINE_ICON.minTextureU();
        float minTextureV = AtlasIcon.OUTLINE_ICON.minTextureV();
        float maxTextureU = AtlasIcon.OUTLINE_ICON.maxTextureU();
        float maxTextureV = AtlasIcon.OUTLINE_ICON.maxTextureV();
        tess.func_78370_a(255, 255, 255, 255);
        tess.func_78374_a((double)minPosX, (double)maxPosY, (double)maxPosZ, (double)minTextureU, (double)maxTextureV);
        tess.func_78374_a((double)maxPosX, (double)maxPosY, (double)maxPosZ, (double)maxTextureU, (double)maxTextureV);
        tess.func_78374_a((double)maxPosX, (double)maxPosY, (double)minPosZ, (double)maxTextureU, (double)minTextureV);
        tess.func_78374_a((double)minPosX, (double)maxPosY, (double)minPosZ, (double)minTextureU, (double)minTextureV);
        tess.func_78374_a((double)minPosX, (double)minPosY, (double)minPosZ, (double)maxTextureU, (double)minTextureV);
        tess.func_78374_a((double)maxPosX, (double)minPosY, (double)minPosZ, (double)minTextureU, (double)minTextureV);
        tess.func_78374_a((double)maxPosX, (double)minPosY, (double)maxPosZ, (double)minTextureU, (double)maxTextureV);
        tess.func_78374_a((double)minPosX, (double)minPosY, (double)maxPosZ, (double)maxTextureU, (double)maxTextureV);
    }

    private static void drawNumber(Tessellator tess, float posX, float posY, float posZ, int gridX, int gridY, Color color, int value) {
        gridX = MathUtil.clamp((int)gridX, (int)0, (int)2);
        gridY = MathUtil.clamp((int)gridY, (int)0, (int)2);
        float posXOffset = (float)gridX * 0.33333334f;
        float posZOffset = (float)gridY * 0.33333334f;
        float minPosX = posX + posXOffset;
        float minPosY = posY - 0.004f;
        float minPosZ = posZ + posZOffset;
        float maxPosX = minPosX + 0.33333334f;
        float maxPosY = posY + 0.004f;
        float maxPosZ = minPosZ + 0.33333334f;
        AtlasIcon valueIcon = AtlasIcon.forValue(value);
        float minTextureU = valueIcon.minTextureU();
        float minTextureV = valueIcon.minTextureV();
        float maxTextureU = valueIcon.maxTextureU();
        float maxTextureV = valueIcon.maxTextureV();
        tess.func_78370_a(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        tess.func_78374_a((double)minPosX, (double)maxPosY, (double)maxPosZ, (double)minTextureU, (double)maxTextureV);
        tess.func_78374_a((double)maxPosX, (double)maxPosY, (double)maxPosZ, (double)maxTextureU, (double)maxTextureV);
        tess.func_78374_a((double)maxPosX, (double)maxPosY, (double)minPosZ, (double)maxTextureU, (double)minTextureV);
        tess.func_78374_a((double)minPosX, (double)maxPosY, (double)minPosZ, (double)minTextureU, (double)minTextureV);
        tess.func_78374_a((double)minPosX, (double)minPosY, (double)minPosZ, (double)maxTextureU, (double)minTextureV);
        tess.func_78374_a((double)maxPosX, (double)minPosY, (double)minPosZ, (double)minTextureU, (double)minTextureV);
        tess.func_78374_a((double)maxPosX, (double)minPosY, (double)maxPosZ, (double)minTextureU, (double)maxTextureV);
        tess.func_78374_a((double)minPosX, (double)minPosY, (double)maxPosZ, (double)maxTextureU, (double)maxTextureV);
    }

    private static enum AtlasIcon {
        VALUE_0_ICON(0, 0),
        VALUE_1_ICON(1, 0),
        VALUE_2_ICON(2, 0),
        VALUE_3_ICON(3, 0),
        VALUE_4_ICON(0, 1),
        VALUE_5_ICON(1, 1),
        VALUE_6_ICON(2, 1),
        VALUE_7_ICON(3, 1),
        VALUE_8_ICON(0, 2),
        VALUE_9_ICON(1, 2),
        VALUE_10_ICON(2, 2),
        VALUE_11_ICON(3, 2),
        VALUE_12_ICON(0, 3),
        VALUE_13_ICON(1, 3),
        VALUE_14_ICON(2, 3),
        VALUE_15_ICON(3, 3),
        OUTLINE_ICON(4, 0);

        private static final int ATLAS_WIDTH = 5;
        private static final int ATLAS_HEIGHT = 4;
        private static final float ICON_WIDTH = 0.2f;
        private static final float ICON_HEIGHT = 0.25f;
        private static final int MIN_VALUE = 0;
        private static final int MAX_VALUE = 15;
        private final float minTextureU;
        private final float minTextureV;
        private final float maxTextureU;
        private final float maxTextureV;

        private AtlasIcon(int posX, int posY) {
            this.minTextureU = (float)posX * 0.2f;
            this.minTextureV = (float)posY * 0.25f;
            this.maxTextureU = this.minTextureU + 0.2f;
            this.maxTextureV = this.minTextureV + 0.25f;
        }

        public static AtlasIcon forValue(int value) {
            value = MathUtil.clamp((int)value, (int)0, (int)15);
            return AtlasIcon.values()[value];
        }

        @Generated
        public float minTextureU() {
            return this.minTextureU;
        }

        @Generated
        public float minTextureV() {
            return this.minTextureV;
        }

        @Generated
        public float maxTextureU() {
            return this.maxTextureU;
        }

        @Generated
        public float maxTextureV() {
            return this.maxTextureV;
        }
    }
}

