/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.rple.internal.client.lightmap;

import com.falsepattern.lib.util.MathUtil;
import com.falsepattern.rple.api.client.lightmap.RPLEBlockLightMapBase;
import com.falsepattern.rple.api.client.lightmap.RPLEBlockLightMapMask;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapBase;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapGenerator;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapMask;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapProvider;
import com.falsepattern.rple.api.client.lightmap.RPLELightMapRegistry;
import com.falsepattern.rple.api.client.lightmap.RPLESkyLightMapBase;
import com.falsepattern.rple.api.client.lightmap.RPLESkyLightMapMask;
import com.falsepattern.rple.internal.RPLEDefaultValues;
import com.falsepattern.rple.internal.client.lightmap.LightMapStrip;
import com.falsepattern.rple.internal.common.collection.PriorityPair;
import com.falsepattern.rple.internal.common.event.EventPoster;
import com.falsepattern.rple.internal.common.util.LogHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class LightMapPipeline
implements RPLELightMapRegistry {
    private static final Logger LOG = LogHelper.createLogger("LightMapPipeline");
    private static final LightMapPipeline INSTANCE = new LightMapPipeline();
    private final Set<RPLELightMapProvider> lightMapProviders = Collections.newSetFromMap(new IdentityHashMap());
    private final List<PriorityPair<RPLEBlockLightMapBase>> blockBases = new ArrayList<PriorityPair<RPLEBlockLightMapBase>>();
    private final List<PriorityPair<RPLESkyLightMapBase>> skyBases = new ArrayList<PriorityPair<RPLESkyLightMapBase>>();
    private final List<PriorityPair<RPLEBlockLightMapMask>> blockMasks = new ArrayList<PriorityPair<RPLEBlockLightMapMask>>();
    private final List<PriorityPair<RPLESkyLightMapMask>> skyMasks = new ArrayList<PriorityPair<RPLESkyLightMapMask>>();
    private final LightMapStrip blockLightMapStrip = new LightMapStrip();
    private final LightMapStrip skyLightMapStrip = new LightMapStrip();
    private final LightMapStrip tempLightMapStrip = new LightMapStrip();
    private final int[] mixedLightMapData = new int[256];
    private boolean registryLocked = false;

    public static LightMapPipeline lightMapPipeline() {
        return INSTANCE;
    }

    public void registerLightMapProviders() {
        if (this.registryLocked) {
            return;
        }
        RPLEDefaultValues.registerDefaultLightMaps(this);
        EventPoster.postLightMapRegistrationEvent(this);
        this.registryLocked = true;
        int totalLightMapProviders = this.lightMapProviders.size();
        if (totalLightMapProviders == 0) {
            LOG.error("No light map providers registered, this will result in the world being full bright");
        }
        if (totalLightMapProviders == 1) {
            LOG.info("Registered 1 light map provider");
        } else {
            LOG.info("Registered {} light map providers", new Object[]{totalLightMapProviders});
        }
        this.blockBases.sort(Comparator.naturalOrder());
        this.skyBases.sort(Comparator.naturalOrder());
        this.blockMasks.sort(Comparator.naturalOrder());
        this.skyMasks.sort(Comparator.naturalOrder());
    }

    @Override
    @Deprecated
    public void registerLightMapGenerator(@NotNull RPLELightMapGenerator generator, int priority) {
        if (!this.registerLightMapProvider(generator)) {
            return;
        }
        this.blockBases.add(PriorityPair.wrappedWithPriority(generator, priority));
        this.skyBases.add(PriorityPair.wrappedWithPriority(generator, priority));
        this.blockMasks.add(PriorityPair.wrappedWithPriority(generator, priority));
        this.skyMasks.add(PriorityPair.wrappedWithPriority(generator, priority));
    }

    @Override
    public void registerLightMapBase(@NotNull RPLELightMapBase base, int priority) {
        if (!this.registerLightMapProvider(base)) {
            return;
        }
        this.blockBases.add(PriorityPair.wrappedWithPriority(base, priority));
        this.skyBases.add(PriorityPair.wrappedWithPriority(base, priority));
    }

    @Override
    public void registerBlockLightMapBase(@NotNull RPLEBlockLightMapBase blockBase, int priority) {
        if (!this.registerLightMapProvider(blockBase)) {
            return;
        }
        this.blockBases.add(PriorityPair.wrappedWithPriority(blockBase, priority));
    }

    @Override
    public void registerSkyLightMapBase(@NotNull RPLESkyLightMapBase skyBase, int priority) {
        if (!this.registerLightMapProvider(skyBase)) {
            return;
        }
        this.skyBases.add(PriorityPair.wrappedWithPriority(skyBase, priority));
    }

    @Override
    public void registerLightMapMask(@NotNull RPLELightMapMask mask, int sortOrder) {
        if (!this.registerLightMapProvider(mask)) {
            return;
        }
        this.blockMasks.add(PriorityPair.wrappedWithPriority(mask, sortOrder));
        this.skyMasks.add(PriorityPair.wrappedWithPriority(mask, sortOrder));
    }

    @Override
    public void registerBlockLightMapMask(@NotNull RPLEBlockLightMapMask blockMask, int sortOrder) {
        if (!this.registerLightMapProvider(blockMask)) {
            return;
        }
        this.blockMasks.add(PriorityPair.wrappedWithPriority(blockMask, sortOrder));
    }

    @Override
    public void registerSkyLightMapMask(@NotNull RPLESkyLightMapMask skyMask, int sortOrder) {
        if (!this.registerLightMapProvider(skyMask)) {
            return;
        }
        this.skyMasks.add(PriorityPair.wrappedWithPriority(skyMask, sortOrder));
    }

    private boolean registerLightMapProvider(RPLELightMapProvider provider) {
        if (this.registryLocked) {
            LOG.error("Failed to register light map provider after post init", new Throwable());
            return false;
        }
        if (provider == null) {
            LOG.error("Light map provider can't be null", new Throwable());
            return false;
        }
        if (this.lightMapProviders.contains(provider)) {
            LOG.error("Tried to register light map provider twice", new Throwable());
            return false;
        }
        this.lightMapProviders.add(provider);
        return true;
    }

    public int[] update(float partialTick) {
        RPLELightMapProvider m;
        for (PriorityPair<RPLEBlockLightMapBase> priorityPair : this.blockBases) {
            this.blockLightMapStrip.resetLightMap();
            if (!priorityPair.value().generateBlockLightMapBase(this.blockLightMapStrip, partialTick)) continue;
            break;
        }
        for (PriorityPair<RPLELightMapProvider> priorityPair : this.skyBases) {
            this.skyLightMapStrip.resetLightMap();
            if (!((RPLESkyLightMapBase)priorityPair.value()).generateSkyLightMapBase(this.skyLightMapStrip, partialTick)) continue;
            break;
        }
        for (PriorityPair<RPLELightMapProvider> priorityPair : this.blockMasks) {
            this.tempLightMapStrip.resetLightMap();
            m = (RPLEBlockLightMapMask)priorityPair.value();
            if (m.generateBlockLightMapMask(this.tempLightMapStrip, partialTick)) {
                this.blockLightMapStrip.mulLightMap(this.tempLightMapStrip);
                continue;
            }
            m.mutateBlockLightMap(this.blockLightMapStrip, partialTick);
        }
        for (PriorityPair<RPLELightMapProvider> priorityPair : this.skyMasks) {
            this.tempLightMapStrip.resetLightMap();
            m = (RPLESkyLightMapMask)priorityPair.value();
            if (m.generateSkyLightMapMask(this.tempLightMapStrip, partialTick)) {
                this.skyLightMapStrip.mulLightMap(this.tempLightMapStrip);
                continue;
            }
            m.mutateSkyLightMap(this.skyLightMapStrip, partialTick);
        }
        this.mixLightMaps();
        return this.mixedLightMapData;
    }

    public int[] mixedLightMapData() {
        return this.mixedLightMapData;
    }

    private void mixLightMaps() {
        float[] blockLightMapRed = this.blockLightMapStrip.lightMapRedData();
        float[] blockLightMapGreen = this.blockLightMapStrip.lightMapGreenData();
        float[] blockLightMapBlue = this.blockLightMapStrip.lightMapBlueData();
        float[] skyLightMapRed = this.skyLightMapStrip.lightMapRedData();
        float[] skyLightMapGreen = this.skyLightMapStrip.lightMapGreenData();
        float[] skyLightMapBlue = this.skyLightMapStrip.lightMapBlueData();
        float gamma = Minecraft.func_71410_x().field_71474_y.field_74333_Y;
        for (int index = 0; index < 256; ++index) {
            int blockIndex = index % 16;
            int skyIndex = index / 16;
            float bR = MathUtil.clamp((float)blockLightMapRed[blockIndex], (float)0.0f, (float)1.0f);
            float bG = MathUtil.clamp((float)blockLightMapGreen[blockIndex], (float)0.0f, (float)1.0f);
            float bB = MathUtil.clamp((float)blockLightMapBlue[blockIndex], (float)0.0f, (float)1.0f);
            float sR = MathUtil.clamp((float)skyLightMapRed[skyIndex], (float)0.0f, (float)1.0f);
            float sG = MathUtil.clamp((float)skyLightMapGreen[skyIndex], (float)0.0f, (float)1.0f);
            float sB = MathUtil.clamp((float)skyLightMapBlue[skyIndex], (float)0.0f, (float)1.0f);
            float r = MathUtil.clamp((float)(bR + sR), (float)0.0f, (float)1.0f);
            float g = MathUtil.clamp((float)(bG + sG), (float)0.0f, (float)1.0f);
            float b = MathUtil.clamp((float)(bB + sB), (float)0.0f, (float)1.0f);
            this.mixedLightMapData[index] = LightMapPipeline.colorToInt(r, g, b);
        }
    }

    private static float clamp(float value) {
        return Math.max(Math.min(value, 1.0f), 0.0f);
    }

    private static int colorToInt(float red, float green, float blue) {
        int redByte = LightMapPipeline.colorToByte(red) << 16;
        int greenByte = LightMapPipeline.colorToByte(green) << 8;
        int blueByte = LightMapPipeline.colorToByte(blue);
        return 0xFF000000 | redByte | greenByte | blueByte;
    }

    private static int colorToByte(float color) {
        return Math.round(color * 255.0f) & 0xFF;
    }

    @Generated
    private LightMapPipeline() {
    }
}

