/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.plugins.tcon.smeltery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.plugins.gears.TinkerGears;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.weaponry.TinkerWeaponry;
import us.drullk.thermalsmeltery.common.plugins.tcon.smeltery.StampingRecipe;

public class MachineRecipeRegistry {
    private static List<StampingRecipe> recipes = new ArrayList<StampingRecipe>();
    private static List<ItemStack> validIngots = new ArrayList<ItemStack>();
    private static Set<Integer> incompatibleCasts = new HashSet<Integer>(Arrays.asList(0, 23, 24, 26, 27));
    private static Map<Fluid, CastingRecipe> ingotRecipes = new HashMap<Fluid, CastingRecipe>();
    private static Map<Fluid, CastingRecipe> blockRecipes = new HashMap<Fluid, CastingRecipe>();

    public static void registerStampingRecipe(LiquidCasting tableCasting, CastingRecipe recipe) {
        if (MachineRecipeRegistry.isValidCast(recipe.cast)) {
            StampingRecipe stampingRecipe = new StampingRecipe(tableCasting, recipe);
            if (stampingRecipe.metal != null) {
                recipes.add(stampingRecipe);
                if (!MachineRecipeRegistry.isValidMetal(stampingRecipe.metal)) {
                    validIngots.add(stampingRecipe.metal);
                }
            }
        }
    }

    public static void registerIngotRecipe(CastingRecipe recipe) {
        if (recipe.cast != null && recipe.cast.func_77969_a(new ItemStack(TinkerSmeltery.metalPattern, 1, 0))) {
            ingotRecipes.put(recipe.castingMetal.getFluid(), recipe);
        }
    }

    public static void registerBlockRecipe(CastingRecipe recipe) {
        if (recipe.cast == null) {
            blockRecipes.put(recipe.castingMetal.getFluid(), recipe);
        }
    }

    public static CastingRecipe getExtruderRecipe(Fluid fluid, boolean block) {
        return block ? blockRecipes.get(fluid) : ingotRecipes.get(fluid);
    }

    public static boolean isValidFluid(Fluid fluid) {
        return blockRecipes.containsKey(fluid) || ingotRecipes.containsKey(fluid);
    }

    public static StampingRecipe getStampingRecipe(ItemStack ingot, ItemStack cast) {
        for (StampingRecipe recipe : recipes) {
            if (!recipe.matches(ingot, cast)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean isValidCast(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == TinkerSmeltery.metalPattern && !incompatibleCasts.contains(stack.func_77960_j())) {
            return true;
        }
        if (stack.func_77973_b() == TinkerWeaponry.metalPattern && stack.func_77960_j() != 3) {
            return true;
        }
        return stack.func_77973_b() == TinkerGears.gearCast;
    }

    public static boolean isValidMetal(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        for (ItemStack ingot : validIngots) {
            if (!MachineRecipeRegistry.isOreDictMatch(stack, ingot)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOreDictMatch(ItemStack metal, ItemStack metal1) {
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)metal);
        int[] ids2 = OreDictionary.getOreIDs((ItemStack)metal1);
        for (int id1 : ids1) {
            for (int id2 : ids2) {
                if (id1 != id2) continue;
                return true;
            }
        }
        return false;
    }
}

