/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.gui.client;

import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementDualScaled;
import cofh.lib.gui.element.ElementEnergyStored;
import cofh.lib.gui.element.ElementFluid;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import us.drullk.thermalsmeltery.common.blocks.TileExtruder;
import us.drullk.thermalsmeltery.common.gui.client.GuiMachineBase;
import us.drullk.thermalsmeltery.common.gui.container.ContainerExtruder;
import us.drullk.thermalsmeltery.common.gui.elements.ElementSlotBorder;
import us.drullk.thermalsmeltery.common.gui.elements.ElementTinkersTank;

public class GuiExtruder
extends GuiMachineBase {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalsmeltery:textures/gui/castingExtruderGui.v6.png");
    ElementSlotBorder[] tankOverlay = new ElementSlotBorder[2];
    ElementSlotBorder outputOverlay;
    ElementButton block;
    ElementFluid progressFluid;
    ElementDualScaled progressOverlay;
    TileExtruder extruder;

    public GuiExtruder(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super(new ContainerExtruder(inventoryPlayer, tileEntity), tileEntity, inventoryPlayer.field_70458_d, TEXTURE);
        this.generateInfo("tab.thermalsmeltery.machine.extruder", 3);
        this.extruder = (TileExtruder)tileEntity;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElement((ElementBase)new ElementEnergyStored((GuiBase)this, 8, 8, this.extruder.getEnergyStorage()));
        this.tankOverlay[0] = (ElementSlotBorder)this.addElement(new ElementSlotBorder((GuiBase)this, 34, 9).setSlotInfo(0, 3, 2).setVisible(false));
        this.tankOverlay[1] = (ElementSlotBorder)this.addElement(new ElementSlotBorder((GuiBase)this, 34, 9).setSlotInfo(2, 3, 1).setVisible(false));
        this.addElement((ElementBase)new ElementTinkersTank((GuiBase)this, 34, 9, (IFluidTank)this.extruder.getTank()).setGauge(1));
        this.outputOverlay = (ElementSlotBorder)this.addElement(new ElementSlotBorder((GuiBase)this, 122, 26).setSlotInfo(1, 1, 2).setVisible(true));
        this.block = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiBase)this, 124, 54, "Block", 184, 0, 184, 20, 184, 40, 20, 20, "thermalsmeltery:textures/gui/castingExtruderGui.v5.png"));
        this.progressFluid = (ElementFluid)this.addElement(new ElementFluid((GuiBase)this, 75, 29).setFluid(this.extruder.getTank().getFluid()).setSize(24, 17));
        this.progressOverlay = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiBase)this, 75, 29).setMode(1).setBackground(false).setSize(24, 16).setTexture("thermalsmeltery:textures/gui/elementProgressFluidArrow.png", 48, 16));
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        this.tankOverlay[0].setVisible(this.extruder.hasSide(1));
        this.tankOverlay[1].setVisible(this.extruder.hasSide(3));
        this.outputOverlay.setVisible(this.extruder.hasSide(2));
        this.tankOverlay[1].slotRender = !this.extruder.hasSide(1) ? 2 : 1;
        if (this.extruder.block) {
            if (!this.extruder.blockFlag) {
                this.block.setToolTip("info.thermalsmeltery.toggleIngotWait");
                this.block.setDisabled();
            } else {
                this.block.setToolTip("info.thermalsmeltery.toggleIngot");
                this.block.setSheetX(184);
                this.block.setHoverX(184);
                this.block.setActive();
            }
        } else if (this.extruder.blockFlag) {
            this.block.setToolTip("info.thermalsmeltery.toggleBlockWait");
            this.block.setDisabled();
        } else {
            this.block.setToolTip("info.thermalsmeltery.toggleBlock");
            this.block.setSheetX(204);
            this.block.setHoverX(204);
            this.block.setActive();
        }
        this.progressFluid.setFluid(this.extruder.getTank().getFluid());
        this.progressFluid.setSize(this.extruder.getScaledProgress(24), 16);
        this.progressOverlay.setQuantity(this.extruder.getScaledProgress(24));
    }

    public void handleElementButtonClick(String var1, int var2) {
        if (var1.equals("Block") && this.extruder.block == this.extruder.blockFlag) {
            if (this.extruder.block) {
                GuiExtruder.playSound((String)"random.click", (float)1.0f, (float)0.8f);
            } else {
                GuiExtruder.playSound((String)"random.click", (float)1.0f, (float)0.6f);
            }
            this.extruder.setMode(!this.extruder.block);
        }
    }
}

