/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.blocks;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.energy.IEnergyStorage;
import cofh.api.item.IAugmentItem;
import cofh.api.tileentity.IAugmentable;
import cofh.api.tileentity.IEnergyInfo;
import cofh.api.tileentity.IPortableData;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IReconfigurableSides;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.api.tileentity.ISidedTexture;
import cofh.asm.relauncher.CoFHSide;
import cofh.asm.relauncher.Strippable;
import cofh.core.CoFHProps;
import cofh.core.block.TileCoFHBase;
import cofh.core.network.ITileInfoPacketHandler;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.render.IconRegistry;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.audio.ISoundSource;
import cofh.lib.audio.SoundTile;
import cofh.lib.util.TimeTracker;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.SoundHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import us.drullk.thermalsmeltery.ThermalSmeltery;
import us.drullk.thermalsmeltery.common.blocks.BlockMachine;
import us.drullk.thermalsmeltery.common.blocks.MachineHelper;
import us.drullk.thermalsmeltery.common.network.PacketThermalSmeltery;

@Strippable(value={"cofh.api.audio.ISoundSource"}, side=CoFHSide.SERVER)
public abstract class TileMachineBase
extends TileCoFHBase
implements ITileInfoPacketHandler,
ITilePacketHandler,
IPortableData,
ISidedInventory,
ISecurable,
IRedstoneControl,
ISoundSource,
IEnergyReceiver,
IReconfigurableFacing,
IReconfigurableSides,
ISidedTexture,
IAugmentable,
IEnergyInfo {
    protected static final int[] AUGMENT_COUNT = new int[]{3, 4, 5, 6};
    protected static final int[] ENERGY_CAPACITY = new int[]{2, 3, 4, 5};
    protected static final int[] ENERGY_TRANSFER = new int[]{3, 6, 12, 24};
    public static final SideConfig[] defaultSideConfigSmeltery = new SideConfig[2];
    public static final EnergyConfig[] defaultEnergyConfigSmeltery = new EnergyConfig[2];
    public static final String[] soundsSmeltery = new String[2];
    protected static final boolean[] enableSoundSmeltery = new boolean[]{false, false};
    protected static final int[] lightValueSmeltery = new int[]{7, 7};
    public static boolean[] enableSecurity = new boolean[]{true, true};
    int outputTracker;
    protected String tileName = "";
    protected GameProfile owner;
    protected ISecurable.AccessMode access;
    protected boolean canAccess;
    public ItemStack[] inventory;
    public boolean isActive;
    protected boolean isPowered;
    protected boolean wasPowered;
    protected IRedstoneControl.ControlMode rsMode;
    protected EnergyStorage energyStorage = new EnergyStorage(0);
    protected byte facing = (byte)3;
    public byte[] sideCache = new byte[]{0, 0, 0, 0, 0, 0};
    protected SideConfig sideConfig;
    protected boolean[] augmentStatus = new boolean[3];
    protected ItemStack[] augments = new ItemStack[3];
    public boolean augmentAutoTransfer;
    public boolean augmentReconfigSides;
    public boolean augmentRedstoneControl;
    int processMax;
    int processRem;
    boolean wasActive;
    protected EnergyConfig energyConfig;
    protected TimeTracker tracker = new TimeTracker();
    byte level = 0;
    int processMod = 1;
    int energyMod = 1;
    int secondaryChance = 100;

    public TileMachineBase() {
        this.owner = CoFHProps.DEFAULT_OWNER;
        this.sideConfig = this.getDefaultSideConfig();
        this.energyConfig = this.getDefaultEnergyConfig().copy();
        this.setDefaultSides();
        this.rsMode = IRedstoneControl.ControlMode.DISABLED;
        this.access = ISecurable.AccessMode.PUBLIC;
        this.canAccess = true;
        this.inventory = new ItemStack[this.getInventorySize()];
    }

    public boolean openGui(EntityPlayer player) {
        if (this.canPlayerAccess(player)) {
            player.openGui((Object)ThermalSmeltery.instance, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (ServerHelper.isServerWorld((World)this.field_145850_b)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StringHelper.localize((String)"chat.cofh.secure1") + " " + this.owner + "! " + StringHelper.localize((String)"chat.cofh.secure2")));
        }
        return true;
    }

    protected int getInventorySize() {
        return 0;
    }

    protected SideConfig getDefaultSideConfig() {
        return defaultSideConfigSmeltery[this.getType()];
    }

    protected EnergyConfig getDefaultEnergyConfig() {
        return defaultEnergyConfigSmeltery[this.getType()];
    }

    protected void transferProducts() {
        if (this.augmentAutoTransfer) {
            block0: for (int slot = this.getMaxInputSlot() + 1; slot < this.inventory.length - 1; ++slot) {
                if (this.inventory[slot] == null) continue;
                for (int side = this.outputTracker + 1; side <= this.outputTracker + 6; ++side) {
                    int pushSide = side % 6;
                    if (!this.isOutputForSlot(pushSide, slot) || !this.transferItem(slot, 4, pushSide)) continue;
                    this.outputTracker = pushSide;
                    break block0;
                }
            }
        }
    }

    public boolean isOutputForSlot(int side, int slot) {
        if (!this.isOutput(side)) {
            return false;
        }
        for (int i : this.sideConfig.slotGroups[this.sideCache[side]]) {
            if (i != slot) continue;
            return true;
        }
        return false;
    }

    public boolean isOutput(int side) {
        return this.sideConfig.allowExtraction[this.sideCache[side]];
    }

    public void readAugmentsFromNBT(NBTTagCompound tag) {
        this.level = tag.func_74771_c("Level");
        this.energyConfig.setParams(this.energyConfig.minPower, this.energyConfig.maxPower, this.energyConfig.maxEnergy * ENERGY_CAPACITY[this.level] / 2);
        this.energyStorage.setCapacity(this.energyConfig.maxEnergy);
        this.energyStorage.setMaxTransfer(this.energyConfig.maxPower * ENERGY_TRANSFER[this.level]);
        this.augments = new ItemStack[AUGMENT_COUNT[this.level]];
        this.augmentStatus = new boolean[this.augments.length];
        this.readInventoryFromNBT(tag, this.augments, "Augments");
    }

    public void readInventoryFromNBT(NBTTagCompound tag, ItemStack[] inventory, String tagName) {
        NBTTagList tagList = tag.func_150295_c(tagName, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound slotTag = tagList.func_150305_b(i);
            int slot = slotTag.func_74762_e("Slot");
            if (slot < 0 || slot >= inventory.length) continue;
            inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)slotTag);
        }
    }

    public void writeAugmentsToNBT(NBTTagCompound tag) {
        tag.func_74774_a("Level", this.level);
        this.writeInventoryToNBT(tag, this.augments, "Augments");
    }

    public void writeInventoryToNBT(NBTTagCompound tag, ItemStack[] inventory, String tagName) {
        if (inventory.length > 0) {
            NBTTagList tagList = new NBTTagList();
            for (int slot = 0; slot < inventory.length; ++slot) {
                if (inventory[slot] == null) continue;
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74768_a("Slot", slot);
                inventory[slot].func_77955_b(slotTag);
                tagList.func_74742_a((NBTBase)slotTag);
            }
            tag.func_74782_a(tagName, (NBTBase)tagList);
        }
    }

    protected abstract boolean hasRoomForOutput();

    protected boolean canFit(ItemStack stack, int slot) {
        return stack == null || this.inventory[slot] == null || stack.func_77969_a(this.inventory[slot]) && stack.field_77994_a + this.inventory[slot].field_77994_a <= stack.func_77976_d();
    }

    public void func_145845_h() {
        if (!ServerHelper.isClientWorld((World)this.field_145850_b)) {
            boolean var1 = this.isActive;
            if (this.isActive) {
                if (this.processRem > 0) {
                    int var2 = this.calcEnergy();
                    this.energyStorage.modifyEnergyStored(-var2 * this.energyMod);
                    this.processRem -= var2 * this.processMod;
                }
                if (this.canFinish()) {
                    this.processFinish();
                    this.transferProducts();
                    this.energyStorage.modifyEnergyStored(-this.processRem * this.energyMod / this.processMod);
                    if (this.redstoneControlOrDisable() && this.canStart()) {
                        this.processStart();
                    } else {
                        this.isActive = false;
                        this.wasActive = true;
                        this.tracker.markTime(this.field_145850_b);
                    }
                }
            } else if (this.redstoneControlOrDisable()) {
                if (this.timeCheck()) {
                    this.transferProducts();
                }
                if (this.timeCheckEighth() && this.canStart()) {
                    this.processStart();
                    int var2 = this.calcEnergy();
                    this.energyStorage.modifyEnergyStored(-var2 * this.energyMod);
                    this.processRem -= var2 * this.processMod;
                    this.isActive = true;
                }
            }
            this.updateIfChanged(var1);
            this.chargeEnergy();
        }
    }

    protected int calcEnergy() {
        return !this.isActive ? 0 : (this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel ? this.energyConfig.maxPower : (this.energyStorage.getEnergyStored() < this.energyConfig.minPowerLevel ? this.energyConfig.minPower : this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp));
    }

    protected int getMaxInputSlot() {
        return 0;
    }

    protected boolean canStart() {
        return this.hasValidInput() && this.hasRoomForOutput();
    }

    protected boolean canFinish() {
        return this.processRem <= 0 && this.hasValidInput();
    }

    protected boolean hasValidInput() {
        return true;
    }

    protected void processStart() {
    }

    protected void processFinish() {
    }

    protected void updateIfChanged(boolean var1) {
        if (var1 != this.isActive && this.isActive) {
            this.sendUpdatePacket(Side.CLIENT);
        } else if (this.tracker.hasDelayPassed(this.field_145850_b, 200) && this.wasActive) {
            this.wasActive = false;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public int getScaledProgress(int var1) {
        return this.isActive && this.processMax > 0 && this.processRem > 0 ? var1 * (this.processMax - this.processRem) / this.processMax : 0;
    }

    public int getScaledSpeed(int var1) {
        if (!this.isActive) {
            return 0;
        }
        double var2 = this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp;
        var2 = MathHelper.clip((double)var2, (double)this.energyConfig.minPower, (double)this.energyConfig.maxPower);
        return MathHelper.round((double)((double)var1 * var2 / (double)this.energyConfig.maxPower));
    }

    public String getName() {
        return "tile.thermalsmeltery.machine." + BlockMachine.NAMES[this.getType()] + ".name";
    }

    private String getFaceString(int face) {
        switch (face) {
            case 0: {
                return "bottom";
            }
            case 1: {
                return "top";
            }
        }
        return "side";
    }

    public boolean enableSecurity() {
        return enableSecurity[this.getType()];
    }

    public int getLightValue() {
        return this.isActive ? lightValueSmeltery[this.getType()] : 0;
    }

    public boolean setInvName(String var1) {
        if (var1.isEmpty()) {
            return false;
        }
        this.tileName = var1;
        return true;
    }

    public int getInvSlotCount() {
        return this.inventory.length;
    }

    public void sendGuiNetworkData(Container container, ICrafting player) {
        if (player instanceof EntityPlayer) {
            PacketCoFHBase packet = this.getGuiPacket();
            if (packet != null) {
                PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)((EntityPlayer)player));
            }
            player.func_71112_a(container, 0, this.canPlayerAccess((EntityPlayer)player) ? 1 : 0);
        }
    }

    public PacketCoFHBase getGuiPacket() {
        PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this);
        packet.addByte(1);
        packet.addBool(this.isActive);
        packet.addInt(this.energyStorage.getMaxEnergyStored());
        packet.addInt(this.energyStorage.getEnergyStored());
        packet.addBool(this.augmentReconfigSides);
        packet.addBool(this.augmentRedstoneControl);
        packet.addInt(this.processMax);
        packet.addInt(this.processRem);
        packet.addInt(this.processMod);
        packet.addInt(this.energyMod);
        return packet;
    }

    public PacketCoFHBase getFluidPacket() {
        PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this);
        packet.addByte(2);
        return packet;
    }

    public PacketCoFHBase getModePacket() {
        PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this);
        packet.addByte(3);
        return packet;
    }

    protected void handleGuiPacket(PacketCoFHBase packet) {
        this.isActive = packet.getBool();
        this.energyStorage.setCapacity(packet.getInt());
        this.energyStorage.setEnergyStored(packet.getInt());
        boolean augSides = this.augmentReconfigSides;
        boolean augRS = this.augmentRedstoneControl;
        this.augmentReconfigSides = packet.getBool();
        this.augmentRedstoneControl = packet.getBool();
        if (this.augmentReconfigSides != augSides || this.augmentRedstoneControl != augRS) {
            this.onInstalled();
            this.sendUpdatePacket(Side.SERVER);
        }
        this.processMax = packet.getInt();
        this.processRem = packet.getInt();
        this.processMod = packet.getInt();
        this.energyMod = packet.getInt();
    }

    protected void handleFluidPacket(PacketCoFHBase packet) {
    }

    protected void handleModePacket(PacketCoFHBase packet) {
    }

    public void sendFluidPacket() {
        PacketHandler.sendToDimension((PacketBase)this.getFluidPacket(), (int)this.field_145850_b.field_73011_w.field_76574_g);
    }

    public void sendModePacket() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            PacketHandler.sendToServer((PacketBase)this.getModePacket());
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("Name")) {
            this.tileName = tag.func_74779_i("Name");
        }
        this.access = ISecurable.AccessMode.values()[tag.func_74771_c("Access")];
        String uuid = tag.func_74779_i("OwnerUUID");
        String owner = tag.func_74779_i("Owner");
        if (!Strings.isNullOrEmpty((String)uuid)) {
            this.setOwner(new GameProfile(UUID.fromString(uuid), owner));
        } else {
            this.setOwnerName(owner);
        }
        if (!this.enableSecurity()) {
            this.access = ISecurable.AccessMode.PUBLIC;
        }
        this.readInventoryFromNBT(tag, this.inventory, "Inventory");
        this.outputTracker = tag.func_74762_e("Tracker");
        this.isActive = tag.func_74767_n("Active");
        NBTTagCompound rsTag = tag.func_74775_l("RS");
        this.isPowered = rsTag.func_74767_n("Power");
        this.rsMode = IRedstoneControl.ControlMode.values()[rsTag.func_74771_c("Mode")];
        this.readAugmentsFromNBT(tag);
        this.installAugments();
        this.energyStorage.readFromNBT(tag);
        this.facing = MachineHelper.getFacingFromNBT(tag);
        this.sideCache = MachineHelper.getSideCacheFromNBT(tag, this.getDefaultSides());
        for (int side = 0; side < 6; ++side) {
            if (this.sideCache[side] < this.getNumConfig(side)) continue;
            this.sideCache[side] = 0;
        }
        this.processMax = tag.func_74762_e("ProcMax");
        this.processRem = tag.func_74762_e("ProcRem");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (!this.tileName.isEmpty()) {
            tag.func_74778_a("Name", this.tileName);
        }
        tag.func_74774_a("Access", (byte)this.access.ordinal());
        tag.func_74778_a("OwnerUUID", this.owner.getId().toString());
        tag.func_74778_a("Owner", this.owner.getName());
        this.writeInventoryToNBT(tag, this.inventory, "Inventory");
        tag.func_74768_a("Tracker", this.outputTracker);
        tag.func_74757_a("Active", this.isActive);
        NBTTagCompound rsTag = new NBTTagCompound();
        rsTag.func_74757_a("Power", this.isPowered);
        rsTag.func_74774_a("Mode", (byte)this.rsMode.ordinal());
        tag.func_74782_a("RS", (NBTBase)rsTag);
        this.energyStorage.writeToNBT(tag);
        tag.func_74774_a("Facing", this.facing);
        tag.func_74773_a("SideCache", this.sideCache);
        this.writeAugmentsToNBT(tag);
        tag.func_74768_a("ProcMax", this.processMax);
        tag.func_74768_a("ProcRem", this.processRem);
    }

    public PacketCoFHBase getPacket() {
        PacketCoFHBase packet = super.getPacket();
        packet.addString(this.tileName);
        packet.addByte((byte)this.access.ordinal());
        packet.addUUID(this.owner.getId());
        packet.addString(this.owner.getName());
        packet.addBool(this.isPowered);
        packet.addByte(this.rsMode.ordinal());
        packet.addBool(this.isActive);
        packet.addInt(this.energyStorage.getEnergyStored());
        packet.addByteArray(this.sideCache);
        packet.addByte(this.facing);
        packet.addBool(this.augmentReconfigSides);
        packet.addBool(this.augmentRedstoneControl);
        packet.addByte(this.level);
        return packet;
    }

    public void handleTilePacket(PacketCoFHBase packet, boolean isServer) {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            this.tileName = packet.getString();
        } else {
            packet.getString();
        }
        this.access = ISecurable.AccessMode.values()[packet.getByte()];
        if (!isServer) {
            this.owner = CoFHProps.DEFAULT_OWNER;
            this.setOwner(new GameProfile(packet.getUUID(), packet.getString()));
        } else {
            packet.getUUID();
            packet.getString();
        }
        this.isPowered = packet.getBool();
        this.rsMode = IRedstoneControl.ControlMode.values()[packet.getByte()];
        if (!isServer) {
            boolean active = this.isActive;
            this.isActive = packet.getBool();
            if (this.isActive && !active && this.getSoundName() != null && !this.getSoundName().isEmpty()) {
                SoundHelper.playSound((ISound)this.getSound());
            }
        } else {
            packet.getBool();
        }
        int energy = packet.getInt();
        if (!isServer) {
            this.energyStorage.setEnergyStored(energy);
        }
        packet.getByteArray(this.sideCache);
        for (int var3 = 0; var3 < 6; ++var3) {
            if (this.sideCache[var3] < this.getNumConfig(var3)) continue;
            this.sideCache[var3] = 0;
        }
        if (!isServer) {
            this.facing = packet.getByte();
            this.augmentReconfigSides = packet.getBool();
            this.augmentRedstoneControl = packet.getBool();
            byte oldLevel = this.level;
            this.level = packet.getByte();
            if (oldLevel != this.level) {
                this.augments = new ItemStack[AUGMENT_COUNT[this.level]];
                this.augmentStatus = new boolean[this.augments.length];
                this.energyConfig.setParams(this.energyConfig.minPower, this.energyConfig.maxPower, this.energyConfig.maxEnergy * ENERGY_CAPACITY[this.level] / 2);
                this.energyStorage.setCapacity(this.energyConfig.maxEnergy);
            }
        } else {
            packet.getByte();
            packet.getBool();
            packet.getBool();
            packet.getByte();
        }
    }

    public void handleTileInfoPacket(PacketCoFHBase packet, boolean isServer, EntityPlayer player) {
        switch (packet.getByte()) {
            case 1: {
                this.handleGuiPacket(packet);
                return;
            }
            case 2: {
                this.handleFluidPacket(packet);
                return;
            }
            case 3: {
                this.handleModePacket(packet);
                return;
            }
        }
    }

    public String getDataType() {
        return this.getName();
    }

    public int getInfoEnergyPerTick() {
        return this.calcEnergy() * this.energyMod;
    }

    public int getInfoMaxEnergyPerTick() {
        return this.energyConfig.maxPower * this.energyMod;
    }

    public int getInfoEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getInfoMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        if (this.canPlayerAccess(player)) {
            if (this.augmentRedstoneControl) {
                this.rsMode = RedstoneControlHelper.getControlFromNBT((NBTTagCompound)tag);
            }
            if (this.augmentReconfigSides) {
                byte var3 = MachineHelper.getFacingFromNBT(tag);
                byte[] var4 = MachineHelper.getSideCacheFromNBT(tag, this.getDefaultSides());
                this.sideCache[0] = var4[0];
                this.sideCache[1] = var4[1];
                this.sideCache[this.facing] = var4[var3];
                this.sideCache[BlockHelper.getLeftSide((int)this.facing)] = var4[BlockHelper.getLeftSide((int)var3)];
                this.sideCache[BlockHelper.getRightSide((int)this.facing)] = var4[BlockHelper.getRightSide((int)var3)];
                this.sideCache[BlockHelper.getOppositeSide((int)this.facing)] = var4[BlockHelper.getOppositeSide((int)var3)];
                for (int var5 = 0; var5 < 6; ++var5) {
                    if (this.sideCache[var5] < this.getNumConfig(var5)) continue;
                    this.sideCache[var5] = 0;
                }
                this.func_70296_d();
                this.sendUpdatePacket(Side.CLIENT);
            }
        }
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        if (this.canPlayerAccess(player)) {
            RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)tag, (IRedstoneControl)this);
            MachineHelper.setItemStackTagReconfig(tag, this);
        }
    }

    public boolean canAccess() {
        return this.canAccess;
    }

    public boolean isSecured() {
        return !SecurityHelper.isDefaultUUID((UUID)this.owner.getId());
    }

    public boolean transferItem(int slot, int amount, int side) {
        if (this.inventory[slot] != null && slot <= this.inventory.length) {
            ItemStack output = this.inventory[slot].func_77946_l();
            output.field_77994_a = amount = Math.min(amount, output.field_77994_a);
            TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)side);
            if (MachineHelper.isInventory(tile, side)) {
                this.inventory[slot].field_77994_a -= amount - MachineHelper.addToInventory(tile, side, output);
                if (this.inventory[slot].field_77994_a <= 0) {
                    this.inventory[slot] = null;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void receiveGuiNetworkData(int i, int j) {
        this.canAccess = j != 0;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack result;
        if (this.inventory[slot] == null) {
            result = null;
        } else {
            if (this.inventory[slot].field_77994_a <= amount) {
                amount = this.inventory[slot].field_77994_a;
            }
            ItemStack stack = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a <= 0) {
                this.inventory[slot] = null;
            }
            result = stack;
        }
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot <= this.getMaxInputSlot() && this.isActive && (this.inventory[slot] == null || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_145850_b);
            this.processRem = 0;
        }
        return result;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] == null) {
            return null;
        }
        ItemStack stack = this.inventory[slot];
        this.inventory[slot] = null;
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (ServerHelper.isServerWorld((World)this.field_145850_b) && slot <= this.getMaxInputSlot() && this.isActive && this.inventory[slot] != null && (stack == null || !stack.func_77969_a(this.inventory[slot]) || !this.hasValidInput())) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_145850_b);
            this.processRem = 0;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.markChunkDirty();
    }

    public String func_145825_b() {
        return this.tileName.isEmpty() ? this.getName() : this.tileName;
    }

    public boolean func_145818_k_() {
        return !this.tileName.isEmpty();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.isUseable(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        return this.sideConfig.slotGroups[this.sideCache[side]];
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.sideConfig.allowInsertion[this.sideCache[side]] && this.isItemValid(stack, slot, side);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.sideConfig.allowExtraction[this.sideCache[side]];
    }

    public void func_70296_d() {
        if (this.isActive && !this.hasValidInput()) {
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_145850_b);
            this.processRem = 0;
        }
        super.func_70296_d();
    }

    public boolean setAccess(ISecurable.AccessMode access) {
        this.access = access;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public ISecurable.AccessMode getAccess() {
        return this.access;
    }

    public boolean setOwnerName(String owner) {
        if (MinecraftServer.func_71276_C() == null) {
            return false;
        }
        if (!Strings.isNullOrEmpty((String)owner) && !CoFHProps.DEFAULT_OWNER.getName().equalsIgnoreCase(owner)) {
            String uuid = PreYggdrasilConverter.func_152719_a((String)owner);
            return !Strings.isNullOrEmpty((String)uuid) && this.setOwner(new GameProfile(UUID.fromString(uuid), owner));
        }
        return false;
    }

    public boolean setOwner(GameProfile var1) {
        if (this.owner.getId().variant() == 0) {
            this.owner = var1;
            if (this.owner.getId().variant() != 0) {
                if (MinecraftServer.func_71276_C() != null) {
                    new Thread("CoFH User Loader"){

                        @Override
                        public void run() {
                            TileMachineBase.this.owner = SecurityHelper.getProfile((UUID)TileMachineBase.this.owner.getId(), (String)TileMachineBase.this.owner.getName());
                        }
                    }.start();
                }
                this.markChunkDirty();
                return true;
            }
        }
        return false;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        String name = this.owner.getName();
        return name == null ? StringHelper.localize((String)"info.cofh.anotherplayer") : name;
    }

    public final void setPowered(boolean var1) {
        this.wasPowered = this.isPowered;
        this.isPowered = var1;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public final boolean isPowered() {
        return this.isPowered;
    }

    public final void setControl(IRedstoneControl.ControlMode var1) {
        this.rsMode = var1;
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            PacketThermalSmeltery.sendRSConfigUpdatePacketToServer(this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public final IRedstoneControl.ControlMode getControl() {
        return this.rsMode;
    }

    @SideOnly(value=Side.CLIENT)
    public ISound getSound() {
        return new SoundTile((ISoundSource)this, this.getSoundName(), 1.0f, 1.0f, true, 0, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
    }

    public String getSoundName() {
        return soundsSmeltery[this.getType()];
    }

    public boolean shouldPlaySound() {
        return !this.field_145846_f && this.isActive;
    }

    public void onNeighborBlockChange() {
        this.wasPowered = this.isPowered;
        this.isPowered = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.wasPowered != this.isPowered && this.sendRedstoneUpdates()) {
            PacketThermalSmeltery.sendRSPowerUpdatePacketToClients(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.onRedstoneUpdate();
        }
    }

    protected boolean sendRedstoneUpdates() {
        return false;
    }

    public final boolean redstoneControlOrDisable() {
        return this.rsMode.isDisabled() || this.isPowered == this.rsMode.getState();
    }

    public void onRedstoneUpdate() {
    }

    public int getChargeSlot() {
        return this.inventory.length - 1;
    }

    public boolean hasChargeSlot() {
        return true;
    }

    protected void chargeEnergy() {
        int slot = this.getChargeSlot();
        if (this.hasChargeSlot() && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[slot])) {
            int energy = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyContainerItem)this.inventory[slot].func_77973_b()).extractEnergy(this.inventory[slot], energy, false), false);
            if (this.inventory[slot].field_77994_a <= 0) {
                this.inventory[slot] = null;
            }
        }
    }

    public final void setEnergyStored(int var1) {
        this.energyStorage.setEnergyStored(var1);
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public boolean isItemValid(ItemStack var1, int var2, int var3) {
        return true;
    }

    public int getScaledEnergyStored(int height) {
        return this.energyStorage.getEnergyStored() * height / this.energyStorage.getMaxEnergyStored();
    }

    public int receiveEnergy(ForgeDirection direction, int amount, boolean simulate) {
        return this.energyStorage.receiveEnergy(amount, simulate);
    }

    public int getEnergyStored(ForgeDirection direction) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection direction) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(ForgeDirection direction) {
        return this.energyStorage.getMaxEnergyStored() > 0;
    }

    public boolean onWrench(EntityPlayer var1, int var2) {
        return this.rotateBlock();
    }

    public byte[] getDefaultSides() {
        return new byte[]{0, 0, 0, 0, 0, 0};
    }

    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
    }

    public final boolean hasSide(int type) {
        for (int side = 0; side < 6; ++side) {
            if (this.sideCache[side] != type) continue;
            return true;
        }
        return false;
    }

    public final int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        if (this.isActive) {
            return false;
        }
        byte[] newSideCache = new byte[6];
        for (int side = 0; side < 6; ++side) {
            newSideCache[side] = this.sideCache[BlockHelper.ROTATE_CLOCK_Y[side]];
        }
        this.sideCache = (byte[])newSideCache.clone();
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side >= 0 && side <= 5) {
            if (!this.allowYAxisFacing() && side < 2) {
                return false;
            }
            this.sideCache[side] = 0;
            this.facing = (byte)side;
            this.func_70296_d();
            this.sendUpdatePacket(Side.CLIENT);
            return true;
        }
        return false;
    }

    public boolean decrSide(int side) {
        if (side == this.facing || !this.augmentReconfigSides) {
            return false;
        }
        this.sideCache[side] = (byte)((this.sideCache[side] + (this.getNumConfig(side) - 1)) % this.getNumConfig(side));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean incrSide(int side) {
        if (side == this.facing || !this.augmentReconfigSides) {
            return false;
        }
        int n = side;
        this.sideCache[n] = (byte)(this.sideCache[n] + 1);
        this.sideCache[side] = (byte)(this.sideCache[side] % this.getNumConfig(side));
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public boolean setSide(int side, int type) {
        if (this.augmentReconfigSides && side != this.facing && this.sideCache[side] != type && type < this.getNumConfig(side)) {
            this.sideCache[side] = (byte)type;
            this.sendUpdatePacket(Side.SERVER);
            return true;
        }
        return false;
    }

    public boolean resetSides() {
        boolean didReset = false;
        if (this.augmentReconfigSides) {
            for (int side = 0; side < 6; ++side) {
                if (this.sideCache[side] <= 0) continue;
                this.sideCache[side] = 0;
                didReset = true;
            }
            if (didReset) {
                this.sendUpdatePacket(Side.SERVER);
            }
        }
        return didReset;
    }

    public int getNumConfig(int var1) {
        return this.sideConfig.numGroup;
    }

    public IIcon getTexture(int face, int pass) {
        return pass == 0 ? (face == 0 ? IconRegistry.getIcon((String)"SmelteryBottom") : (face == 1 ? IconRegistry.getIcon((String)"SmelteryTop") : (face != this.facing ? IconRegistry.getIcon((String)"SmelterySide") : (this.isActive ? IconRegistry.getIcon((String)"SmelteryActive", (int)this.getType()) : IconRegistry.getIcon((String)"SmelteryFace", (int)this.getType()))))) : (face < 6 ? IconRegistry.getIcon((String)(this.getFaceString(face) + "Config_"), (int)this.sideConfig.sideTex[this.sideCache[face]]) : IconRegistry.getIcon((String)"SmelterySide"));
    }

    public ItemStack[] getAugmentSlots() {
        return this.augments;
    }

    public boolean[] getAugmentStatus() {
        return this.augmentStatus;
    }

    public void installAugments() {
        this.resetAugments();
        for (int var1 = 0; var1 < this.augments.length; ++var1) {
            this.augmentStatus[var1] = false;
            if (!MachineHelper.isAugmentItem(this.augments[var1])) continue;
            this.augmentStatus[var1] = this.installAugment(var1);
        }
        if (this.field_145850_b != null && ServerHelper.isServerWorld((World)this.field_145850_b)) {
            this.onInstalled();
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    protected boolean hasAugment(String type, int level) {
        for (ItemStack augment : this.augments) {
            if (!MachineHelper.isAugmentItem(augment) || ((IAugmentItem)augment.func_77973_b()).getAugmentLevel(augment, type) != level) continue;
            return true;
        }
        return false;
    }

    protected boolean hasDuplicateAugment(String type, int level, int slot) {
        for (int i = 0; i < this.augments.length; ++i) {
            if (i == slot || !MachineHelper.isAugmentItem(this.augments[i]) || ((IAugmentItem)this.augments[i].func_77973_b()).getAugmentLevel(this.augments[i], type) != level) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAugmentChain(String type, int level) {
        boolean found = true;
        for (int i = 1; i < level; ++i) {
            found = found && this.hasAugment(type, i);
        }
        return found;
    }

    protected boolean installAugment(int slot) {
        int augmentLevel;
        IAugmentItem item = (IAugmentItem)this.augments[slot].func_77973_b();
        boolean install = false;
        if (item.getAugmentLevel(this.augments[slot], MachineHelper.MACHINE_SECONDARY) > 0) {
            augmentLevel = Math.min(MachineHelper.NUM_MACHINE_SECONDARY, item.getAugmentLevel(this.augments[slot], MachineHelper.MACHINE_SECONDARY));
            if (augmentLevel > this.level) {
                return false;
            }
            if (this.hasDuplicateAugment(MachineHelper.MACHINE_SECONDARY, augmentLevel, slot)) {
                return false;
            }
            if (!this.hasAugmentChain(MachineHelper.MACHINE_SECONDARY, augmentLevel)) {
                return false;
            }
            this.secondaryChance -= MachineHelper.MACHINE_SECONDARY_MOD[augmentLevel];
            install = true;
        }
        if (item.getAugmentLevel(this.augments[slot], MachineHelper.MACHINE_SPEED) > 0) {
            augmentLevel = Math.min(MachineHelper.NUM_MACHINE_SPEED, item.getAugmentLevel(this.augments[slot], MachineHelper.MACHINE_SPEED));
            if (augmentLevel > this.level) {
                return false;
            }
            if (this.hasDuplicateAugment(MachineHelper.MACHINE_SPEED, augmentLevel, slot)) {
                return false;
            }
            if (!this.hasAugmentChain(MachineHelper.MACHINE_SPEED, augmentLevel)) {
                return false;
            }
            this.secondaryChance += MachineHelper.MACHINE_SPEED_SECONDARY_MOD[augmentLevel];
            this.processMod = Math.max(this.processMod, MachineHelper.MACHINE_SPEED_PROCESS_MOD[augmentLevel]);
            this.energyMod = Math.max(this.energyMod, MachineHelper.MACHINE_SPEED_ENERGY_MOD[augmentLevel]);
            install = true;
        }
        if (item.getAugmentLevel(this.augments[slot], MachineHelper.ENERGY_STORAGE) > 0) {
            augmentLevel = Math.min(MachineHelper.NUM_ENERGY_STORAGE, item.getAugmentLevel(this.augments[slot], MachineHelper.ENERGY_STORAGE));
            if (augmentLevel > this.level) {
                return false;
            }
            if (this.hasDuplicateAugment(MachineHelper.ENERGY_STORAGE, augmentLevel, slot)) {
                return false;
            }
            if (!this.hasAugmentChain(MachineHelper.ENERGY_STORAGE, augmentLevel)) {
                return false;
            }
            this.energyStorage.setCapacity(Math.max(this.energyStorage.getMaxEnergyStored(), this.energyConfig.maxEnergy * MachineHelper.ENERGY_STORAGE_MOD[augmentLevel]));
            install = true;
        }
        if (item.getAugmentLevel(this.augments[slot], MachineHelper.GENERAL_AUTO_OUTPUT) > 0) {
            this.augmentAutoTransfer = true;
            install = true;
        }
        if (item.getAugmentLevel(this.augments[slot], MachineHelper.GENERAL_RECONFIG_SIDES) > 0) {
            this.augmentReconfigSides = true;
            install = true;
        }
        if (item.getAugmentLevel(this.augments[slot], MachineHelper.GENERAL_REDSTONE_CONTROL) > 0) {
            this.augmentRedstoneControl = true;
            install = true;
        }
        return install;
    }

    protected void onInstalled() {
        if (!this.augmentReconfigSides) {
            this.setDefaultSides();
            this.sideCache[this.facing] = 0;
        }
        if (!this.augmentRedstoneControl) {
            this.rsMode = IRedstoneControl.ControlMode.DISABLED;
        }
        if (this.isActive && this.energyStorage.getMaxEnergyStored() > 0 && this.processRem * this.energyMod / this.processMod > this.energyStorage.getEnergyStored()) {
            this.processRem = 0;
            this.isActive = false;
            this.wasActive = true;
            this.tracker.markTime(this.field_145850_b);
        }
    }

    protected void resetAugments() {
        this.processMod = 1;
        this.energyMod = 1;
        this.secondaryChance = 100;
        this.augmentAutoTransfer = false;
        this.augmentReconfigSides = false;
        this.augmentRedstoneControl = false;
    }

    public FluidTankAdv getTank() {
        return null;
    }

    public static class EnergyConfig {
        public int minPower = 8;
        public int maxPower = 80;
        public int maxEnergy = 40000;
        public int minPowerLevel = this.maxEnergy / 10;
        public int maxPowerLevel = 9 * this.maxEnergy / 10;
        public int energyRamp = this.maxPowerLevel / this.maxPower;

        public EnergyConfig() {
        }

        public EnergyConfig(EnergyConfig energyConfig) {
            this.minPower = energyConfig.minPower;
            this.maxPower = energyConfig.maxPower;
            this.maxEnergy = energyConfig.maxEnergy;
            this.minPowerLevel = energyConfig.minPowerLevel;
            this.maxPowerLevel = energyConfig.maxPowerLevel;
            this.energyRamp = energyConfig.energyRamp;
        }

        public EnergyConfig copy() {
            return new EnergyConfig(this);
        }

        public boolean setParams(int minPower, int maxPower, int maxEnergy) {
            this.minPower = minPower;
            this.maxPower = maxPower;
            this.maxEnergy = maxEnergy;
            this.maxPowerLevel = maxEnergy * 8 / 10;
            this.energyRamp = maxPower > 0 ? this.maxPowerLevel / maxPower : 0;
            this.minPowerLevel = minPower * this.energyRamp;
            return true;
        }
    }

    public static class SideConfig {
        public int numGroup;
        public int[][] slotGroups;
        public boolean[] allowInsertion;
        public boolean[] allowExtraction;
        public int[] sideTex;
        public byte[] defaultSides;
    }
}

