/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.blocks;

import cofh.api.tileentity.ITileInfo;
import cofh.core.network.PacketCoFHBase;
import cofh.core.util.fluid.FluidTankAdv;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tconstruct.library.crafting.CastingRecipe;
import us.drullk.thermalsmeltery.common.blocks.TileMachineBase;
import us.drullk.thermalsmeltery.common.core.handler.TSmeltConfig;
import us.drullk.thermalsmeltery.common.gui.client.GuiExtruder;
import us.drullk.thermalsmeltery.common.gui.container.ContainerExtruder;
import us.drullk.thermalsmeltery.common.plugins.tcon.smeltery.MachineRecipeRegistry;

public class TileExtruder
extends TileMachineBase
implements IFluidHandler,
ITileInfo {
    static final int TYPE = 0;
    FluidTankAdv tank = new FluidTankAdv(10000);
    FluidStack renderFluid;
    public boolean block;
    public boolean blockFlag;

    public static void initialize() {
        TileExtruder.defaultSideConfigSmeltery[0] = new TileMachineBase.SideConfig();
        TileExtruder.defaultSideConfigSmeltery[0].numGroup = 4;
        TileExtruder.defaultSideConfigSmeltery[0].slotGroups = new int[][]{new int[0], new int[0], {0}, new int[0]};
        TileExtruder.defaultSideConfigSmeltery[0].allowInsertion = new boolean[]{false, false, false, false};
        TileExtruder.defaultSideConfigSmeltery[0].allowExtraction = new boolean[]{false, false, true, true};
        TileExtruder.defaultSideConfigSmeltery[0].sideTex = new int[]{0, 1, 2, 3};
        TileExtruder.defaultSideConfigSmeltery[0].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        int basePower = 400;
        TileExtruder.defaultEnergyConfigSmeltery[0] = new TileMachineBase.EnergyConfig();
        defaultEnergyConfigSmeltery[0].setParams(basePower / 10, basePower, Math.max(480000, basePower * 1200));
        GameRegistry.registerTileEntity(TileExtruder.class, (String)"thermalsmeltery.Extruder");
    }

    @Override
    protected int getInventorySize() {
        return 2;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("craftBlock", this.block);
        this.tank.writeToNBT(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.blockFlag = this.block = tag.func_74767_n("craftBlock");
        this.tank.readFromNBT(tag);
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packet) {
        super.handleGuiPacket(packet);
        this.tank.setFluid(packet.getFluidStack());
        this.block = packet.getBool();
        this.blockFlag = packet.getBool();
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packet = super.getGuiPacket();
        if (this.tank.getFluid() == null) {
            packet.addFluidStack(this.renderFluid);
        } else {
            packet.addFluidStack(this.tank.getFluid());
        }
        packet.addBool(this.block);
        packet.addBool(this.blockFlag);
        return packet;
    }

    @Override
    public PacketCoFHBase getFluidPacket() {
        PacketCoFHBase var1 = super.getFluidPacket();
        var1.addFluidStack(this.renderFluid);
        return var1;
    }

    @Override
    protected void handleFluidPacket(PacketCoFHBase packet) {
        super.handleFluidPacket(packet);
        this.renderFluid = packet.getFluidStack();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packet = super.getPacket();
        packet.addFluidStack(this.renderFluid);
        return packet;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packet, boolean isServer) {
        super.handleTilePacket(packet, isServer);
        if (!isServer) {
            this.renderFluid = packet.getFluidStack();
        } else {
            packet.getFluidStack();
        }
    }

    @Override
    public PacketCoFHBase getModePacket() {
        PacketCoFHBase var1 = super.getModePacket();
        var1.addBool(this.blockFlag);
        return var1;
    }

    @Override
    protected void handleModePacket(PacketCoFHBase packet) {
        super.handleModePacket(packet);
        this.blockFlag = packet.getBool();
        if (!this.isActive) {
            this.block = this.blockFlag;
        }
        this.callNeighborTileChange();
    }

    public void setMode(boolean block) {
        boolean var2 = this.blockFlag;
        this.blockFlag = block;
        this.sendModePacket();
        this.blockFlag = var2;
    }

    public int getType() {
        return 0;
    }

    @Override
    protected int getMaxInputSlot() {
        return -1;
    }

    @Override
    protected boolean hasRoomForOutput() {
        CastingRecipe recipe = this.getRecipe();
        return this.canFit(recipe.output, 0);
    }

    @Override
    protected boolean hasValidInput() {
        CastingRecipe recipe = this.getRecipe();
        return recipe != null && this.tank.getFluidAmount() >= recipe.castingMetal.amount;
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.getRecipeTime(this.getRecipe());
    }

    @Override
    protected void processFinish() {
        CastingRecipe recipe = this.getRecipe();
        ItemStack output = recipe.getResult();
        if (this.inventory[0] == null) {
            this.inventory[0] = output;
        } else {
            this.inventory[0].field_77994_a += output.field_77994_a;
        }
        this.tank.drain(recipe.castingMetal, true);
        this.block = this.blockFlag;
    }

    public CastingRecipe getRecipe() {
        if (this.tank.getFluid() == null) {
            return null;
        }
        return MachineRecipeRegistry.getExtruderRecipe(this.getTank().getFluid().getFluid(), this.block);
    }

    private int getRecipeTime(CastingRecipe recipe) {
        if (recipe == null) {
            return 0;
        }
        return recipe.coolTime * 1000 * TSmeltConfig.stamperMultiplier;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || !MachineRecipeRegistry.isValidFluid(resource.getFluid())) {
            return 0;
        }
        return from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] == 1 ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] == 2 ? (resource != null && resource.isFluidEqual(this.tank.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 2 ? null : this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return MachineRecipeRegistry.isValidFluid(fluid) && (from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] == 1);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] == 2;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean b) {
        if (!b) {
            if (this.tank.getFluid() != null) {
                list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.getFluidName((FluidStack)this.tank.getFluid())));
                list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.amount") + ": " + this.tank.getFluidAmount() + "/" + this.tank.getCapacity() + " mB"));
            } else {
                list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.fluid") + ": " + StringHelper.localize((String)"info.cofh.empty")));
            }
        }
    }

    @Override
    public FluidTankAdv getTank() {
        return this.tank;
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiExtruder(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerExtruder(inventoryPlayer, (TileEntity)this);
    }
}

