/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.blocks;

import cofh.api.item.IToolHammer;
import cofh.api.transport.IItemDuct;
import cofh.lib.util.helpers.AugmentHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.InventoryHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.plugins.nei.handlers.NEIRecipeWrapper;
import cofh.thermalexpansion.util.crafting.RecipeMachine;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import us.drullk.thermalsmeltery.common.blocks.BlockMachine;
import us.drullk.thermalsmeltery.common.blocks.TileMachineBase;

public class MachineHelper {
    public static byte NUM_ENERGY_STORAGE = (byte)3;
    public static byte NUM_MACHINE_SECONDARY = (byte)3;
    public static byte NUM_MACHINE_SPEED = (byte)3;
    public static final int[] ENERGY_STORAGE_MOD = new int[]{1, 2, 4, 8};
    public static final int[] MACHINE_SPEED_PROCESS_MOD = new int[]{1, 2, 4, 8};
    public static final int[] MACHINE_SPEED_ENERGY_MOD = new int[]{1, 3, 8, 20};
    public static final int[] MACHINE_SPEED_SECONDARY_MOD = new int[]{0, 5, 10, 15};
    public static final int[] MACHINE_SECONDARY_MOD = new int[]{0, 10, 15, 20};
    public static String ENERGY_STORAGE = "energyStorage";
    public static String GENERAL_AUTO_OUTPUT = "generalAutoOutput";
    public static String GENERAL_RECONFIG_SIDES = "generalReconfigSides";
    public static String GENERAL_REDSTONE_CONTROL = "generalRedstoneControl";
    public static String MACHINE_SECONDARY = "machineSecondary";
    public static String MACHINE_SPEED = "machineSpeed";
    public static String TOOL_MULTIMETER = "multimeter";
    public static String TOOL_DEBUGGER = "debugger";
    public static ItemStack coilGold;
    public static String GOLD_COIL;
    public static String MACHINE_FRAME;
    public static String COPPER_GEAR;
    public static ItemStack generalAutoOutput;
    public static ItemStack generalReconfigSides;
    public static ItemStack generalRedstoneControl;
    public static ItemStack toolMultimeter;
    public static ItemStack toolDebugger;

    public static void initialize() {
        generalAutoOutput = MachineHelper.getCustomStack(GENERAL_AUTO_OUTPUT);
        generalReconfigSides = MachineHelper.getCustomStack(GENERAL_RECONFIG_SIDES);
        generalRedstoneControl = MachineHelper.getCustomStack(GENERAL_REDSTONE_CONTROL);
        toolMultimeter = MachineHelper.getCustomStack(TOOL_MULTIMETER);
        toolDebugger = MachineHelper.getCustomStack(TOOL_DEBUGGER);
        coilGold = MachineHelper.getCustomStack(GOLD_COIL);
    }

    private static ItemStack getCustomStack(String name) {
        return GameRegistry.findItemStack((String)"ThermalExpansion", (String)name, (int)1);
    }

    public static NBTTagCompound setItemStackTagReconfig(NBTTagCompound tag, TileMachineBase tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74774_a("Facing", (byte)tile.getFacing());
        tag.func_74773_a("SideCache", tile.sideCache);
        return tag;
    }

    public static byte getFacingFromNBT(NBTTagCompound tag) {
        return !tag.func_74764_b("Facing") ? (byte)3 : tag.func_74771_c("Facing");
    }

    public static byte[] getSideCacheFromNBT(NBTTagCompound tag, byte[] sideCache) {
        if (tag == null) {
            return (byte[])sideCache.clone();
        }
        byte[] saved = tag.func_74770_j("SideCache");
        return saved.length < 6 ? (byte[])sideCache.clone() : saved;
    }

    public static boolean setFacing(ItemStack stack, int facing) {
        if (facing >= 0 && facing <= 5) {
            if (stack.field_77990_d == null) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.field_77990_d.func_74774_a("Facing", (byte)facing);
            return true;
        }
        return false;
    }

    public static boolean setSideCache(ItemStack stack, byte[] sideCache) {
        if (sideCache.length < 6) {
            return false;
        }
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74773_a("SideCache", sideCache);
        return true;
    }

    public static byte getFacing(ItemStack stack) {
        return stack.field_77990_d != null && stack.field_77990_d.func_74764_b("Facing") ? stack.field_77990_d.func_74771_c("Facing") : (byte)3;
    }

    public static byte[] getSideCache(ItemStack stack, byte[] sideCache) {
        if (stack.field_77990_d == null) {
            return (byte[])sideCache.clone();
        }
        byte[] var2 = stack.field_77990_d.func_74770_j("SideCache");
        return var2.length < 6 ? (byte[])sideCache.clone() : var2;
    }

    public static int addToInventory(TileEntity tile, int side, ItemStack stack) {
        if (!InventoryHelper.isInsertion((Object)tile)) {
            return stack.field_77994_a;
        }
        return (stack = InventoryHelper.addToInsertion((Object)tile, (int)side, (ItemStack)stack)) == null ? 0 : stack.field_77994_a;
    }

    public static boolean isInventory(TileEntity tile, int side) {
        return (!(tile instanceof ISidedInventory) || ((ISidedInventory)tile).func_94128_d((int)BlockHelper.SIDE_OPPOSITE[side]).length > 0) && (tile instanceof IInventory && ((IInventory)tile).func_70302_i_() > 0 || tile instanceof IItemDuct);
    }

    public static boolean isAugmentItem(ItemStack stack) {
        return AugmentHelper.isAugmentItem((ItemStack)stack);
    }

    public static boolean isHoldingMultimeter(EntityPlayer player) {
        return ItemHelper.isPlayerHoldingItemStack((ItemStack)toolMultimeter, (EntityPlayer)player);
    }

    public static boolean isHoldingDebugger(EntityPlayer player) {
        return ItemHelper.isPlayerHoldingItemStack((ItemStack)toolDebugger, (EntityPlayer)player);
    }

    public static boolean isHoldingUsableWrench(EntityPlayer player, int x, int y, int z) {
        Item item = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return item instanceof IToolHammer && ((IToolHammer)item).isUsable(player.func_71045_bC(), (EntityLivingBase)player, x, y, z);
    }

    public static void usedWrench(EntityPlayer player, int x, int y, int z) {
        Item item;
        Item item2 = item = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (item instanceof IToolHammer) {
            ((IToolHammer)item).toolUsed(player.func_71045_bC(), (EntityLivingBase)player, x, y, z);
        }
    }

    public static void registerRecipes(ItemStack machine, Object[] args) {
        NEIRecipeWrapper.addMachineRecipe((IRecipe)new RecipeMachine(machine, BlockMachine.defaultAugments, args));
        TECraftingHandler.addMachineUpgradeRecipes((ItemStack)machine);
        TECraftingHandler.addSecureRecipe((ItemStack)machine);
    }

    static {
        GOLD_COIL = "powerCoilGold";
        MACHINE_FRAME = "thermalexpansion:machineFrame";
        COPPER_GEAR = "thermalexpansion:machineCopper";
    }
}

