/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.thermalsmeltery.common.blocks;

import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.api.tileentity.ISidedTexture;
import cofh.core.block.BlockCoFHBase;
import cofh.core.block.TileCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.RedstoneControlHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.IFluidHandler;
import us.drullk.thermalsmeltery.ThermalSmeltery;
import us.drullk.thermalsmeltery.common.blocks.MachineHelper;
import us.drullk.thermalsmeltery.common.blocks.TileExtruder;
import us.drullk.thermalsmeltery.common.blocks.TileMachineBase;
import us.drullk.thermalsmeltery.common.blocks.TileStamper;
import us.drullk.thermalsmeltery.common.items.ItemBlockSmeltery;
import us.drullk.thermalsmeltery.common.plugins.tcon.smeltery.TConSmeltery;

public class BlockMachine
extends BlockCoFHBase {
    public static final String[] NAMES = new String[]{"extruder", "stamper"};
    public static final String[] COLOURS = new String[]{"Blank", "Blue", "Red", "Yellow", "Orange", "Green", "Purple"};
    public static boolean[] enable = new boolean[]{true, true};
    public static boolean[] creativeTiers = new boolean[]{true, false, false, true};
    public static ItemStack[] defaultAugments = new ItemStack[3];
    public static boolean defaultAutoTransfer = true;
    public static boolean defaultRedstoneControl = true;
    public static boolean defaultReconfigSides = true;
    public static ItemStack extruder;
    public static ItemStack stamper;

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalsmeltery.machine");
        this.func_149647_a(ThermalSmeltery.itemTab);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileExtruder();
            }
            case 1: {
                return new TileStamper();
            }
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!enable[i]) continue;
            for (int tier = 0; tier < 4; ++tier) {
                if (!creativeTiers[tier]) continue;
                list.add(ItemBlockSmeltery.setDefaultTag(new ItemStack(item, 1, i), (byte)tier));
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        if (stack.field_77990_d != null) {
            TileMachineBase machine = (TileMachineBase)world.func_147438_o(x, y, z);
            machine.setInvName(ItemHelper.getNameFromItemStack((ItemStack)stack));
            machine.readAugmentsFromNBT(stack.field_77990_d);
            machine.installAugments();
            machine.setEnergyStored(stack.field_77990_d.func_74762_e("Energy"));
            int placing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)player);
            byte facing = MachineHelper.getFacing(stack);
            byte[] sideCache = MachineHelper.getSideCache(stack, machine.getDefaultSides());
            machine.sideCache[0] = sideCache[0];
            machine.sideCache[1] = sideCache[1];
            machine.sideCache[placing] = 0;
            machine.sideCache[BlockHelper.getLeftSide((int)placing)] = sideCache[BlockHelper.getLeftSide((int)facing)];
            machine.sideCache[BlockHelper.getRightSide((int)placing)] = sideCache[BlockHelper.getRightSide((int)facing)];
            machine.sideCache[BlockHelper.getOppositeSide((int)placing)] = sideCache[BlockHelper.getOppositeSide((int)facing)];
        }
        super.func_149689_a(world, x, y, z, player, stack);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        boolean result;
        TileEntity tile = world.func_147438_o(x, y, z);
        boolean bl = result = tile instanceof IFluidHandler && FluidHelper.fillHandlerWithContainer((World)world, (IFluidHandler)((IFluidHandler)tile), (EntityPlayer)player);
        if (!result) {
            PlayerInteractEvent event = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, x, y, z, side, world);
            if (!MinecraftForge.EVENT_BUS.post((Event)event) && event.getResult() != Event.Result.DENY && event.useBlock != Event.Result.DENY) {
                if (MachineHelper.isHoldingDebugger(player) || MachineHelper.isHoldingMultimeter(player)) {
                    result = true;
                } else if (player.func_70093_af()) {
                    if (MachineHelper.isHoldingUsableWrench(player, x, y, z)) {
                        if (ServerHelper.isServerWorld((World)world) && this.canDismantle(player, world, x, y, z)) {
                            this.dismantleBlock(player, world, x, y, z, false);
                        }
                        MachineHelper.usedWrench(player, x, y, z);
                        result = true;
                    } else {
                        result = false;
                    }
                } else {
                    TileMachineBase machine = (TileMachineBase)tile;
                    if (MachineHelper.isHoldingUsableWrench(player, x, y, z)) {
                        if (ServerHelper.isServerWorld((World)world)) {
                            machine.onWrench(player, side);
                        }
                        MachineHelper.usedWrench(player, x, y, z);
                        result = true;
                    } else {
                        result = !ServerHelper.isServerWorld((World)world) || machine.openGui(player);
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        ISidedTexture te = (ISidedTexture)world.func_147438_o(x, y, z);
        return te == null ? null : te.getTexture(side, renderPass);
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 ? IconRegistry.getIcon((String)"SmelteryBottom") : (side == 1 ? IconRegistry.getIcon((String)"SmelteryTop") : (side != 3 ? IconRegistry.getIcon((String)"SmelterySide") : IconRegistry.getIcon((String)("SmelteryFace" + meta))));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        int i;
        IconRegistry.addIcon((String)"SmelteryBottom", (String)"thermalsmeltery:machine/machineBottom", (IIconRegister)register);
        IconRegistry.addIcon((String)"SmelteryTop", (String)"thermalsmeltery:machine/machineTop", (IIconRegister)register);
        IconRegistry.addIcon((String)"SmelterySide", (String)"thermalsmeltery:machine/machineSide", (IIconRegister)register);
        for (i = 0; i < NAMES.length; ++i) {
            IconRegistry.addIcon((String)("SmelteryFace" + i), (String)("thermalsmeltery:machine/machineFace" + StringHelper.titleCase((String)NAMES[i])), (IIconRegister)register);
            IconRegistry.addIcon((String)("SmelteryActive" + i), (String)("thermalsmeltery:machine/machineActive" + StringHelper.titleCase((String)NAMES[i])), (IIconRegister)register);
        }
        for (i = 0; i < COLOURS.length; ++i) {
            IconRegistry.addIcon((String)("sideConfig_" + i), (String)("thermalsmeltery:machine/side" + COLOURS[i]), (IIconRegister)register);
            IconRegistry.addIcon((String)("topConfig_" + i), (String)("thermalsmeltery:machine/top" + COLOURS[i]), (IIconRegister)register);
            IconRegistry.addIcon((String)("bottomConfig_" + i), (String)("thermalsmeltery:machine/bottom" + COLOURS[i]), (IIconRegister)register);
        }
    }

    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        NBTTagCompound tag = super.getItemStackTag(world, x, y, z);
        TileMachineBase machine = (TileMachineBase)world.func_147438_o(x, y, z);
        if (machine != null) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            if (!machine.tileName.isEmpty()) {
                tag = ItemHelper.setItemStackTagName((NBTTagCompound)tag, (String)machine.tileName);
            }
            if (machine.isSecured()) {
                tag = SecurityHelper.setItemStackTagSecure((NBTTagCompound)tag, (ISecurable)machine);
            }
            tag = RedstoneControlHelper.setItemStackTagRS((NBTTagCompound)tag, (IRedstoneControl)machine);
            MachineHelper.setItemStackTagReconfig(tag, machine);
            tag.func_74768_a("Energy", machine.getEnergyStored(ForgeDirection.UNKNOWN));
            machine.writeAugmentsToNBT(tag);
        }
        return tag;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, NBTTagCompound tagCompound, World world, int x, int y, int z, boolean returnDrops, boolean simulate) {
        TileEntity te = world.func_147438_o(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        ItemStack stack = new ItemStack((Block)this, 1, meta);
        if (tagCompound != null) {
            stack.func_77982_d(tagCompound);
        }
        if (!simulate) {
            if (te instanceof TileCoFHBase) {
                ((TileCoFHBase)te).blockDismantled();
            }
            world.func_147468_f(x, y, z);
            if (!returnDrops) {
                float mult = 0.3f;
                double vX = (double)(world.field_73012_v.nextFloat() * mult) + (double)(1.0f - mult) * 0.5;
                double vY = (double)(world.field_73012_v.nextFloat() * mult) + (double)(1.0f - mult) * 0.5;
                double vZ = (double)(world.field_73012_v.nextFloat() * mult) + (double)(1.0f - mult) * 0.5;
                EntityItem drop = new EntityItem(world, (double)x + vX, (double)y + vY, (double)z + vZ, stack);
                drop.field_145804_b = 10;
                world.func_72838_d((Entity)drop);
                if (player != null) {
                    CoreUtils.dismantleLog((String)player.func_70005_c_(), (Block)this, (int)meta, (double)x, (double)y, (double)z);
                }
            }
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(stack);
        return result;
    }

    public boolean initialize() {
        TileStamper.initialize();
        TileExtruder.initialize();
        if (defaultAutoTransfer) {
            BlockMachine.defaultAugments[0] = ItemHelper.cloneStack((ItemStack)MachineHelper.generalAutoOutput);
        }
        if (defaultRedstoneControl) {
            BlockMachine.defaultAugments[1] = ItemHelper.cloneStack((ItemStack)MachineHelper.generalRedstoneControl);
        }
        if (defaultReconfigSides) {
            BlockMachine.defaultAugments[2] = ItemHelper.cloneStack((ItemStack)MachineHelper.generalReconfigSides);
        }
        extruder = ItemBlockSmeltery.setDefaultTag(new ItemStack((Block)this, 1, 0));
        stamper = ItemBlockSmeltery.setDefaultTag(new ItemStack((Block)this, 1, 1));
        GameRegistry.registerCustomItemStack((String)"extruder", (ItemStack)extruder);
        GameRegistry.registerCustomItemStack((String)"stamper", (ItemStack)stamper);
        return true;
    }

    public boolean postInit() {
        MachineHelper.registerRecipes(extruder, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), MachineHelper.MACHINE_FRAME, Character.valueOf('P'), MachineHelper.coilGold, Character.valueOf('I'), MachineHelper.COPPER_GEAR, Character.valueOf('X'), TConSmeltery.CASTING_BASIN, Character.valueOf('Y'), TConSmeltery.SMELTERY_BRICK});
        MachineHelper.registerRecipes(stamper, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), MachineHelper.MACHINE_FRAME, Character.valueOf('P'), MachineHelper.coilGold, Character.valueOf('I'), MachineHelper.COPPER_GEAR, Character.valueOf('X'), TConSmeltery.TOOL_FORGE, Character.valueOf('Y'), TConSmeltery.SMELTERY_BRICK});
        return true;
    }
}

