/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.core.WorldGridList;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.Tracker;
import com.google.common.math.DoubleMath;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class MultiBlockGridTracking
extends MultiBlockGrid {
    private Tracker tracker;

    public MultiBlockGridTracking(WorldGridList worldGridList) {
        super(worldGridList);
    }

    public MultiBlockGridTracking(World world) {
        super(world);
    }

    public Tracker getTracker() {
        if (this.tracker == null) {
            this.tracker = new Tracker(this.getLevel());
        }
        this.tracker.life = 0;
        return this.tracker;
    }

    public abstract int getLevel();

    public int trackIn(int n, boolean bl) {
        if (!bl && this.tracker != null) {
            this.tracker.stuffIn(n);
        }
        return n;
    }

    public int trackOut(int n, boolean bl) {
        if (!bl && this.tracker != null) {
            this.tracker.stuffOut(n);
        }
        return n;
    }

    public int trackInOut(int n, boolean bl) {
        if (!bl && this.tracker != null) {
            this.tracker.stuffIn(n);
            this.tracker.stuffOut(n);
        }
        return n;
    }

    @Override
    public void tickGrid() {
        super.tickGrid();
        if (this.tracker != null) {
            this.tracker.newTick(this.getLevel());
            if (this.tracker.life > 3600) {
                this.tracker = null;
            }
        }
    }

    @Override
    public void addInfo(List<IChatComponent> list, EntityPlayer entityPlayer, boolean bl) {
        super.addInfo(list, entityPlayer, bl);
        this.addInfo(list, "tracker.cur", this.format(this.getLevel()));
        if (this.tracker == null) {
            list.add((IChatComponent)new ChatComponentTranslation("info.thermaldynamics.info.tracker.activate", new Object[0]));
            this.getTracker();
            return;
        }
        this.tracker.life = 0;
        this.addInfo(list, "tracker.avg", this.format(this.tracker.avgStuff()) + this.getUnit());
        this.addInfo(list, "tracker.avgInOut", String.format("+%s%s/-%s%s", this.format(this.tracker.avgStuffIn()), this.getUnit(), this.format(this.tracker.avgStuffOut()), this.getUnit()));
    }

    private String format(double d) {
        if (d == 0.0) {
            return "0";
        }
        if (DoubleMath.isMathematicalInteger((double)d)) {
            return Integer.toString((int)d);
        }
        return String.format("%.2f", d);
    }

    protected abstract String getUnit();
}

