/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.util.BlockPos;
import alternate.current.util.BlockState;
import alternate.current.wire.Node;
import alternate.current.wire.WireConnectionManager;
import alternate.current.wire.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WireNode
extends Node {
    final WireConnectionManager connections;
    int currentPower;
    int virtualPower;
    int externalPower;
    int flowIn;
    int iFlowDir;
    boolean added;
    boolean removed;
    boolean shouldBreak;
    boolean root;
    boolean discovered;
    boolean searched;
    WireNode next_wire;

    WireNode(WorldServer world, BlockPos pos, BlockState state) {
        super(world);
        this.pos = pos;
        this.state = state;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = this.state.get();
        this.priority = this.priority();
    }

    @Override
    Node set(BlockPos pos, BlockState state, boolean clearNeighbors) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    int priority() {
        return MathHelper.func_76125_a((int)this.virtualPower, (int)0, (int)15);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    boolean offerPower(int power, int iDir) {
        if (this.removed || this.shouldBreak) {
            return false;
        }
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    boolean setPower() {
        if (this.removed) {
            return true;
        }
        this.state = WorldHelper.getBlockState(this.world, this.pos);
        if (!this.state.is((Block)Blocks.field_150488_af)) {
            return false;
        }
        if (this.shouldBreak) {
            this.state.dropAsItem((World)this.world, this.pos);
            this.world.func_147468_f(this.pos.x, this.pos.y, this.pos.z);
            return true;
        }
        this.currentPower = MathHelper.func_76125_a((int)this.virtualPower, (int)0, (int)15);
        this.state = this.state.with(this.currentPower);
        return WorldHelper.setWireState(this.world, this.pos, this.state);
    }
}

