/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.util.BlockPos;
import alternate.current.util.BlockState;
import alternate.current.util.Direction;
import alternate.current.wire.Node;
import alternate.current.wire.PriorityQueue;
import alternate.current.wire.SimpleQueue;
import alternate.current.wire.WireNode;
import alternate.current.wire.WorldHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WireHandler {
    static final int[] FLOW_IN_TO_FLOW_OUT = new int[]{-1, 0, 1, 1, 2, -1, 2, 1, 3, 0, -1, 0, 3, 3, 2, -1};
    static final int[][] FULL_UPDATE_ORDERS = new int[][]{{0, 2, 1, 3, 4, 5}, {1, 3, 2, 0, 4, 5}, {2, 0, 3, 1, 4, 5}, {3, 1, 0, 2, 4, 5}};
    static final int[] DEFAULT_FULL_UPDATE_ORDER = FULL_UPDATE_ORDERS[0];
    static final int[][] CARDINAL_UPDATE_ORDERS = new int[][]{{0, 2, 1, 3}, {1, 3, 2, 0}, {2, 0, 3, 1}, {3, 1, 0, 2}};
    static final int[] DEFAULT_CARDINAL_UPDATE_ORDER = CARDINAL_UPDATE_ORDERS[0];
    private static final int POWER_MIN = 0;
    private static final int POWER_MAX = 15;
    private static final int POWER_STEP = 1;
    private final WorldServer world;
    private final Map<BlockPos, Node> nodes;
    private final Queue<WireNode> search;
    private final Queue<Node> updates;
    private Node[] nodeCache;
    private int nodeCount;
    private boolean updating;

    public WireHandler(WorldServer world) {
        this.world = world;
        this.nodes = new HashMap<BlockPos, Node>();
        this.search = new SimpleQueue();
        this.updates = new PriorityQueue();
        this.nodeCache = new Node[16];
        this.fillNodeCache(0, 16);
    }

    private Node getOrAddNode(BlockPos pos) {
        return this.nodes.compute(pos, (key, node) -> {
            if (node == null) {
                return this.getNextNode(pos);
            }
            if (node.invalid) {
                return this.revalidateNode((Node)node);
            }
            return node;
        });
    }

    private Node removeNode(BlockPos pos) {
        return this.nodes.remove(pos);
    }

    private Node getNextNode(BlockPos pos) {
        return this.getNextNode(pos, WorldHelper.getBlockState(this.world, pos));
    }

    private Node getNextNode(BlockPos pos, BlockState state) {
        return state.is((Block)Blocks.field_150488_af) ? new WireNode(this.world, pos, state) : this.getNextNode().set(pos, state, true);
    }

    private Node getNextNode() {
        if (this.nodeCount == this.nodeCache.length) {
            this.increaseNodeCache();
        }
        return this.nodeCache[this.nodeCount++];
    }

    private void increaseNodeCache() {
        Node[] oldCache = this.nodeCache;
        this.nodeCache = new Node[oldCache.length << 1];
        for (int index = 0; index < oldCache.length; ++index) {
            this.nodeCache[index] = oldCache[index];
        }
        this.fillNodeCache(oldCache.length, this.nodeCache.length);
    }

    private void fillNodeCache(int start, int end) {
        for (int index = start; index < end; ++index) {
            this.nodeCache[index] = new Node(this.world);
        }
    }

    private Node revalidateNode(Node node) {
        boolean isWire;
        BlockPos pos = node.pos;
        BlockState state = WorldHelper.getBlockState(this.world, pos);
        boolean wasWire = node.isWire();
        if (wasWire != (isWire = state.is((Block)Blocks.field_150488_af))) {
            return this.getNextNode(pos, state);
        }
        node.invalid = false;
        if (isWire) {
            WireNode wire = node.asWire();
            wire.root = false;
            wire.discovered = false;
            wire.searched = false;
        } else {
            node.set(pos, state, false);
        }
        return node;
    }

    private Node getNeighbor(Node node, int iDir) {
        Node neighbor = node.neighbors[iDir];
        if (neighbor == null || neighbor.invalid) {
            Direction dir = Directions.ALL[iDir];
            BlockPos pos = node.pos.offset(dir);
            Node oldNeighbor = neighbor;
            neighbor = this.getOrAddNode(pos);
            if (neighbor != oldNeighbor) {
                int iOpp = Directions.iOpposite(iDir);
                node.neighbors[iDir] = neighbor;
                neighbor.neighbors[iOpp] = node;
            }
        }
        return neighbor;
    }

    private void forEachNeighbor(WireNode wire, Consumer<Node> consumer) {
        int forward = wire.iFlowDir;
        int rightward = forward + 1 & 3;
        int backward = forward + 2 & 3;
        int leftward = forward + 3 & 3;
        int downward = 4;
        int upward = 5;
        Node front = this.getNeighbor(wire, forward);
        Node right = this.getNeighbor(wire, rightward);
        Node back = this.getNeighbor(wire, backward);
        Node left = this.getNeighbor(wire, leftward);
        Node below = this.getNeighbor(wire, downward);
        Node above = this.getNeighbor(wire, upward);
        consumer.accept(front);
        consumer.accept(back);
        consumer.accept(right);
        consumer.accept(left);
        consumer.accept(below);
        consumer.accept(above);
        consumer.accept(this.getNeighbor(front, rightward));
        consumer.accept(this.getNeighbor(back, leftward));
        consumer.accept(this.getNeighbor(front, leftward));
        consumer.accept(this.getNeighbor(back, rightward));
        consumer.accept(this.getNeighbor(front, downward));
        consumer.accept(this.getNeighbor(back, upward));
        consumer.accept(this.getNeighbor(front, upward));
        consumer.accept(this.getNeighbor(back, downward));
        consumer.accept(this.getNeighbor(right, downward));
        consumer.accept(this.getNeighbor(left, upward));
        consumer.accept(this.getNeighbor(right, upward));
        consumer.accept(this.getNeighbor(left, downward));
        consumer.accept(this.getNeighbor(front, forward));
        consumer.accept(this.getNeighbor(back, backward));
        consumer.accept(this.getNeighbor(right, rightward));
        consumer.accept(this.getNeighbor(left, leftward));
        consumer.accept(this.getNeighbor(below, downward));
        consumer.accept(this.getNeighbor(above, upward));
    }

    public void onWireUpdated(BlockPos pos) {
        this.invalidate();
        this.findRoots(pos);
        this.tryUpdate();
    }

    public void onWireAdded(BlockPos pos) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire()) {
            return;
        }
        WireNode wire = node.asWire();
        wire.added = true;
        this.invalidate();
        this.revalidateNode(wire);
        this.findRoot(wire);
        this.tryUpdate();
    }

    public void onWireRemoved(BlockPos pos, BlockState state) {
        Node node = this.removeNode(pos);
        WireNode wire = node == null || !node.isWire() ? new WireNode(this.world, pos, state) : node.asWire();
        wire.invalid = true;
        wire.removed = true;
        if (this.updating && wire.shouldBreak) {
            return;
        }
        this.invalidate();
        this.revalidateNode(wire);
        this.findRoot(wire);
        this.tryUpdate();
    }

    private void invalidate() {
        if (this.updating && !this.nodes.isEmpty()) {
            this.nodes.forEach((key, node) -> {
                node.invalid = true;
            });
        }
    }

    private void findRoots(BlockPos pos) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire()) {
            return;
        }
        WireNode wire = node.asWire();
        this.findRoot(wire);
        if (!wire.searched || wire.connections.total == 0) {
            return;
        }
        for (int iDir : FULL_UPDATE_ORDERS[wire.iFlowDir]) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (!neighbor.isConductor() && !neighbor.isSignalSource()) continue;
            this.findRootsAround(neighbor, Directions.iOpposite(iDir));
        }
    }

    private void findRootsAround(Node node, int except) {
        for (int iDir : Directions.I_EXCEPT_CARDINAL[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isWire()) continue;
            this.findRoot(neighbor.asWire());
        }
    }

    private void findRoot(WireNode wire) {
        if (wire.discovered) {
            return;
        }
        this.discover(wire);
        this.findExternalPower(wire);
        this.findPower(wire, false);
        if (this.needsUpdate(wire)) {
            this.searchRoot(wire);
        }
    }

    private void discover(WireNode wire) {
        if (wire.discovered) {
            return;
        }
        wire.discovered = true;
        wire.searched = false;
        if (!(wire.removed || wire.shouldBreak || wire.state.canSurviveAt((World)this.world, wire.pos))) {
            wire.shouldBreak = true;
        }
        wire.virtualPower = wire.currentPower;
        wire.externalPower = -1;
        wire.connections.set(this::getNeighbor);
    }

    private void findPower(WireNode wire, boolean ignoreSearched) {
        wire.virtualPower = wire.externalPower;
        wire.flowIn = 0;
        if (wire.removed || wire.shouldBreak) {
            return;
        }
        if (wire.externalPower < 14) {
            this.findWirePower(wire, ignoreSearched);
        }
    }

    private void findWirePower(WireNode wire, boolean ignoreSearched) {
        wire.connections.forEach(connection -> {
            if (!connection.accept) {
                return;
            }
            WireNode neighbor = connection.wire;
            if (!ignoreSearched || !neighbor.searched) {
                int power = Math.max(0, neighbor.virtualPower - 1);
                int iOpp = Directions.iOpposite(connection.iDir);
                wire.offerPower(power, iOpp);
            }
        });
    }

    private void findExternalPower(WireNode wire) {
        if (wire.removed || wire.shouldBreak || wire.externalPower >= 0) {
            return;
        }
        wire.externalPower = this.getExternalPower(wire);
        if (wire.externalPower > wire.virtualPower) {
            wire.virtualPower = wire.externalPower;
        }
    }

    private int getExternalPower(WireNode wire) {
        int power = 0;
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isWire()) continue;
            if (neighbor.isConductor()) {
                power = Math.max(power, this.getDirectSignalTo(wire, neighbor, Directions.iOpposite(iDir)));
            }
            if (neighbor.isSignalSource()) {
                power = Math.max(power, neighbor.state.getSignal((World)this.world, neighbor.pos, Directions.ALL[iDir]));
            }
            if (power < 15) continue;
            return 15;
        }
        return power;
    }

    private int getDirectSignalTo(WireNode wire, Node node, int except) {
        int power = 0;
        for (int iDir : Directions.I_EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isSignalSource() || (power = Math.max(power, neighbor.state.getDirectSignal((World)this.world, neighbor.pos, Directions.ALL[iDir]))) < 15) continue;
            return 15;
        }
        return power;
    }

    private boolean needsUpdate(WireNode wire) {
        return wire.removed || wire.shouldBreak || wire.virtualPower != wire.currentPower;
    }

    private void searchRoot(WireNode wire) {
        int iBackupFlowDir = wire.connections.iFlowDir < 0 ? 0 : wire.connections.iFlowDir;
        this.search(wire, true, iBackupFlowDir);
    }

    private void search(WireNode wire, boolean root, int iBackupFlowDir) {
        this.search.offer(wire);
        wire.root = root;
        wire.searched = true;
        wire.iFlowDir = iBackupFlowDir;
    }

    private void tryUpdate() {
        if (!this.search.isEmpty()) {
            this.update();
        }
        if (!this.updating) {
            this.nodes.clear();
            this.nodeCount = 0;
        }
    }

    private void update() {
        this.searchNetwork();
        this.depowerNetwork();
        try {
            this.powerNetwork();
        }
        catch (Throwable t) {
            this.updating = false;
            throw t;
        }
    }

    private void searchNetwork() {
        for (WireNode wire : this.search) {
            wire.connections.forEach(connection -> {
                if (!connection.offer) {
                    return;
                }
                WireNode neighbor = connection.wire;
                if (neighbor.searched) {
                    return;
                }
                this.discover(neighbor);
                this.findPower(neighbor, false);
                if (neighbor.virtualPower < neighbor.currentPower) {
                    this.findExternalPower(neighbor);
                }
                if (this.needsUpdate(neighbor)) {
                    this.search(neighbor, false, connection.iDir);
                }
            }, wire.iFlowDir);
        }
    }

    private void depowerNetwork() {
        while (!this.search.isEmpty()) {
            WireNode wire = this.search.poll();
            this.findPower(wire, true);
            if (wire.root || wire.removed || wire.shouldBreak || wire.virtualPower > 0) {
                this.queueWire(wire);
                continue;
            }
            --wire.virtualPower;
        }
    }

    private void powerNetwork() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        while (!this.updates.isEmpty()) {
            Node node = this.updates.poll();
            if (node.isWire()) {
                WireNode wire = node.asWire();
                if (!this.needsUpdate(wire)) continue;
                this.findPowerFlow(wire);
                this.transmitPower(wire);
                if (!wire.setPower()) continue;
                this.queueNeighbors(wire);
                continue;
            }
            WireNode neighborWire = node.neighborWire;
            if (neighborWire == null) continue;
            BlockPos neighborPos = neighborWire.pos;
            Block neighborBlock = neighborWire.state.getBlock();
            this.updateBlock(node, neighborPos, neighborBlock);
        }
        this.updating = false;
    }

    private void findPowerFlow(WireNode wire) {
        int flow = FLOW_IN_TO_FLOW_OUT[wire.flowIn];
        if (flow >= 0) {
            wire.iFlowDir = flow;
        } else if (wire.connections.iFlowDir >= 0) {
            wire.iFlowDir = wire.connections.iFlowDir;
        }
    }

    private void transmitPower(WireNode wire) {
        wire.connections.forEach(connection -> {
            int iDir;
            if (!connection.offer) {
                return;
            }
            WireNode neighbor = connection.wire;
            int power = Math.max(0, wire.virtualPower - 1);
            if (neighbor.offerPower(power, iDir = connection.iDir)) {
                this.queueWire(neighbor);
            }
        }, wire.iFlowDir);
    }

    private void queueNeighbors(WireNode wire) {
        this.forEachNeighbor(wire, neighbor -> this.queueNeighbor((Node)neighbor, wire));
    }

    private void queueNeighbor(Node node, WireNode neighborWire) {
        if (!node.isWire()) {
            node.neighborWire = neighborWire;
            this.updates.offer(node);
        }
    }

    private void queueWire(WireNode wire) {
        if (this.needsUpdate(wire)) {
            this.updates.offer(wire);
        } else {
            this.findPowerFlow(wire);
            this.transmitPower(wire);
        }
    }

    private void updateBlock(Node node, BlockPos neighborPos, Block neighborBlock) {
        BlockPos pos = node.pos;
        BlockState state = WorldHelper.getBlockState(this.world, pos);
        if (!state.isAir() && !state.is((Block)Blocks.field_150488_af)) {
            state.neighborChanged((World)this.world, pos, neighborBlock);
        }
    }

    public static class Directions {
        public static final Direction[] ALL = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.DOWN, Direction.UP};
        public static final Direction[] HORIZONTAL = new Direction[]{Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH};
        public static final int WEST = 0;
        public static final int NORTH = 1;
        public static final int EAST = 2;
        public static final int SOUTH = 3;
        public static final int DOWN = 4;
        public static final int UP = 5;
        private static final int[][] I_EXCEPT = new int[][]{{1, 2, 3, 4, 5}, {0, 2, 3, 4, 5}, {0, 1, 3, 4, 5}, {0, 1, 2, 4, 5}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 4}};
        private static final int[][] I_EXCEPT_CARDINAL = new int[][]{{1, 2, 3}, {0, 2, 3}, {0, 1, 3}, {0, 1, 2}, {0, 1, 2, 3}, {0, 1, 2, 3}};

        public static int iOpposite(int iDir) {
            return iDir ^ 2 >>> (iDir >>> 2);
        }
    }

    @FunctionalInterface
    public static interface NodeProvider {
        public Node getNeighbor(Node var1, int var2);
    }
}

