/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.packet;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.Log;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TeleportEntityEvent;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.teleport.ItemTeleportStaff;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketLongDistanceTravelEvent
implements IMessage,
IMessageHandler<PacketLongDistanceTravelEvent, IMessage> {
    boolean conserveMotion;
    int entityId;
    int source;
    boolean alsoDoTeleport;
    int tpX;
    int tpY;
    int tpZ;

    public PacketLongDistanceTravelEvent() {
    }

    public PacketLongDistanceTravelEvent(Entity entity, boolean conserveMotion, TravelSource source) {
        this(entity, conserveMotion, source, false, 0, 0, 0);
    }

    public PacketLongDistanceTravelEvent(Entity entity, boolean conserveMotion, TravelSource source, boolean alsoDoTeleport, int tpX, int tpY, int tpZ) {
        this.conserveMotion = conserveMotion;
        this.entityId = entity instanceof EntityPlayer ? -1 : entity.func_145782_y();
        this.source = source.ordinal();
        this.alsoDoTeleport = alsoDoTeleport;
        this.tpX = tpX;
        this.tpY = tpY;
        this.tpZ = tpZ;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.conserveMotion);
        buf.writeInt(this.entityId);
        buf.writeInt(this.source);
        buf.writeBoolean(this.alsoDoTeleport);
        buf.writeInt(this.tpX);
        buf.writeInt(this.tpY);
        buf.writeInt(this.tpZ);
    }

    public void fromBytes(ByteBuf buf) {
        this.conserveMotion = buf.readBoolean();
        this.entityId = buf.readInt();
        this.source = buf.readInt();
        this.alsoDoTeleport = buf.readBoolean();
        this.tpX = buf.readInt();
        this.tpY = buf.readInt();
        this.tpZ = buf.readInt();
    }

    public IMessage onMessage(PacketLongDistanceTravelEvent message, MessageContext ctx) {
        if (message.entityId != -1) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to illegally tp other entity {}.", new Object[]{ctx.getServerHandler().field_147369_b.func_146103_bH(), message.entityId});
            return null;
        }
        EntityPlayerMP toTp = ctx.getServerHandler().field_147369_b;
        TravelSource source = TravelSource.values()[message.source];
        if (!PacketLongDistanceTravelEvent.validate(toTp, source, message.conserveMotion, message.alsoDoTeleport, message.tpX, message.tpY, message.tpZ)) {
            Log.LOGGER.warn(Log.securityMarker, "Player {} tried to tp without valid prereq.", new Object[]{ctx.getServerHandler().field_147369_b.func_146103_bH()});
            return null;
        }
        PacketLongDistanceTravelEvent.doServerTeleport((Entity)toTp, message.conserveMotion, source, message.alsoDoTeleport, message.tpX, message.tpY, message.tpZ);
        return null;
    }

    private static boolean validate(EntityPlayerMP toTp, TravelSource source, boolean conserveMotion, boolean alsoDoTeleport, int tpX, int tpY, int tpZ) {
        ItemStack equippedItem = toTp.func_71045_bC();
        switch (source) {
            case STAFF: {
                if (alsoDoTeleport) {
                    return false;
                }
                return equippedItem != null && equippedItem.func_77973_b() instanceof IItemOfTravel && ((IItemOfTravel)equippedItem.func_77973_b()).isActive((EntityPlayer)toTp, equippedItem);
            }
            case TELEPORT_STAFF: {
                String error;
                if (alsoDoTeleport && (error = TravelController.instance.validatePacketTravelEvent(toTp, tpX, tpY, tpZ, 0, conserveMotion, source)) != null) {
                    return false;
                }
                return equippedItem != null && equippedItem.func_77973_b() instanceof ItemTeleportStaff;
            }
        }
        return false;
    }

    public static boolean doServerTeleport(Entity toTp, boolean conserveMotion, TravelSource source, boolean alsoDoTeleport, int tpX, int tpY, int tpZ) {
        int used;
        ITravelAccessable ta;
        if (!(toTp instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)toTp;
        Optional<BlockCoord> travelDestination = TravelController.instance.findTravelDestination(player, source);
        if (!travelDestination.isPresent()) {
            if (alsoDoTeleport) {
                return PacketTravelEvent.doServerTeleport(toTp, tpX, tpY, tpZ, 0, conserveMotion, source);
            }
            return false;
        }
        BlockCoord targetBlock = travelDestination.get();
        TileEntity te = player.field_70170_p.func_147438_o(targetBlock.x, targetBlock.y, targetBlock.z);
        if (te instanceof ITravelAccessable && !(ta = (ITravelAccessable)te).canBlockBeAccessed(player)) {
            TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.gui.travelAccessable.unauthorised", new Object[0]));
            return false;
        }
        BlockCoord destination = targetBlock.getLocation(ForgeDirection.UP);
        if (!TravelController.instance.isValidTarget(player, destination, source)) {
            TravelController.showMessage(player, (IChatComponent)new ChatComponentTranslation("enderio.blockTravelPlatform.invalidTarget", new Object[0]));
            return false;
        }
        int x = destination.x;
        int y = destination.y;
        int z = destination.z;
        int powerUse = TravelController.instance.getRequiredPower(player, source, destination);
        if (powerUse < 0) {
            return false;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemOfTravel && (used = ((IItemOfTravel)player.func_71045_bC().func_77973_b()).canExtractInternal(player.func_71045_bC(), powerUse)) != -1 && used != powerUse) {
            return false;
        }
        TeleportEntityEvent evt = new TeleportEntityEvent(toTp, source, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
            return false;
        }
        x = evt.targetX;
        y = evt.targetY;
        z = evt.targetZ;
        toTp.field_70170_p.func_72908_a(toTp.field_70165_t, toTp.field_70163_u, toTp.field_70161_v, source.sound, 1.0f, 1.0f);
        toTp.func_85030_a(source.sound, 1.0f, 1.0f);
        player.func_70634_a((double)x + 0.5, (double)y + 0.1, (double)z + 0.5);
        player.field_70170_p.func_72908_a((double)x, (double)y, (double)z, source.sound, 1.0f, 1.0f);
        player.field_70143_R = 0.0f;
        if (conserveMotion) {
            Vector3d velocityVex = Util.getLookVecEio((EntityPlayer)player);
            S12PacketEntityVelocity p = new S12PacketEntityVelocity(toTp.func_145782_y(), velocityVex.x, velocityVex.y, velocityVex.z);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)p);
        }
        if (powerUse > 0 && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemOfTravel) {
            ItemStack item = player.func_71045_bC().func_77946_l();
            ((IItemOfTravel)item.func_77973_b()).extractInternal(item, powerUse);
            toTp.func_70062_b(0, item);
        }
        return true;
    }
}

