/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class ConduitNetworkTickHandler {
    private final List<TickListener> listeners = new ArrayList<TickListener>();
    private final IdentityHashMap<AbstractConduitNetwork<?, ?>, Boolean> networks = new IdentityHashMap();

    public void addListener(TickListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TickListener listener) {
        this.listeners.remove(listener);
    }

    public void registerNetwork(AbstractConduitNetwork<?, ?> cn) {
        this.networks.put(cn, Boolean.TRUE);
    }

    public void unregisterNetwork(AbstractConduitNetwork<?, ?> cn) {
        this.networks.remove(cn);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart(event);
        } else {
            this.tickEnd(event);
        }
    }

    public void tickStart(TickEvent.ServerTickEvent event) {
        for (TickListener h : this.listeners) {
            h.tickStart(event);
        }
    }

    public void tickEnd(TickEvent.ServerTickEvent event) {
        for (TickListener tickListener : this.listeners) {
            tickListener.tickEnd(event);
        }
        this.listeners.clear();
        for (AbstractConduitNetwork abstractConduitNetwork : this.networks.keySet()) {
            abstractConduitNetwork.doNetworkTick();
        }
    }

    public static interface TickListener {
        public void tickStart(TickEvent.ServerTickEvent var1);

        public void tickEnd(TickEvent.ServerTickEvent var1);
    }
}

