/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.web;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.dynmap.shadow.javax.servlet.Filter;
import org.dynmap.shadow.javax.servlet.FilterChain;
import org.dynmap.shadow.javax.servlet.ServletException;
import org.dynmap.shadow.javax.servlet.ServletRequest;
import org.dynmap.shadow.javax.servlet.ServletResponse;
import org.dynmap.shadow.javax.servlet.http.HttpServletRequest;
import org.dynmap.shadow.javax.servlet.http.HttpServletResponse;
import org.dynmap.shadow.org.eclipse.jetty.server.Handler;
import org.dynmap.shadow.org.eclipse.jetty.server.Request;
import org.dynmap.shadow.org.eclipse.jetty.server.handler.AbstractHandler;
import org.dynmap.shadow.org.eclipse.jetty.servlet.FilterHolder;

public class FilterHandler
extends AbstractHandler {
    private Handler handler;
    private LinkedList<FilterHolder> filters = new LinkedList();

    public FilterHandler() {
    }

    public FilterHandler(Handler handler, Iterable<Filter> filters) {
        this.handler = handler;
        for (Filter f : filters) {
            this.filters.add(new FilterHolder(f));
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Iterable<FilterHolder> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        this.filters.add(new FilterHolder(filter));
    }

    @Override
    public void handle(final String target, final Request baseRequest, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        final Handler handler = this.getHandler();
        final Iterator<FilterHolder> iterator = this.getFilters().iterator();
        FilterChain chain = new FilterChain(){

            @Override
            public void doFilter(ServletRequest re, ServletResponse rs) throws IOException, ServletException {
                if (iterator.hasNext()) {
                    Filter f = ((FilterHolder)iterator.next()).getFilter();
                    f.doFilter(request, response, this);
                } else {
                    handler.handle(target, baseRequest, request, response);
                }
            }
        };
        chain.doFilter(request, response);
    }
}

